/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.util;

import java.util.Arrays;

public final class NumberFactory {
    private static final long DOUBLE_HIGH_BITS = 0x3FF0000000000000L;
    private static final float FLOAT_MULTIPLIER = 1.1920929E-7f;
    private static final double DOUBLE_MULTIPLIER = 2.220446049250313E-16;
    private static final long LONG_LOWEST_BYTE_MASK = 255L;
    private static final int LONG_SIZE = 8;
    private static final int INT_LOWEST_BYTE_MASK = 255;
    private static final int INT_SIZE = 4;

    private NumberFactory() {
    }

    public static boolean makeBoolean(int v) {
        return v >>> 31 != 0;
    }

    public static boolean makeBoolean(long v) {
        return v >>> 63 != 0L;
    }

    public static double makeDouble(long v) {
        return Double.longBitsToDouble(0x3FF0000000000000L | v >>> 12) - 1.0;
    }

    public static double makeDouble(int v, int w) {
        long high = (long)(v >>> 6) << 26;
        int low = w >>> 6;
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    public static float makeFloat(int v) {
        return (float)(v >>> 9) * 1.1920929E-7f;
    }

    public static long makeLong(int v, int w) {
        return (long)v << 32 | (long)w & 0xFFFFFFFFL;
    }

    public static int makeInt(long v) {
        return NumberFactory.extractHi(v) ^ NumberFactory.extractLo(v);
    }

    public static int extractHi(long v) {
        return (int)(v >>> 32);
    }

    public static int extractLo(long v) {
        return (int)v;
    }

    public static byte[] makeByteArray(long v) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int shift = i * 8;
            b[i] = (byte)(v >>> shift & 0xFFL);
        }
        return b;
    }

    public static long makeLong(byte[] input) {
        NumberFactory.checkSize(8, input.length);
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            int shift = i * 8;
            v |= ((long)input[i] & 0xFFL) << shift;
        }
        return v;
    }

    public static byte[] makeByteArray(long[] input) {
        int size = input.length * 8;
        byte[] b = new byte[size];
        for (int i = 0; i < input.length; ++i) {
            byte[] current = NumberFactory.makeByteArray(input[i]);
            System.arraycopy(current, 0, b, i * 8, 8);
        }
        return b;
    }

    public static long[] makeLongArray(byte[] input) {
        int size = input.length;
        int num = size / 8;
        NumberFactory.checkSize(num * 8, size);
        long[] output = new long[num];
        for (int i = 0; i < num; ++i) {
            int from = i * 8;
            byte[] current = Arrays.copyOfRange(input, from, from + 8);
            output[i] = NumberFactory.makeLong(current);
        }
        return output;
    }

    public static byte[] makeByteArray(int v) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int shift = i * 8;
            b[i] = (byte)(v >>> shift & 0xFF);
        }
        return b;
    }

    public static int makeInt(byte[] input) {
        NumberFactory.checkSize(4, input.length);
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = i * 8;
            v |= (input[i] & 0xFF) << shift;
        }
        return v;
    }

    public static byte[] makeByteArray(int[] input) {
        int size = input.length * 4;
        byte[] b = new byte[size];
        for (int i = 0; i < input.length; ++i) {
            byte[] current = NumberFactory.makeByteArray(input[i]);
            System.arraycopy(current, 0, b, i * 4, 4);
        }
        return b;
    }

    public static int[] makeIntArray(byte[] input) {
        int size = input.length;
        int num = size / 4;
        NumberFactory.checkSize(num * 4, size);
        int[] output = new int[num];
        for (int i = 0; i < num; ++i) {
            int from = i * 4;
            byte[] current = Arrays.copyOfRange(input, from, from + 4);
            output[i] = NumberFactory.makeInt(current);
        }
        return output;
    }

    private static void checkSize(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException("Array size: Expected " + expected + " but was " + actual);
        }
    }
}

