/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.Arrays;
import org.apache.commons.rng.UniformRandomProvider;

public class PermutationSampler {
    private final int[] domain;
    private final int size;
    private final UniformRandomProvider rng;

    public PermutationSampler(UniformRandomProvider rng, int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException(n + " < " + 0);
        }
        if (k <= 0) {
            throw new IllegalArgumentException(k + " <= " + 0);
        }
        if (k > n) {
            throw new IllegalArgumentException(k + " > " + n);
        }
        this.domain = PermutationSampler.natural(n);
        this.size = k;
        this.rng = rng;
    }

    public int[] sample() {
        PermutationSampler.shuffle(this.rng, this.domain);
        return Arrays.copyOf(this.domain, this.size);
    }

    public static void shuffle(UniformRandomProvider rng, int[] list) {
        PermutationSampler.shuffle(rng, list, 0, false);
    }

    public static void shuffle(UniformRandomProvider rng, int[] list, int start, boolean towardHead) {
        if (towardHead) {
            for (int i = 0; i <= start; ++i) {
                int target = i == start ? start : rng.nextInt(start - i + 1) + i;
                int temp = list[target];
                list[target] = list[i];
                list[i] = temp;
            }
        } else {
            for (int i = list.length - 1; i >= start; --i) {
                int target = i == start ? start : rng.nextInt(i - start + 1) + start;
                int temp = list[target];
                list[target] = list[i];
                list[i] = temp;
            }
        }
    }

    public static int[] natural(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = i;
        }
        return a;
    }
}

