/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class ChengBetaSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private static final double LN_4 = Math.log(4.0);
    private final SharedStateContinuousSampler delegate;

    public ChengBetaSampler(UniformRandomProvider rng, double alpha, double beta) {
        super(null);
        this.delegate = ChengBetaSampler.of(rng, alpha, beta);
    }

    @Override
    public double sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return (SharedStateContinuousSampler)this.delegate.withUniformRandomProvider(rng);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double alpha, double beta) {
        boolean aIsAlphaShape;
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha is not strictly positive: " + alpha);
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta is not strictly positive: " + beta);
        }
        double a = Math.min(alpha, beta);
        double b = Math.max(alpha, beta);
        boolean bl = aIsAlphaShape = a == alpha;
        return a > 1.0 ? new ChengBBBetaSampler(rng, aIsAlphaShape, a, b) : new ChengBCBetaSampler(rng, !aIsAlphaShape, b, a);
    }

    private static class ChengBCBetaSampler
    extends BaseChengBetaSampler {
        private static final double ONE_HALF = 0.5;
        private static final double ONE_QUARTER = 0.25;
        private final double beta;
        private final double delta;
        private final double k1;
        private final double k2;

        ChengBCBetaSampler(UniformRandomProvider rng, boolean aIsAlphaShape, double a, double b) {
            super(rng, aIsAlphaShape, a, b);
            this.beta = 1.0 / b;
            this.delta = 1.0 + a - b;
            this.k1 = this.delta * (0.013888888888888888 + 0.041666666666666664 * b) / (a * this.beta - 0.7777777777777778);
            this.k2 = 0.25 + (0.5 + 0.25 / this.delta) * b;
        }

        private ChengBCBetaSampler(UniformRandomProvider rng, ChengBCBetaSampler source) {
            super(rng, source);
            this.beta = source.beta;
            this.delta = source.delta;
            this.k1 = source.k1;
            this.k2 = source.k2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public double sample() {
            while (true) {
                double w;
                double v;
                double u1 = this.rng.nextDouble();
                double u2 = this.rng.nextDouble();
                double y = u1 * u2;
                double z = u1 * y;
                if (u1 < 0.5) {
                    if (0.25 * u2 + z - y >= this.k1) {
                        continue;
                    }
                } else {
                    if (z <= 0.25) {
                        v = this.beta * (Math.log(u1) - Math.log1p(-u1));
                        w = this.a * Math.exp(v);
                        return this.computeX(w);
                    }
                    if (z >= this.k2) continue;
                }
                if (this.alpha * (this.logAlpha - Math.log(this.b + (w = this.a * Math.exp(v = this.beta * (Math.log(u1) - Math.log1p(-u1))))) + v) - LN_4 >= Math.log(z)) return this.computeX(w);
            }
        }

        @Override
        public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new ChengBCBetaSampler(rng, this);
        }
    }

    private static class ChengBBBetaSampler
    extends BaseChengBetaSampler {
        private static final double LN_5_P1 = 1.0 + Math.log(5.0);
        private final double beta;
        private final double gamma;

        ChengBBBetaSampler(UniformRandomProvider rng, boolean aIsAlphaShape, double a, double b) {
            super(rng, aIsAlphaShape, a, b);
            this.beta = Math.sqrt((this.alpha - 2.0) / (2.0 * a * b - this.alpha));
            this.gamma = a + 1.0 / this.beta;
        }

        private ChengBBBetaSampler(UniformRandomProvider rng, ChengBBBetaSampler source) {
            super(rng, source);
            this.beta = source.beta;
            this.gamma = source.gamma;
        }

        @Override
        public double sample() {
            double t;
            double z;
            double w;
            double v;
            double r;
            double s;
            do {
                double u1 = this.rng.nextDouble();
                double u2 = this.rng.nextDouble();
                v = this.beta * (Math.log(u1) - Math.log1p(-u1));
                w = this.a * Math.exp(v);
                z = u1 * u1 * u2;
            } while (!((s = this.a + (r = this.gamma * v - LN_4) - w) + LN_5_P1 >= 5.0 * z) && !(s >= (t = Math.log(z))) && r + this.alpha * (this.logAlpha - Math.log(this.b + w)) < t);
            return this.computeX(w);
        }

        @Override
        public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new ChengBBBetaSampler(rng, this);
        }
    }

    private static abstract class BaseChengBetaSampler
    implements SharedStateContinuousSampler {
        protected final boolean aIsAlphaShape;
        protected final double a;
        protected final double b;
        protected final UniformRandomProvider rng;
        protected final double alpha;
        protected final double logAlpha;

        BaseChengBetaSampler(UniformRandomProvider rng, boolean aIsAlphaShape, double a, double b) {
            this.rng = rng;
            this.aIsAlphaShape = aIsAlphaShape;
            this.a = a;
            this.b = b;
            this.alpha = a + b;
            this.logAlpha = Math.log(this.alpha);
        }

        private BaseChengBetaSampler(UniformRandomProvider rng, BaseChengBetaSampler source) {
            this.rng = rng;
            this.aIsAlphaShape = source.aIsAlphaShape;
            this.a = source.a;
            this.b = source.b;
            this.alpha = source.alpha;
            this.logAlpha = source.logAlpha;
        }

        public String toString() {
            return "Cheng Beta deviate [" + this.rng.toString() + "]";
        }

        protected double computeX(double w) {
            double tmp = Math.min(w, Double.MAX_VALUE);
            return this.aIsAlphaShape ? tmp / (this.b + tmp) : this.b / (this.b + tmp);
        }
    }
}

