/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core;

import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;

public abstract class BaseProvider
implements RestorableUniformRandomProvider {
    private static final String NOT_POSITIVE = "Must be strictly positive: ";
    private static final long POW_32 = 0x100000000L;

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(NOT_POSITIVE + n);
        }
        long m = ((long)this.nextInt() & 0xFFFFFFFFL) * (long)n;
        long l = m & 0xFFFFFFFFL;
        if (l < (long)n) {
            long t = 0x100000000L % (long)n;
            while (l < t) {
                m = ((long)this.nextInt() & 0xFFFFFFFFL) * (long)n;
                l = m & 0xFFFFFFFFL;
            }
        }
        return (int)(m >>> 32);
    }

    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException(NOT_POSITIVE + n);
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public RandomProviderState saveState() {
        return new RandomProviderDefaultState(this.getStateInternal());
    }

    public void restoreState(RandomProviderState state) {
        if (!(state instanceof RandomProviderDefaultState)) {
            throw new IllegalArgumentException("Foreign instance");
        }
        this.setStateInternal(((RandomProviderDefaultState)state).getState());
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected byte[] composeStateInternal(byte[] state, byte[] parentState) {
        int len = parentState.length + state.length;
        byte[] c = new byte[len];
        System.arraycopy(state, 0, c, 0, state.length);
        System.arraycopy(parentState, 0, c, state.length, parentState.length);
        return c;
    }

    protected byte[][] splitStateInternal(byte[] state, int localStateLength) {
        this.checkStateSize(state, localStateLength);
        byte[] local = new byte[localStateLength];
        System.arraycopy(state, 0, local, 0, localStateLength);
        int parentLength = state.length - localStateLength;
        byte[] parent = new byte[parentLength];
        System.arraycopy(state, localStateLength, parent, 0, parentLength);
        return new byte[][]{local, parent};
    }

    protected byte[] getStateInternal() {
        return new byte[0];
    }

    protected void setStateInternal(byte[] state) {
        if (state.length != 0) {
            throw new IllegalStateException("State not fully recovered by subclasses");
        }
    }

    protected void fillState(int[] state, int[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = (int)(BaseProvider.scrambleWell(state[i - seed.length], i) & 0xFFFFFFFFL);
            }
        }
    }

    protected void fillState(long[] state, long[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = BaseProvider.scrambleWell(state[i - seed.length], i);
            }
        }
    }

    @Deprecated
    protected void checkStateSize(byte[] state, int expected) {
        if (state.length < expected) {
            throw new IllegalStateException("State size must be larger than " + expected + " but was " + state.length);
        }
    }

    protected void checkIndex(int min, int max, int index) {
        if (index < min || index > max) {
            throw new IndexOutOfBoundsException(index + " is out of interval [" + min + ", " + max + "]");
        }
    }

    private static long scramble(long n, long mult, int shift, int add) {
        return mult * (n ^ n >> shift) + (long)add;
    }

    private static long scrambleWell(long n, int add) {
        return BaseProvider.scramble(n, 1812433253L, 30, add);
    }
}

