/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class LongProvider
extends BaseProvider
implements RandomLongSource {
    private long booleanSource;
    private long booleanBitMask;
    private long intSource;
    private boolean cachedIntSource;

    public LongProvider() {
    }

    protected LongProvider(LongProvider source) {
        this.booleanSource = source.booleanSource;
        this.booleanBitMask = source.booleanBitMask;
        this.intSource = source.intSource;
        this.cachedIntSource = source.cachedIntSource;
    }

    protected void resetCachedState() {
        this.booleanSource = 0L;
        this.booleanBitMask = 0L;
        this.intSource = 0L;
        this.cachedIntSource = false;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] state = new long[]{this.booleanSource, this.booleanBitMask, this.intSource, this.cachedIntSource ? 1L : 0L};
        return this.composeStateInternal(NumberFactory.makeByteArray(state), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 32);
        long[] state = NumberFactory.makeLongArray(c[0]);
        this.booleanSource = state[0];
        this.booleanBitMask = state[1];
        this.intSource = state[2];
        this.cachedIntSource = state[3] != 0L;
        super.setStateInternal(c[1]);
    }

    public long nextLong() {
        return this.next();
    }

    public int nextInt() {
        if (this.cachedIntSource) {
            this.cachedIntSource = false;
            return NumberFactory.extractLo(this.intSource);
        }
        this.cachedIntSource = true;
        this.intSource = this.nextLong();
        return NumberFactory.extractHi(this.intSource);
    }

    public double nextDouble() {
        return NumberFactory.makeDouble(this.nextLong());
    }

    public boolean nextBoolean() {
        this.booleanBitMask <<= 1;
        if (this.booleanBitMask == 0L) {
            this.booleanBitMask = 1L;
            this.booleanSource = this.nextLong();
        }
        return (this.booleanSource & this.booleanBitMask) != 0L;
    }

    public float nextFloat() {
        return NumberFactory.makeFloat(this.nextInt());
    }

    public void nextBytes(byte[] bytes) {
        LongProvider.nextBytesFill(this, bytes, 0, bytes.length);
    }

    public void nextBytes(byte[] bytes, int start, int len) {
        this.checkIndex(0, bytes.length - 1, start);
        this.checkIndex(0, bytes.length - start, len);
        LongProvider.nextBytesFill(this, bytes, start, len);
    }

    static void nextBytesFill(RandomLongSource source, byte[] bytes, int start, int len) {
        int index = start;
        int indexLoopLimit = index + (len & 0x7FFFFFF8);
        while (index < indexLoopLimit) {
            long random = source.next();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
            bytes[index++] = (byte)(random >>> 32);
            bytes[index++] = (byte)(random >>> 40);
            bytes[index++] = (byte)(random >>> 48);
            bytes[index++] = (byte)(random >>> 56);
        }
        int indexLimit = start + len;
        if (index < indexLimit) {
            long random = source.next();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }
}

