/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class ContinuousUniformSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private static final int MIN_ULP_SAME_SIGN = 2;
    private static final int MIN_ULP_OPPOSITE_SIGN = 3;
    private final double lo;
    private final double hi;
    private final UniformRandomProvider rng;

    public ContinuousUniformSampler(UniformRandomProvider rng, double lo, double hi) {
        super(null);
        this.rng = rng;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double sample() {
        double u = this.rng.nextDouble();
        return u * this.hi + (1.0 - u) * this.lo;
    }

    double getLo() {
        return this.lo;
    }

    double getHi() {
        return this.hi;
    }

    @Override
    public String toString() {
        return "Uniform deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new ContinuousUniformSampler(rng, this.lo, this.hi);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double lo, double hi) {
        return new ContinuousUniformSampler(rng, lo, hi);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double lo, double hi, boolean excludeBounds) {
        if (excludeBounds) {
            if (!ContinuousUniformSampler.validateOpenInterval(lo, hi)) {
                throw new IllegalArgumentException("Invalid open interval (" + lo + "," + hi + ")");
            }
            return new OpenIntervalContinuousUniformSampler(rng, lo, hi);
        }
        return new ContinuousUniformSampler(rng, lo, hi);
    }

    private static boolean validateOpenInterval(double lo, double hi) {
        long bitsy;
        long bitsx = Double.doubleToRawLongBits(lo);
        return !((bitsx ^ (bitsy = Double.doubleToRawLongBits(hi))) < 0L ? ContinuousUniformSampler.lessThanUnsigned((bitsx &= Long.MAX_VALUE) + (bitsy &= Long.MAX_VALUE), 3L) : Math.abs(bitsx - bitsy) < 2L);
    }

    private static boolean lessThanUnsigned(long x, long y) {
        return x + Long.MIN_VALUE < y + Long.MIN_VALUE;
    }

    private static class OpenIntervalContinuousUniformSampler
    extends ContinuousUniformSampler {
        OpenIntervalContinuousUniformSampler(UniformRandomProvider rng, double lo, double hi) {
            super(rng, lo, hi);
        }

        @Override
        public double sample() {
            double x = super.sample();
            if (x == this.getHi() || x == this.getLo()) {
                return this.sample();
            }
            return x;
        }

        @Override
        public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new OpenIntervalContinuousUniformSampler(rng, this.getLo(), this.getHi());
        }
    }
}

