/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;

public class PoissonSamplerCache {
    private final int minN;
    private final int maxN;
    private final LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] values;

    public PoissonSamplerCache(double minMean, double maxMean) {
        PoissonSamplerCache.checkMeanRange(minMean, maxMean);
        if (maxMean < 40.0) {
            this.minN = 0;
            this.maxN = 0;
            this.values = null;
        } else {
            this.minN = (int)Math.floor(Math.max(minMean, 40.0));
            this.maxN = (int)Math.floor(Math.min(maxMean, 2.147483647E9));
            this.values = new LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[this.maxN - this.minN + 1];
        }
    }

    private PoissonSamplerCache(int minN, int maxN, LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] states) {
        this.minN = minN;
        this.maxN = maxN;
        this.values = states;
    }

    private static void checkMeanRange(double minMean, double maxMean) {
        if (maxMean < minMean) {
            throw new IllegalArgumentException("Max mean: " + maxMean + " < " + minMean);
        }
    }

    @Deprecated
    public DiscreteSampler createPoissonSampler(UniformRandomProvider rng, double mean) {
        return this.createSharedStateSampler(rng, mean);
    }

    public SharedStateDiscreteSampler createSharedStateSampler(UniformRandomProvider rng, double mean) {
        if (mean < 40.0) {
            return SmallMeanPoissonSampler.of(rng, mean);
        }
        if (mean > (double)this.maxN) {
            return LargeMeanPoissonSampler.of(rng, mean);
        }
        int n = (int)Math.floor(mean);
        if (n < this.minN) {
            return LargeMeanPoissonSampler.of(rng, mean);
        }
        int index = n - this.minN;
        LargeMeanPoissonSampler.LargeMeanPoissonSamplerState state = this.values[index];
        if (state == null) {
            LargeMeanPoissonSampler sampler = new LargeMeanPoissonSampler(rng, mean);
            this.values[index] = sampler.getState();
            return sampler;
        }
        double lambdaFractional = mean - (double)n;
        return new LargeMeanPoissonSampler(rng, state, lambdaFractional);
    }

    public boolean withinRange(double mean) {
        if (mean < 40.0) {
            return true;
        }
        int n = (int)Math.floor(mean);
        return n <= this.maxN && n >= this.minN;
    }

    public boolean isValidRange() {
        return this.values != null;
    }

    public double getMinMean() {
        return this.minN;
    }

    public double getMaxMean() {
        if (this.isValidRange()) {
            return Math.nextDown((double)this.maxN + 1.0);
        }
        return 0.0;
    }

    public static double getMinimumCachedMean() {
        return 40.0;
    }

    public PoissonSamplerCache withRange(double minMean, double maxMean) {
        int nextIndex;
        int currentIndex;
        if (this.values == null) {
            return new PoissonSamplerCache(minMean, maxMean);
        }
        PoissonSamplerCache.checkMeanRange(minMean, maxMean);
        if (maxMean < 40.0) {
            return new PoissonSamplerCache(0.0, 0.0);
        }
        int withMinN = (int)Math.floor(Math.max(minMean, 40.0));
        int withMaxN = (int)Math.floor(maxMean);
        LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] states = new LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[withMaxN - withMinN + 1];
        if (this.minN <= withMinN) {
            currentIndex = withMinN - this.minN;
            nextIndex = 0;
        } else {
            currentIndex = 0;
            nextIndex = this.minN - withMinN;
        }
        int length = Math.min(this.values.length - currentIndex, states.length - nextIndex);
        if (length > 0) {
            System.arraycopy(this.values, currentIndex, states, nextIndex, length);
        }
        return new PoissonSamplerCache(withMinN, withMaxN, states);
    }
}

