/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.shape.Coordinates;

public abstract class BoxSampler
implements SharedStateObjectSampler<double[]> {
    private static final int TWO_D = 2;
    private static final int THREE_D = 3;
    private final UniformRandomProvider rng;

    BoxSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public abstract double[] sample();

    double createSample(double a, double b) {
        double u = this.rng.nextDouble();
        return (1.0 - u) * a + u * b;
    }

    @Override
    public abstract BoxSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static BoxSampler of(UniformRandomProvider rng, double[] a, double[] b) {
        int dimension = a.length;
        if (dimension != b.length) {
            throw new IllegalArgumentException("Mismatch of box dimensions: " + dimension + ',' + b.length);
        }
        Coordinates.requireFinite(a, "Bound a");
        Coordinates.requireFinite(b, "Bound b");
        if (dimension == 2) {
            return new BoxSampler2D(rng, a, b);
        }
        if (dimension == 3) {
            return new BoxSampler3D(rng, a, b);
        }
        if (dimension > 3) {
            return new BoxSamplerND(rng, a, b);
        }
        throw new IllegalArgumentException("Unsupported dimension: " + dimension);
    }

    private static class BoxSamplerND
    extends BoxSampler {
        private final double[] a;
        private final double[] b;

        BoxSamplerND(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.a = (double[])a.clone();
            this.b = (double[])b.clone();
        }

        BoxSamplerND(UniformRandomProvider rng, BoxSamplerND source) {
            super(rng);
            this.a = source.a;
            this.b = source.b;
        }

        @Override
        public double[] sample() {
            double[] x = new double[this.a.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = this.createSample(this.a[i], this.b[i]);
            }
            return x;
        }

        @Override
        public BoxSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new BoxSamplerND(rng, this);
        }
    }

    private static class BoxSampler3D
    extends BoxSampler {
        private final double ax;
        private final double ay;
        private final double az;
        private final double bx;
        private final double by;
        private final double bz;

        BoxSampler3D(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.az = a[2];
            this.bx = b[0];
            this.by = b[1];
            this.bz = b[2];
        }

        BoxSampler3D(UniformRandomProvider rng, BoxSampler3D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.az = source.az;
            this.bx = source.bx;
            this.by = source.by;
            this.bz = source.bz;
        }

        @Override
        public double[] sample() {
            return new double[]{this.createSample(this.ax, this.bx), this.createSample(this.ay, this.by), this.createSample(this.az, this.bz)};
        }

        @Override
        public BoxSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new BoxSampler3D(rng, this);
        }
    }

    private static class BoxSampler2D
    extends BoxSampler {
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;

        BoxSampler2D(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.bx = b[0];
            this.by = b[1];
        }

        BoxSampler2D(UniformRandomProvider rng, BoxSampler2D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.bx = source.bx;
            this.by = source.by;
        }

        @Override
        public double[] sample() {
            return new double[]{this.createSample(this.ax, this.bx), this.createSample(this.ay, this.by)};
        }

        @Override
        public BoxSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new BoxSampler2D(rng, this);
        }
    }
}

