/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.RandomAssert;
import org.junit.Test;

public class KISSRandomTest {
    @Test
    public void testMarsaglia() {
        final int[] seed = {
            0x159a55e5, 0x1f123bb5, 0x75bcd15, 0x16a81cc0
        };

        /*
         * Data generated from code snippet provided here:
         *   https://programmingpraxis.com/2010/10/05/george-marsaglias-random-number-generators/
         * Test code was modified w.r.t the above (because the latter uses
         * calls to functions not defined for "KISS").
         */
        final int[] expectedSequence = {
            0x9bddf92e, 0xd5a41e38, 0xb2f6ff02, 0x181980c1, 0x1a48acf3, 0x5877789e, 0x08477a08, 0xabd9fdcd,
            0x20d27205, 0xd55e1658, 0x6625bdda, 0x46e92162, 0x5dc0ac63, 0x0be5e04a, 0x2c8cde38, 0xdfe87d7b,
            0xa1372cc8, 0x49908cc8, 0x150b6104, 0xd5d397ad, 0x44651a2d, 0xc65d6e70, 0x053ea995, 0xb004ca00,
            0x8f99c850, 0x989a6aeb, 0x5199028f, 0xc90a92ab, 0x6a37785e, 0x50bb032e, 0x169cc118, 0xff23b9b1,
            0x70df92f1, 0x599079b3, 0xe573c766, 0x3a7a5675, 0x76a5bda2, 0x583d8e7f, 0xcb27109e, 0x4d781f1b,
            0x65ff5588, 0x2378e795, 0x7e79ee6d, 0x2b1a9240, 0x66d8d164, 0x1c3c5a1e, 0x75ef17ae, 0x91c4fade,
            0xf58fa074, 0x51349bd0, 0x4245e5fc, 0xf707d6e2, 0xf05b600c, 0x08383b08, 0x3101e3d7, 0x1d7eb87e,
            0xcef5e87d, 0xe6020ce2, 0x8d77a3ae, 0x9144b8be, 0xcb4c2d54, 0xba907fc2, 0xce4c0a47, 0x08b91835,
            0x275b22a9, 0x9ccffa6b, 0xa795f7f3, 0xed433852, 0x1c90b2bc, 0xf6e92296, 0xfd4ad01d, 0x88b8620f,
            0xfb869d24, 0x054cde71, 0xcecdf83c, 0x89365122, 0x04cbc72d, 0xa5ca868c, 0x27eca37c, 0x6c2e75c2,
            0x71b5f2b8, 0xac9a6a2e, 0x0d1feff0, 0xcbdac51d, 0xb269f578, 0x7e6352af, 0x5641e244, 0xffbc597b,
            0xaaf45646, 0x0ad41f8b, 0x63af1b42, 0xba964845, 0x0b80dc89, 0x0f0d03b1, 0x92ffbfa7, 0xb1914cdb,
            0x862f58ea, 0xc937de2a, 0x70778304, 0x28b95c4c, 0x479c1517, 0x28a1ab78, 0xef70cdcc, 0x6a370f40,
            0xf53ce32b, 0xfbd70fdf, 0xfffb2f3d, 0x61b0ee67, 0x10a166b7, 0x9cd0a674, 0x4227ffee, 0x5320e5e5,
            0x219b7bcb, 0xa3651b50, 0xfb130991, 0xa507097c, 0x4c81a5a5, 0xe30ed15b, 0xa621b2db, 0xbdc27a16,
            0x084cd486, 0xe26a6904, 0x242b4d3f, 0x5cef1f8f, 0x20f42ebe, 0x052c67fd, 0xa8c0904d, 0x879626af,
            0x0e1b0f5d, 0x1aea6221, 0xcdc30d90, 0xafcc3abb, 0x2a5829f2, 0x382d9706, 0xe8477b46, 0x0c465cdf,
            0xba7a34fd, 0xf54cda0f, 0xede336c2, 0xbd304106, 0x91ccc614, 0x092adb4d, 0x2c1f9e13, 0x5f2009b0,
            0x2eacc097, 0xe29e5b23, 0x65d191af, 0x3fcc259d, 0xe7abe14f, 0x3594c702, 0x7a7cedc7, 0xc8937289,
            0x467e5fb1, 0x5bcb15d2, 0x8dd2050d, 0x314c559c, 0x4709cb40, 0x9242d0c2, 0x2a9203a6, 0xc34eeabe,
            0x119bac5a, 0xbefdedc9, 0xbda6feaf, 0x6e082aa2, 0xb7158b61, 0x3c99488f, 0xd0295429, 0x2fbb2ded,
            0xdac17086, 0xc94c04fa, 0xbd7242cf, 0x0ba4b590, 0x86aef6c8, 0x6b8f7469, 0x48c8d85e, 0x2f1e48ab,
            0x21046a46, 0x3eaf3223, 0xf16665e7, 0xb99d3e5d, 0xf19d4960, 0xe85762ed, 0x35cf14d0, 0x2a480cbc,
            0x8f05f0c9, 0x6316bc0b, 0xac66305b, 0x76935c15, 0x1ad7ec46, 0x1d3f4c34, 0xb2797ff3, 0xb18394d5,
            0x4acbd91e, 0x503ad042, 0x1da06817, 0xdf588cc3, 0x1173c7bc, 0xfb073a27, 0x980f1951, 0x0154020a,
            0x5a10993c, 0xa3fcaaef, 0x5cd2672e, 0xa4307ae6, 0x91d9102c, 0xb40032d6, 0x34c7db2a, 0xb1dc6829,
            0xe21cc2c7, 0xc9d90b56, 0x10cdbfd0, 0x6f60cded, 0xbf1930cb, 0xcfaad21d, 0x4531f7da, 0x04d15688,
            0x1b5d3587, 0x5095feb0, 0x546a956c, 0x4981241c, 0x80bf8a10, 0xdaded8b1, 0x6d7f4f5e, 0xcc76c5c2,
            0x31206cbc, 0xd5557cb2, 0x42acb28e, 0x0c9522dd, 0xa0bf7520, 0xe7fbf236, 0xe8aad8d1, 0x419f297d,
            0x49278249, 0xd2103da1, 0x094ca07b, 0x19a3632b, 0xb1fa28b4, 0x1efe8423, 0x36fb4716, 0x8fb6eca6,
            0x6bfe8f8b, 0xc9617275, 0xb2ad50e1, 0xe8a9561e, 0xfa1e59fc, 0xc843b229, 0xf40d9ac5, 0x63794c70,
            0x230b6311, 0x2388749e, 0x7536cfa5, 0xd5ae3437, 0xaff04a09, 0x63e3bdeb, 0x5128e726, 0xee4da3c9,
            0x628c9033, 0xea3c6792, 0xbaf665a5, 0xc936dfb1, 0x4686e3ac, 0xcc668c46, 0xb6c94620, 0xaf5409ba,
            0x7e436a18, 0xb48deb9b, 0xbbbd41da, 0xc525c3a2, 0xdff2d190, 0xa4b39b98, 0xa876cebf, 0xcc86d8da,
            0x17b28124, 0x7b564204, 0xea42d2e5, 0x2e8ae4f5, 0x75615c56, 0x74aad2f0, 0x850897ad, 0x71538c73,
            0x08b697f3, 0x085af9e7, 0x86b65b18, 0xd447660e, 0x3e5f6bdc, 0xbf4edff7, 0xd6a75ac5, 0xcb2ae1d9,
            0x5bf8dea8, 0x4c74312d, 0x90f02a05, 0x4da50b30, 0x1e814a53, 0x9035acef, 0xf441623f, 0xd61a7507,
            0x46177245, 0xdfad40e2, 0xe73b4d54, 0x2c873c84, 0x3cbe4d72, 0x1ab0e26f, 0x42a40530, 0x5f4cb559,
            0xa7fc2436, 0x28fab25f, 0x4946c242, 0xc9af000a, 0x0cb05860, 0x64f4409c, 0x32fb4257, 0xfe8b2919,
            0x7fca3bb8, 0x66ae0e89, 0x9c78de62, 0x52a55a80, 0x9b49bd06, 0xc940e8e3, 0x4a0d2df5, 0xc138d6d4,
            0x0e3faa39, 0x9d5f9fef, 0x7388cf17, 0xc884bd00, 0x3cc0cdda, 0x433af830, 0x8a37d7f6, 0xef2f6cc0,
            0x66caded9, 0x93df50bd, 0x28b25b81, 0x637c8ab5, 0x68bb221f, 0xf7a3216a, 0x729c4b2a, 0x241c71da,
            0x2892b0f4, 0x9bef56ff, 0x4eb61e9f, 0x0f847c98, 0x48f45142, 0xdb6c93bc, 0x23caefc1, 0xf348a188,
            0x8f65bed7, 0xdaa1096b, 0x881764ef, 0x976b30b2, 0x4679cad9, 0x5dd89bfa, 0xa3869d81, 0x7c6862d2,
            0x9109547c, 0xd0db345b, 0x3cb74993, 0xe4c3af19, 0xfd5f2837, 0xfdec8040, 0xf9a45b20, 0x486e96de,
            0x0a0b7762, 0x790ddce0, 0xfc3be3f0, 0x4b671260, 0xccb5f958, 0x33e94796, 0x1ee4f26d, 0x5508b616,
            0x8da48af5, 0xaa8731a7, 0xd32ab831, 0x803726e0, 0x9c189aeb, 0x39a33842, 0xadca2595, 0xbf5d1296,
            0xc46ff6b5, 0x734b751b, 0x57661d71, 0xce360f69, 0xeab3c559, 0xd52bfb30, 0xe3613946, 0x32e3c4b7,
            0x29033e15, 0x1e2d9131, 0xf539e2cf, 0x8dd8a7d2, 0x519c1852, 0x5ecadeb2, 0x61eda0cd, 0x26f24244,
            0x2ee72248, 0xd2681224, 0xb9e186ad, 0x605340b2, 0xfc3f9a24, 0x972edf65, 0xaf2e37b3, 0x3275ef7c,
            0xd4c363e7, 0x102098b0, 0x687273cb, 0x10e24570, 0x8b9eef36, 0x48d85e3b, 0x8917f19a, 0xdab2a6c8,
            0x8ac77b69, 0x16b22036, 0x5d4b23d4, 0x2ad9a70b, 0xbe3e53a7, 0xf0e64bfd, 0xab054c49, 0x2903bb0b,
            0x4d170bdf, 0x83cb27eb, 0x2c1ea00b, 0x79e18fd5, 0xed7338d1, 0xe262c6b9, 0xae427025, 0x8ddd23fb,
            0x8ff25d3e, 0x3945776b, 0xed590a9f, 0x2219a23a, 0xfc56d783, 0xa20f7ca2, 0x07bf3698, 0xb96528e7,
            0x29cc982d, 0x0987dc2d, 0x5111622a, 0xa830c39b, 0xe3dac526, 0x6fd9540b, 0x2b766bb6, 0x836ce238,
            0x03f90d60, 0x5932da0c, 0x16df830d, 0xc4ff2bef, 0xfefba81a, 0x70c63f59, 0x52c2c2e0, 0xb16b3327,
            0xab5c7537, 0xdf437ec7, 0x6d1f837a, 0x7a8e4166, 0x0e7bb54f, 0x37abe65a, 0xc62c2798, 0x79ec2d1b,
            0x5ac9bc1a, 0xd151e3c6, 0x72b18873, 0x6cec7e6e, 0x3bc7db87, 0xa2f74c99, 0xff68ce99, 0x27c1113c,
            0x2a55bea8, 0xd6c0164b, 0x2df44b5a, 0xe2fbdc41, 0x699f0e4d, 0xb8c3978f, 0xa0704979, 0xbc881700,
            0x84c4fd5b, 0x3193c851, 0xdbabaa40, 0xc6a3cab0, 0x07ce6dc2, 0x2de90a7b, 0x0b9f08bf, 0x1bb1a3cb,
            0x3bc4d798, 0xdf5843ee, 0xfc8751f9, 0xbb322216, 0x431b8ee9, 0x54a5ec08, 0xc1982bb8, 0xe370d7ff,
            0x27e7f1ec, 0xaa489ce1, 0x49c9c2e5, 0xef5ddecf, 0xbef9b424, 0x2a178797, 0xb028ad66, 0x622824f9,
            0x8365d72f, 0x0f0febb2, 0xe204682b, 0xaf1cbe29, 0xed2b8bc5, 0xe37e25d7, 0x16c23b8f, 0x8fb91cac,
            0xb403a3f0, 0xf5fbc869, 0xe7be64d6, 0xdeb1182a, 0xc731e53d, 0x1a3fb823, 0xf4efeee8, 0x9d42f7d6,
            0x881c28a8, 0xbb83f0c8, 0x2682d4c8, 0x942a3303, 0xfb481ea0, 0xc1aa5c19, 0x60bdb8d3, 0xbb811544,
            0x09506b13, 0x9aae4f2e, 0xd87042c5, 0x019d794c, 0x24873ec7, 0x21aa867c, 0x840d366f, 0x582cb845,
            0x7ed15d84, 0x1a332a6d, 0xed57d3a0, 0x09decf47, 0x3200a861, 0x9bade8aa, 0xd9172ed8, 0xcbd4e7dc,
            0x5eab57b0, 0x8b691e98, 0xc1ba9545, 0xf519ef86, 0xd355769a, 0xcbb4cbcd, 0x53207adb, 0x3dc07d77,
            0x88d0cbda, 0x8b5539c7, 0x1a743f7e, 0x36e674f8, 0xb84e545e, 0x6c0e2e2b, 0x5a35cb7d, 0x4f893b20,
            0x8a5a9fde, 0x2cd37895, 0xb7cf463a, 0xacc45d88, 0xf5e79c65, 0x3ff8d56e, 0xf611c876, 0x0fa9fc25,
            0x9085e3f9, 0xec40b7f2, 0x0aee3ae0, 0x760ee357, 0xa4696b0d, 0x0d8c8b8b, 0xa3b5d99f, 0xe94f6256,
            0xa3f83775, 0xad4d9c0c, 0x15b8d73d, 0x7e0b9b5c, 0x04099c0a, 0xd954fabc, 0x3864a4f4, 0x4437294d,
            0x98cdacd9, 0xeebc7109, 0xc26b1c2e, 0xaf526699, 0xc77cab85, 0xb7a2452b, 0xa8854a5f, 0xe4109703,
            0x37cecb2e, 0x0d80a309, 0x3278a84e, 0x5d04fdc7, 0x152c5303, 0xa6d0c819, 0x0da056ff, 0xccc77e72,
            0x1b6de6f3, 0x65d17dbe, 0xc7ff6dfe, 0x8767b6de, 0x022aae5b, 0x920cf0be, 0xc01df095, 0xa264ed4b,
            0xd0dcb856, 0x9908e09a, 0x87a4cae1, 0xf91d5def, 0x35386ccf, 0x706ad02f, 0x406165a9, 0x2e2b7d0b,
            0x7ec6af67, 0xc48b4739, 0x7ecd0626, 0x93bc872d, 0x30fc75e4, 0x9a6b22f7, 0x335b67da, 0x57843db1,
            0x1aa218ff, 0x208e7184, 0x87562ffd, 0xbbd4d912, 0x49871553, 0x98eb26fd, 0xdc542e6a, 0xfeb7884e,
            0x686812b1, 0xe783ce01, 0xbf085f53, 0x9006ed3c, 0xc263f011, 0xe7d2652c, 0x21e04885, 0x9abf1bcd,
            0x21f240be, 0xe7579fce, 0x0a18527f, 0x1d809e11, 0xa7659c30, 0x61904220, 0xf2947c55, 0x1e10bbaa,
            0xf0743c35, 0x1be461f0, 0xd6ea77c5, 0x8526acab, 0x3e33cd90, 0xf32e47a9, 0x20595910, 0x7378fb98,
            0xcee5ca21, 0xc00450c0, 0x4d36d07e, 0xe3668286, 0xa9a9b5f6, 0xfa152172, 0x26342971, 0x5bad7152,
            0xeac38189, 0x46f30c67, 0x5d792534, 0x22f9e10d, 0x62f147fd, 0x9ab4a355, 0xebc9b70c, 0xea79fdc5,
            0x89ad6392, 0x27d140ad, 0x63a14fac, 0x558c6169, 0xc31aee58, 0x44e518b5, 0x6b395095, 0x32b02b4c,
            0x4bb68956, 0x707ecbd9, 0x795d3b16, 0xb02bec7e, 0x4a2b69d0, 0x08860261, 0x47338bc5, 0x3d8ddd94,
            0x01162025, 0x58f7666d, 0x8824fb8b, 0xf5ac2bdb, 0x399a14e1, 0x7a9e86a9, 0x09e20963, 0xde1ce097,
            0x18fd4597, 0x458fb7d1, 0xaf266dc9, 0x38a03289, 0xdbf9405e, 0x22f72b15, 0x11cde58f, 0xa8268bd6,
            0xcfe1eaad, 0x0be9106f, 0xa7fa59b6, 0x25a77083, 0xb0fbadda, 0xd8b1c6a5, 0x348bd9de, 0x16d7bc9e,
            0xf1a1a4d8, 0xdf5eb72c, 0xa0cfe4f9, 0xbe155322, 0x808c327f, 0x1d9e9dcb, 0x673948b1, 0xbbb3429e,
            0xa87428b6, 0x15769548, 0x50c39092, 0x8c938266, 0x744a7cbe, 0xf9a52368, 0x05228781, 0x81b1d8c2,
            0xce8e2841, 0x0ef6b8b4, 0x16d8217c, 0x5044ed89, 0xd5ea65e6, 0x71708fc2, 0xc08b851a, 0xafc170bd,
            0x2f70770b, 0x2146bad6, 0x939c4959, 0xdaa508c1, 0xcd84c7b5, 0x8dfec5aa, 0xd93dc438, 0x3a7d0f4c,
            0xe80e0920, 0xb0d1322a, 0xadb0dc41, 0xa6f0d199, 0xb4b099d7, 0x01e1ef5a, 0x759b71d8, 0x0173a16c,
            0x00f4f943, 0x9ce79dcd, 0x32000f3b, 0x3e34ae20, 0x8e90cc8f, 0xf498a5ed, 0x8a942c71, 0xc4d43db3,
            0x2cb73388, 0x415e4744, 0xf815dd6f, 0x8115097e, 0x3f96c2b9, 0x03020349, 0x1874203c, 0x664e8be8,
            0x2d7a7faf, 0xc82c3f11, 0xa02d8eb5, 0x1818bc7c, 0x8cb7860f, 0x44616c09, 0x17c37006, 0xdce1797e,
            0x262067c1, 0x163e2a1d, 0xc0bfa651, 0xfb26d74f, 0x4a20f906, 0xfed1cf57, 0x9afd70d8, 0x94d686d8,
            0x7279943d, 0x7fb106b1, 0xea979669, 0x65aa06a8, 0xdd1c9b33, 0x75f36f06, 0x9d5bcf53, 0xb1fcbc13,
            0x38009684, 0xb3ddd247, 0x841bf86b, 0xa8cf3529, 0xc13d11c7, 0x61712e1c, 0x2f94716f, 0xb3cd94b2,
            0xc3bf8100, 0x99e5c378, 0x741b6a57, 0xbbef8a8b, 0x2c71ea5e, 0xab288d55, 0xdfb6436c, 0xa0ddb70c,
            0x55a857e0, 0x2afd06f1, 0x31facb85, 0x2bf3012e, 0x92a9604d, 0x99122a61, 0x5e009ff2, 0x3b2bf8d5,
            0x01a4163b, 0x7466a4ab, 0xe87d42f8, 0x42924d68, 0x0922918f, 0x51799336, 0x85198eb5, 0x0a1d9921,
            0x6eceb77e, 0x102ae474, 0xe91d1483, 0xe2884af6, 0x9ec6662e, 0x90dfe5b0, 0xb792574b, 0xd3df6743,
            0x0118c033, 0xfb7d8e35, 0x5b181e93, 0x65ee4f0c, 0x8d5da3bb, 0xe18114fb, 0xe1a22222, 0x39cade88,
            0xd028b13c, 0x18e9aa47, 0x40f66061, 0x969ad9c0, 0x92ebe7ab, 0x0851c58f, 0x7d2ddc83, 0x8116edff,
            0x2bb301e1, 0xb5e39f0a, 0xfec6c8ae, 0x7c68864a, 0x8e6080e6, 0xa174b691, 0xaf851d36, 0x35d5436a,
            0x061dd550, 0xe41def33, 0x18d17f85, 0xdd0cea07, 0xed485b29, 0x4ccf5968, 0xf690bc3a, 0x53548d4b,
            0x0afbf6d2, 0x03103a93, 0x1585693c, 0x32ba9756, 0xf6413d88, 0xe66da7d1, 0x2f655a9d, 0xd17639b1,
            0x7b91263d, 0x294f10d3, 0x88db2fdd, 0x3c9060af, 0x1fcfd771, 0xf991a176, 0x52d2ff33, 0x69026b72,
            0x27f07e2e, 0x8ea40247, 0x16996eff, 0xd032da80, 0xb1a8a6d7, 0x4f596e15, 0xeb33c034, 0x7a41947f,
            0x2544764a, 0xc95f1f0e, 0x912d88ee, 0xad806071, 0x9df4ca4a, 0x36ea6054, 0x21665964, 0xef095f1a,
            0xe3cbc59d, 0x72efb716, 0x8174007a, 0x1fc8a8a2, 0x29ffba04, 0x9a1669c9, 0x8c3ba8fb, 0x1a283765,
            0x62725d2c, 0x1bcfd949, 0x79ab0eae, 0x2952f8f9, 0xa715e3e1, 0x3f64afe3, 0xbce49540, 0x6e4d8a65,
            0x47709479, 0x5fa2c802, 0x8abfedc8, 0x44574700, 0x0f760805, 0x8fc6aa53, 0xb0b41aa8, 0x946e51ef,
            0xd06a39a3, 0xd7e06200, 0x434130ae, 0xee8fb053, 0xcdb70f63, 0x63aebbd9, 0xda48097c, 0x86aa4007,
            0xb77fbdac, 0x1eb28456, 0xb30e7026, 0x200b8e15, 0x97318c31, 0xda50e4b3, 0xa2fe7745, 0xb8414bfd,
            0xa4c9ee73, 0xf2ff3e9c, 0x9cc3c9fd, 0x6a0ea090, 0x995436fe, 0x4bde5ebd, 0x30ce4d64, 0x3a35fa03,
            0x46d14cae, 0x6a7bdf97, 0x5913707c, 0x7293963c, 0xe50c461d, 0xeb163f17, 0x610cd148, 0x88272ed3,
            0x9c486c3d, 0xe24e2dc4, 0x1f787244, 0x63b244fb, 0xbe736317, 0x39774449, 0x2b2141a3, 0x424bd98d,
            0x63f9ce48, 0x1c8dad05, 0x0ccbdb3f, 0x1a5123bf, 0x525ccd43, 0x0e033102, 0xae80d483, 0x3e818fb0,
            0x8a73393c, 0x709eb2ad, 0x545ffcf2, 0xb6015dad, 0x5138e4c2, 0x3312f727, 0x76f743bd, 0x421c883b,
            0x741f432e, 0x8f417c31, 0x7a9107ca, 0x1f520191, 0xa8c5e2e5, 0xbcf10c6b, 0x248b2cce, 0x9dc0520c,
            0xf39aaee7, 0xa2342585, 0xd100362b, 0x3784d183, 0x6f882be2, 0xe9e625e5, 0x95baadd0, 0x23abc37e,
            0xbc5ffc54, 0x2076cc77, 0x45b7fa2d, 0xb13d8c93, 0x65a9b9fe, 0x01c3c820, 0x28438c9a, 0x463f3fd2,
            0x1cc38180, 0x1f1f12cd, 0x68b6b469, 0xd44b8926, 0x2d2ac88e, 0x2c3d072c, 0x3942afbc, 0xcc0402b7,
        };

        RandomAssert.assertEquals(expectedSequence, new KISSRandom(seed));
    }
}
