/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * <h3>Performance benchmarks</h3>
 *
 * <p>
 * This package contains code to perform a
 * <a href="http://openjdk.java.net/projects/code-tools/jmh">JMH</a> run.
 * </p>
 *
 * <p>
 * Support for a new {@link org.apache.commons.rng.UniformRandomProvider UniformRandomProvider}
 * with a defined enum value in {@link org.apache.commons.rng.simple.RandomSource RandomSource}
 * can be added by updating:
 * </p>
 *
 * <ul>
 *   <li>The {@link org.apache.commons.rng.examples.jmh.RandomSourceValues RandomSourceValues} class
 *   <li>The {@link org.apache.commons.rng.examples.jmh.core.BaselineSources BaselineSources} class
 *   <li>The {@link org.apache.commons.rng.examples.jmh.simple.ConstructionPerformance
 *       ConstructionPerformance} class
 * </ul>
 */
package org.apache.commons.rng.examples.jmh;
