/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Builtin {
    public static boolean isMember(Set allStates, String state) {
        Iterator i = allStates.iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)i.next();
            if (!state.equals(tt.getId())) continue;
            return true;
        }
        return false;
    }

    public static Node dataNode(Object data, String path) {
        if (data == null || !(data instanceof Node)) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.error((Object)"Data(): Cannot evaluate an XPath expression in the absence of a context Node, null returned");
            return null;
        }
        Node dataNode = (Node)data;
        NodeList result = null;
        try {
            result = XPathAPI.selectNodeList((Node)dataNode, (String)path);
        }
        catch (TransformerException te) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.error((Object)te.getMessage(), (Throwable)te);
            return null;
        }
        int length = result.getLength();
        if (length == 0) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): No nodes matching the XPath expression \"" + path + "\", returning null"));
            return null;
        }
        if (length > 1) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): Multiple nodes matching XPath expression" + path + "\", returning first"));
        }
        return result.item(0);
    }

    public static Object data(Object data, String path) {
        Object retVal = null;
        String strVal = SCXMLHelper.getNodeValue(Builtin.dataNode(data, path));
        try {
            double d = Double.parseDouble(strVal);
            retVal = new Double(d);
        }
        catch (NumberFormatException notADouble) {
            try {
                long l = Long.parseLong(strVal);
                retVal = new Long(l);
            }
            catch (NumberFormatException notALong) {
                retVal = strVal;
            }
        }
        return retVal;
    }
}

