/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;

public class SimpleContext
implements Context {
    private Log log = LogFactory.getLog((Class)Context.class);
    private Context parent;
    private Map vars;

    public SimpleContext() {
        this(null, null);
    }

    public SimpleContext(Context parent) {
        this(parent, null);
    }

    public SimpleContext(Map initialVars) {
        this(null, initialVars);
    }

    public SimpleContext(Context parent, Map initialVars) {
        this.parent = parent;
        this.vars = initialVars == null ? new HashMap() : initialVars;
    }

    public void set(String name, Object value) {
        if (this.vars.containsKey(name)) {
            this.setLocal(name, value);
        } else if (this.parent != null && this.parent.has(name)) {
            this.parent.set(name, value);
        } else {
            this.setLocal(name, value);
        }
    }

    public Object get(String name) {
        if (this.vars.containsKey(name)) {
            return this.vars.get(name);
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return null;
    }

    public boolean has(String name) {
        if (this.vars.containsKey(name)) {
            return true;
        }
        return this.parent != null && this.parent.has(name);
    }

    public void reset() {
        this.vars.clear();
    }

    public Context getParent() {
        return this.parent;
    }

    public void setLocal(String name, Object value) {
        this.vars.put(name, value);
        if (this.log.isDebugEnabled() && !name.equals("_ALL_STATES")) {
            this.log.debug((Object)(name + " = " + String.valueOf(value)));
        }
    }

    protected void setVars(Map vars) {
        this.vars = vars;
    }

    public Map getVars() {
        return this.vars;
    }

    protected void setLog(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        return this.log;
    }
}

