/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env.faces;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.env.SimpleContext;

public class SessionContext
extends SimpleContext {
    private Map sessionMap;
    private static final String ERR_HOST_FACES_CTX_NULL = "Host FacesContext cannot be null";

    public SessionContext(FacesContext fc) {
        this(fc, null);
    }

    public SessionContext(FacesContext fc, Context parent) {
        super(parent);
        if (fc == null) {
            throw new IllegalArgumentException(ERR_HOST_FACES_CTX_NULL);
        }
        this.sessionMap = fc.getExternalContext().getSessionMap();
    }

    public Object get(String name) {
        Object value = this.getVars().get(name);
        if (value == null) {
            value = this.sessionMap.get(name);
        }
        return value;
    }

    public boolean has(String name) {
        return this.sessionMap.containsKey(name) || this.getVars().containsKey(name);
    }
}

