/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.ExternalContent;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.State;

public class Send
extends Action
implements ExternalContent {
    private static final String TARGETTYPE_SCXML = "scxml";
    private static final String EVENT_ERR_SEND_TARGETUNAVAILABLE = "error.send.targetunavailable";
    private String sendid;
    private String target;
    private String targettype = "scxml";
    private String delay;
    private String hints;
    private String namelist;
    private List externalNodes = new ArrayList();
    private String event;

    public final String getDelay() {
        return this.delay;
    }

    public final void setDelay(String delay) {
        this.delay = delay;
    }

    public final List getExternalNodes() {
        return this.externalNodes;
    }

    public final void setExternalNodes(List externalNodes) {
        this.externalNodes = externalNodes;
    }

    public final String getHints() {
        return this.hints;
    }

    public final void setHints(String hints) {
        this.hints = hints;
    }

    public final String getNamelist() {
        return this.namelist;
    }

    public final void setNamelist(String namelist) {
        this.namelist = namelist;
    }

    public final String getSendid() {
        return this.sendid;
    }

    public final void setSendid(String sendid) {
        this.sendid = sendid;
    }

    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(String target) {
        this.target = target;
    }

    public final String getTargettype() {
        return this.targettype;
    }

    public final void setTargettype(String targettype) {
        this.targettype = targettype;
    }

    public final void setEvent(String event) {
        this.event = event;
    }

    public final String getEvent() {
        return this.event;
    }

    public void execute(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Log appLog, Collection derivedEvents) throws ModelException, SCXMLExpressionException {
        if (this.targettype != null && this.targettype.trim().toLowerCase().equals(TARGETTYPE_SCXML)) {
            if (SCXMLHelper.isStringEmpty(this.target)) {
                derivedEvents.add(new TriggerEvent(this.event, 3));
            } else {
                appLog.warn((Object)("<send>: Unavailable target - " + this.target));
                derivedEvents.add(new TriggerEvent(EVENT_ERR_SEND_TARGETUNAVAILABLE, 5));
            }
            return;
        }
        State parentState = this.getParentState();
        Context ctx = scInstance.getContext(parentState);
        Evaluator eval = scInstance.getEvaluator();
        Object hintsValue = null;
        if (!SCXMLHelper.isStringEmpty(this.hints)) {
            hintsValue = eval.eval(ctx, this.hints);
        }
        HashMap<String, Object> params = null;
        if (!SCXMLHelper.isStringEmpty(this.namelist)) {
            StringTokenizer tkn = new StringTokenizer(this.namelist);
            params = new HashMap<String, Object>(tkn.countTokens());
            while (tkn.hasMoreTokens()) {
                String varName = tkn.nextToken();
                Object varObj = ctx.get(varName);
                if (varObj == null) {
                    errRep.onError("UNDEFINED_VARIABLE", varName + " = null", parentState);
                }
                params.put(varName, varObj);
            }
        }
        long wait = 0L;
        if (this.delay != null && this.delay.length() > 0) {
            try {
                wait = Long.parseLong(this.delay.trim());
            }
            catch (NumberFormatException nfe) {
                appLog.warn((Object)"Could not parse delay for <send>, it will be treated as immediate", (Throwable)nfe);
            }
        }
        evtDispatcher.send(this.sendid, this.target, this.targettype, this.event, params, hintsValue, wait, this.externalNodes);
    }
}

