/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.semantics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.NotificationRegistry;
import org.apache.commons.scxml.PathResolver;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.SCXMLSemantics;
import org.apache.commons.scxml.Step;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.invoke.Invoker;
import org.apache.commons.scxml.invoke.InvokerException;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.Executable;
import org.apache.commons.scxml.model.Finalize;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Path;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.semantics.TransitionTargetComparator;

public class SCXMLSemanticsImpl
implements SCXMLSemantics {
    private Log appLog = LogFactory.getLog((String)"scxml.app.log");
    private TransitionTargetComparator targetComparator = new TransitionTargetComparator();

    public SCXML normalizeStateMachine(SCXML input, ErrorReporter errRep) {
        return input;
    }

    public void determineInitialStates(SCXML input, Set states, List entryList, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        State tmp = input.getInitialState();
        if (tmp == null) {
            errRep.onError("NO_INITIAL", "SCXML initialstate is missing!", input);
        } else {
            states.add(tmp);
            this.determineTargetStates(states, errRep, scInstance);
            Set onEntry = SCXMLHelper.getAncestorClosure(states, null);
            Object[] oen = onEntry.toArray();
            onEntry.clear();
            Arrays.sort(oen, this.getTTComparator());
            List<Object> entering = Arrays.asList(oen);
            Collections.reverse(entering);
            entryList.addAll(entering);
        }
    }

    public void executeActions(Step step, SCXML stateMachine, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        TriggerEvent te;
        Executable oe;
        TransitionTarget tt;
        NotificationRegistry nr = scInstance.getNotificationRegistry();
        Collection internalEvents = step.getAfterStatus().getEvents();
        Map invokers = scInstance.getInvokers();
        Iterator i = step.getExitList().iterator();
        while (i.hasNext()) {
            tt = (TransitionTarget)i.next();
            oe = tt.getOnExit();
            try {
                Iterator onExitIter = oe.getActions().iterator();
                while (onExitIter.hasNext()) {
                    ((Action)onExitIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), oe);
            }
            if (invokers.containsKey(tt)) {
                Invoker toCancel = (Invoker)invokers.get(tt);
                try {
                    toCancel.cancel();
                }
                catch (InvokerException ie) {
                    TriggerEvent te2 = new TriggerEvent(tt.getId() + ".invoke.cancel.failed", 5);
                    internalEvents.add(te2);
                }
                invokers.remove(tt);
            }
            nr.fireOnExit(tt, tt);
            nr.fireOnExit(stateMachine, tt);
            te = new TriggerEvent(tt.getId() + ".exit", 2);
            internalEvents.add(te);
        }
        i = step.getTransitList().iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            try {
                Iterator transitIter = t.getActions().iterator();
                while (transitIter.hasNext()) {
                    ((Action)transitIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), t);
            }
            nr.fireOnTransition(t, t.getParent(), t.getRuntimeTarget(), t);
            nr.fireOnTransition(stateMachine, t.getParent(), t.getRuntimeTarget(), t);
        }
        i = step.getEntryList().iterator();
        while (i.hasNext()) {
            State ts;
            tt = (TransitionTarget)i.next();
            oe = tt.getOnEntry();
            try {
                Iterator onEntryIter = oe.getActions().iterator();
                while (onEntryIter.hasNext()) {
                    ((Action)onEntryIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), oe);
            }
            nr.fireOnEntry(tt, tt);
            nr.fireOnEntry(stateMachine, tt);
            te = new TriggerEvent(tt.getId() + ".entry", 2);
            internalEvents.add(te);
            if (!(tt instanceof State) || !(ts = (State)tt).getIsFinal()) continue;
            State parent = (State)ts.getParent();
            String prefix = "";
            if (parent != null) {
                prefix = parent.getId();
            }
            te = new TriggerEvent(prefix + ".done", 2);
            internalEvents.add(te);
            if (parent != null) {
                parent.setDone(true);
            }
            if (parent == null || !parent.isRegion()) continue;
            Parallel p = (Parallel)parent.getParent();
            int finCount = 0;
            int pCount = p.getStates().size();
            Iterator regions = p.getStates().iterator();
            while (regions.hasNext()) {
                State reg = (State)regions.next();
                if (!reg.isDone()) continue;
                ++finCount;
            }
            if (finCount != pCount) continue;
            te = new TriggerEvent(p.getId() + ".done", 2);
            internalEvents.add(te);
            te = new TriggerEvent(p.getParent().getId() + ".done", 2);
            internalEvents.add(te);
            p.getParentState().setDone(true);
        }
    }

    public void enumerateReachableTransitions(SCXML stateMachine, Step step, ErrorReporter errRep) {
        HashSet<Transition> transSet = new HashSet<Transition>();
        HashSet<State> stateSet = new HashSet<State>(step.getBeforeStatus().getStates());
        LinkedList<State> todoList = new LinkedList<State>(stateSet);
        while (!todoList.isEmpty()) {
            State st = (State)todoList.removeFirst();
            Iterator i = st.getTransitionsList().iterator();
            while (i.hasNext()) {
                Transition t = (Transition)i.next();
                if (transSet.contains(t)) continue;
                transSet.add(t);
                step.getTransitList().add(t);
            }
            State parent = st.getParentState();
            if (parent == null || stateSet.contains(parent)) continue;
            stateSet.add(parent);
            todoList.addLast(parent);
        }
        transSet.clear();
        stateSet.clear();
        todoList.clear();
    }

    public void filterTransitionsSet(Step step, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        TriggerEvent te;
        HashSet<String> allEvents = new HashSet<String>(step.getBeforeStatus().getEvents().size() + step.getExternalEvents().size());
        Iterator ei = step.getBeforeStatus().getEvents().iterator();
        while (ei.hasNext()) {
            te = (TriggerEvent)ei.next();
            allEvents.add(te.getName());
        }
        ei = step.getExternalEvents().iterator();
        while (ei.hasNext()) {
            te = (TriggerEvent)ei.next();
            allEvents.add(te.getName());
        }
        Iterator iter = scInstance.getInvokers().keySet().iterator();
        while (iter.hasNext()) {
            Finalize fn;
            State s = (State)iter.next();
            if (!this.finalizeMatch(s.getId(), allEvents) || (fn = s.getInvoke().getFinalize()) == null) continue;
            try {
                Iterator fnIter = fn.getActions().iterator();
                while (fnIter.hasNext()) {
                    ((Action)fnIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, step.getAfterStatus().getEvents());
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), fn);
            }
        }
        LinkedList<Transition> removeList = new LinkedList<Transition>();
        Iterator iter2 = step.getTransitList().iterator();
        while (iter2.hasNext()) {
            Boolean rslt;
            Transition t = (Transition)iter2.next();
            String event = t.getEvent();
            if (!this.eventMatch(event, allEvents)) {
                removeList.add(t);
                continue;
            }
            String expr = t.getCond();
            if (SCXMLHelper.isStringEmpty(expr)) {
                rslt = Boolean.TRUE;
            } else {
                try {
                    rslt = scInstance.getEvaluator().evalCond(scInstance.getContext(t.getParent()), t.getCond());
                }
                catch (SCXMLExpressionException e) {
                    rslt = Boolean.FALSE;
                    errRep.onError("EXPRESSION_ERROR", e.getMessage(), t);
                }
            }
            if (rslt.booleanValue()) continue;
            removeList.add(t);
        }
        step.getTransitList().removeAll(removeList);
        allEvents.clear();
        removeList.clear();
        if (step.getTransitList().size() > 1) {
            Object[] trans = step.getTransitList().toArray();
            Set currentStates = step.getBeforeStatus().getStates();
            HashSet<Transition> nonDeterm = new HashSet<Transition>();
            block9: for (int i = 0; i < trans.length; ++i) {
                Transition t = (Transition)trans[i];
                TransitionTarget tsrc = t.getParent();
                for (int j = i + 1; j < trans.length; ++j) {
                    Transition t2 = (Transition)trans[j];
                    boolean conflict = SCXMLHelper.inConflict(t, t2, currentStates);
                    if (!conflict) continue;
                    TransitionTarget t2src = t2.getParent();
                    if (SCXMLHelper.isDescendant(t2src, tsrc)) {
                        removeList.add(t);
                        continue block9;
                    }
                    if (SCXMLHelper.isDescendant(tsrc, t2src)) {
                        removeList.add(t2);
                        continue;
                    }
                    nonDeterm.add(t);
                    nonDeterm.add(t2);
                }
            }
            nonDeterm.removeAll(removeList);
            if (nonDeterm.size() > 0) {
                errRep.onError("NON_DETERMINISTIC", "Multiple conflicting transitions enabled.", nonDeterm);
            }
            step.getTransitList().removeAll(removeList);
            removeList.clear();
            nonDeterm.clear();
        }
    }

    public Set seedTargetSet(Set residual, List transitList, ErrorReporter errRep) {
        HashSet<TransitionTarget> seedSet = new HashSet<TransitionTarget>();
        HashSet regions = new HashSet();
        Iterator i = transitList.iterator();
        while (i.hasNext()) {
            Path p;
            Transition t = (Transition)i.next();
            if (t.getTarget() != null) {
                seedSet.add(t.getTarget());
            }
            if (!(p = t.getPath()).isCrossRegion()) continue;
            List regs = p.getRegionsEntered();
            Iterator j = regs.iterator();
            while (j.hasNext()) {
                State region = (State)j.next();
                regions.addAll(((Parallel)region.getParent()).getStates());
            }
        }
        Set<TransitionTarget> allStates = new HashSet<TransitionTarget>(residual);
        allStates.addAll(seedSet);
        allStates = SCXMLHelper.getAncestorClosure(allStates, null);
        regions.removeAll(allStates);
        Iterator i2 = regions.iterator();
        while (i2.hasNext()) {
            State reg = (State)i2.next();
            seedSet.add(reg);
        }
        return seedSet;
    }

    public void determineTargetStates(Set states, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        LinkedList<TransitionTarget> wrkSet = new LinkedList<TransitionTarget>(states);
        states.clear();
        while (!wrkSet.isEmpty()) {
            TransitionTarget tt = (TransitionTarget)wrkSet.removeFirst();
            if (tt instanceof State) {
                State st = (State)tt;
                if (st.isSimple()) {
                    states.add(st);
                    continue;
                }
                if (st.isOrthogonal()) {
                    wrkSet.addLast(st.getParallel());
                    continue;
                }
                Initial ini = st.getInitial();
                if (ini == null) {
                    errRep.onError("NO_INITIAL", "Initial pseudostate is missing!", st);
                    continue;
                }
                Transition initialTransition = ini.getTransition();
                if (initialTransition == null) {
                    errRep.onError("ILLEGAL_INITIAL", "Initial transition is null!", st);
                    continue;
                }
                TransitionTarget init = initialTransition.getTarget();
                if (init == null || !(init instanceof State) && !(init instanceof History)) {
                    errRep.onError("ILLEGAL_INITIAL", "Initial not pointing to a State or History!", st);
                    continue;
                }
                wrkSet.addLast(init);
                continue;
            }
            if (tt instanceof Parallel) {
                Parallel prl = (Parallel)tt;
                Iterator i = prl.getStates().iterator();
                while (i.hasNext()) {
                    wrkSet.addLast((TransitionTarget)i.next());
                }
                continue;
            }
            if (tt instanceof History) {
                History h = (History)tt;
                if (scInstance.isEmpty(h)) {
                    wrkSet.addLast(h.getTransition().getRuntimeTarget());
                    continue;
                }
                wrkSet.addAll(scInstance.getLastConfiguration(h));
                continue;
            }
            throw new ModelException("Unknown TransitionTarget subclass:" + tt.getClass().getName());
        }
    }

    public void updateHistoryStates(Step step, ErrorReporter errRep, SCInstance scInstance) {
        Set oldState = step.getBeforeStatus().getStates();
        Iterator i = step.getExitList().iterator();
        while (i.hasNext()) {
            State s;
            Object o = i.next();
            if (!(o instanceof State) || !(s = (State)o).hasHistory()) continue;
            HashSet shallow = null;
            HashSet<State> deep = null;
            Iterator j = s.getHistory().iterator();
            while (j.hasNext()) {
                History h = (History)j.next();
                if (h.isDeep()) {
                    if (deep == null) {
                        deep = new HashSet<State>();
                        Iterator k = oldState.iterator();
                        while (k.hasNext()) {
                            State os = (State)k.next();
                            if (!SCXMLHelper.isDescendant(os, s)) continue;
                            deep.add(os);
                        }
                    }
                    scInstance.setLastConfiguration(h, deep);
                    continue;
                }
                if (shallow == null) {
                    shallow = new HashSet();
                    shallow.addAll(s.getChildren().values());
                    shallow.retainAll(SCXMLHelper.getAncestorClosure(oldState, null));
                }
                scInstance.setLastConfiguration(h, shallow);
            }
            shallow = null;
            deep = null;
        }
    }

    public void followTransitions(Step step, ErrorReporter errorReporter, SCInstance scInstance) throws ModelException {
        Set currentStates = step.getBeforeStatus().getStates();
        List transitions = step.getTransitList();
        HashSet exitedStates = new HashSet();
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            Set ext = SCXMLHelper.getStatesExited(t, currentStates);
            exitedStates.addAll(ext);
        }
        HashSet residual = new HashSet(currentStates);
        residual.removeAll(exitedStates);
        Set seedSet = this.seedTargetSet(residual, transitions, errorReporter);
        Set targetSet = step.getAfterStatus().getStates();
        targetSet.addAll(seedSet);
        this.determineTargetStates(targetSet, errorReporter, scInstance);
        Set entered = SCXMLHelper.getAncestorClosure(targetSet, seedSet);
        seedSet.clear();
        Iterator i2 = transitions.iterator();
        while (i2.hasNext()) {
            Transition t = (Transition)i2.next();
            entered.addAll(t.getPath().getDownwardSegment());
            if (!(t.getRuntimeTarget() instanceof History)) continue;
            entered.remove(t.getRuntimeTarget());
        }
        targetSet.addAll(residual);
        residual.clear();
        if (!SCXMLHelper.isLegalConfig(targetSet, errorReporter)) {
            throw new ModelException("Illegal state machine configuration!");
        }
        Object[] oex = exitedStates.toArray();
        exitedStates.clear();
        Object[] oen = entered.toArray();
        entered.clear();
        Arrays.sort(oex, this.getTTComparator());
        Arrays.sort(oen, this.getTTComparator());
        step.getExitList().addAll(Arrays.asList(oex));
        List<Object> entering = Arrays.asList(oen);
        Collections.reverse(entering);
        step.getEntryList().addAll(entering);
        Iterator<Object> reset = entering.iterator();
        while (reset.hasNext()) {
            Object o = reset.next();
            if (!(o instanceof State)) continue;
            ((State)o).setDone(false);
        }
    }

    public void processInvokes(TriggerEvent[] events, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        HashSet<String> eventNames = new HashSet<String>();
        for (int i = 0; i < events.length; ++i) {
            eventNames.add(events[i].getName());
        }
        Iterator invokeIter = scInstance.getInvokers().entrySet().iterator();
        while (invokeIter.hasNext()) {
            Map.Entry iEntry = invokeIter.next();
            String parentId = ((TransitionTarget)iEntry.getKey()).getId();
            if (this.finalizeMatch(parentId, eventNames)) continue;
            Invoker inv = (Invoker)iEntry.getValue();
            try {
                inv.parentEvents(events);
            }
            catch (InvokerException ie) {
                this.appLog.error((Object)ie.getMessage(), (Throwable)ie);
                throw new ModelException(ie.getMessage(), ie.getCause());
            }
        }
    }

    public void initiateInvokes(Step step, ErrorReporter errRep, SCInstance scInstance) {
        Evaluator eval = scInstance.getEvaluator();
        Collection internalEvents = step.getAfterStatus().getEvents();
        Iterator iter = step.getAfterStatus().getStates().iterator();
        while (iter.hasNext()) {
            State s = (State)iter.next();
            Context ctx = scInstance.getContext(s);
            Invoke i = s.getInvoke();
            if (i == null || scInstance.getInvoker(s) != null) continue;
            String src = i.getSrc();
            if (src == null) {
                String srcexpr = i.getSrcexpr();
                Object srcObj = null;
                try {
                    srcObj = eval.eval(ctx, srcexpr);
                    src = String.valueOf(srcObj);
                }
                catch (SCXMLExpressionException see) {
                    errRep.onError("EXPRESSION_ERROR", see.getMessage(), i);
                }
            }
            String source = src;
            PathResolver pr = i.getPathResolver();
            if (pr != null) {
                source = i.getPathResolver().resolvePath(src);
            }
            String ttype = i.getTargettype();
            Invoker inv = null;
            try {
                inv = scInstance.newInvoker(ttype);
            }
            catch (InvokerException ie) {
                TriggerEvent te = new TriggerEvent(s.getId() + ".invoke.failed", 5);
                internalEvents.add(te);
                continue;
            }
            inv.setParentStateId(s.getId());
            inv.setSCInstance(scInstance);
            Map params = i.getParams();
            HashMap<String, Object> args = new HashMap<String, Object>();
            Iterator pIter = params.entrySet().iterator();
            while (pIter.hasNext()) {
                Map.Entry entry = pIter.next();
                String argName = (String)entry.getKey();
                String argExpr = (String)entry.getValue();
                Object argValue = null;
                if (argExpr != null && argExpr.trim().length() > 0) {
                    try {
                        argValue = eval.eval(ctx, argExpr);
                    }
                    catch (SCXMLExpressionException see) {
                        errRep.onError("EXPRESSION_ERROR", see.getMessage(), i);
                    }
                }
                args.put(argName, argValue);
            }
            try {
                inv.invoke(source, args);
            }
            catch (InvokerException ie) {
                TriggerEvent te = new TriggerEvent(s.getId() + ".invoke.failed", 5);
                internalEvents.add(te);
                continue;
            }
            scInstance.setInvoker(s, inv);
        }
    }

    protected boolean eventMatch(String transEvent, Set eventOccurrences) {
        if (SCXMLHelper.isStringEmpty(transEvent)) {
            return true;
        }
        String transEventDot = transEvent + ".";
        Iterator i = eventOccurrences.iterator();
        while (i.hasNext()) {
            String evt = (String)i.next();
            if (evt == null) continue;
            if (evt.equals("*")) {
                return true;
            }
            if (!evt.equals(transEvent) && !evt.startsWith(transEventDot)) continue;
            return true;
        }
        return false;
    }

    protected boolean finalizeMatch(String parentStateId, Set eventOccurrences) {
        String prefix = parentStateId + ".invoke.";
        Iterator i = eventOccurrences.iterator();
        while (i.hasNext()) {
            String evt = (String)i.next();
            if (evt == null || !evt.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected Comparator getTTComparator() {
        return this.targetComparator;
    }

    protected void setLog(Log log) {
        this.appLog = log;
    }

    protected Log getLog() {
        return this.appLog;
    }
}

