/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;

public final class NotificationRegistry {
    private Map regs = new HashMap();

    void addListener(Object source, SCXMLListener lst) {
        HashSet<SCXMLListener> entries = (HashSet<SCXMLListener>)this.regs.get(source);
        if (entries == null) {
            entries = new HashSet<SCXMLListener>();
            this.regs.put(source, entries);
        }
        entries.add(lst);
    }

    void removeListener(Object source, SCXMLListener lst) {
        Set entries = (Set)this.regs.get(source);
        if (entries != null) {
            entries.remove(lst);
            if (entries.size() == 0) {
                this.regs.remove(source);
            }
        }
    }

    public void fireOnEntry(TransitionTarget observable, TransitionTarget state) {
        TransitionTarget source = observable;
        this.fireOnEntry((Object)source, state);
    }

    public void fireOnEntry(SCXML observable, TransitionTarget state) {
        SCXML source = observable;
        this.fireOnEntry((Object)source, state);
    }

    private void fireOnEntry(Object source, TransitionTarget state) {
        Set entries = (Set)this.regs.get(source);
        if (entries != null) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                SCXMLListener lst = (SCXMLListener)iter.next();
                lst.onEntry(state);
            }
        }
    }

    public void fireOnExit(TransitionTarget observable, TransitionTarget state) {
        TransitionTarget source = observable;
        this.fireOnExit((Object)source, state);
    }

    public void fireOnExit(SCXML observable, TransitionTarget state) {
        SCXML source = observable;
        this.fireOnExit((Object)source, state);
    }

    private void fireOnExit(Object source, TransitionTarget state) {
        Set entries = (Set)this.regs.get(source);
        if (entries != null) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                SCXMLListener lst = (SCXMLListener)iter.next();
                lst.onExit(state);
            }
        }
    }

    public void fireOnTransition(Transition observable, TransitionTarget from, TransitionTarget to, Transition transition) {
        Transition source = observable;
        this.fireOnTransition((Object)source, from, to, transition);
    }

    public void fireOnTransition(SCXML observable, TransitionTarget from, TransitionTarget to, Transition transition) {
        SCXML source = observable;
        this.fireOnTransition((Object)source, from, to, transition);
    }

    private void fireOnTransition(Object source, TransitionTarget from, TransitionTarget to, Transition transition) {
        Set entries = (Set)this.regs.get(source);
        if (entries != null) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                SCXMLListener lst = (SCXMLListener)iter.next();
                lst.onTransition(from, to, transition);
            }
        }
    }
}

