/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class SimpleErrorHandler
implements ErrorHandler {
    private static final String MSG_PREFIX = "SCXML SAX Parsing: ";
    private static final String MSG_POSTFIX = " Correct the SCXML document.";
    private Log log = LogFactory.getLog(this.getClass());

    public void error(SAXParseException exception) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)(MSG_PREFIX + exception.getMessage() + MSG_POSTFIX), (Throwable)exception);
        }
    }

    public void fatalError(SAXParseException exception) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)(MSG_PREFIX + exception.getMessage() + MSG_POSTFIX), (Throwable)exception);
        }
    }

    public void warning(SAXParseException exception) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)(MSG_PREFIX + exception.getMessage() + MSG_POSTFIX), (Throwable)exception);
        }
    }
}

