/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.env.LogUtils;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;

public class SimpleErrorReporter
implements ErrorReporter {
    private Log log = LogFactory.getLog(this.getClass());

    public void onError(String errorCode, String errDetail, Object errCtx) {
        String errCode = errorCode.intern();
        StringBuffer msg = new StringBuffer();
        msg.append(errCode).append(" (");
        msg.append(errDetail).append("): ");
        if (errCode == "NO_INITIAL") {
            if (errCtx instanceof SCXML) {
                msg.append("<SCXML>");
            } else if (errCtx instanceof State) {
                msg.append("State " + LogUtils.getTTPath((State)errCtx));
            }
        } else if (errCode == "UNKNOWN_ACTION") {
            msg.append("Action: " + errCtx.getClass().getName());
        } else if (errCode == "NON_DETERMINISTIC") {
            msg.append(" [");
            if (errCtx instanceof HashSet) {
                Iterator i = ((Set)errCtx).iterator();
                while (i.hasNext()) {
                    Transition t = (Transition)i.next();
                    msg.append(LogUtils.transToString(t.getParent(), t.getTarget(), t));
                    if (!i.hasNext()) continue;
                    msg.append(", ");
                }
            }
            msg.append(']');
        } else if (errCode == "ILLEGAL_CONFIG") {
            if (errCtx instanceof Map.Entry) {
                TransitionTarget tt = (TransitionTarget)((Map.Entry)errCtx).getKey();
                Set vals = (Set)((Map.Entry)errCtx).getValue();
                msg.append(LogUtils.getTTPath(tt) + " : [");
                Iterator i = vals.iterator();
                while (i.hasNext()) {
                    TransitionTarget tx = (TransitionTarget)i.next();
                    msg.append(LogUtils.getTTPath(tx));
                    if (!i.hasNext()) continue;
                    msg.append(", ");
                }
                msg.append(']');
            } else if (errCtx instanceof Set) {
                Set vals = (Set)errCtx;
                msg.append("<SCXML> : [");
                Iterator i = vals.iterator();
                while (i.hasNext()) {
                    TransitionTarget tx = (TransitionTarget)i.next();
                    msg.append(LogUtils.getTTPath(tx));
                    if (!i.hasNext()) continue;
                    msg.append(", ");
                }
                msg.append(']');
            }
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)msg.toString());
        }
    }
}

