/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.invoke;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.env.SimpleDispatcher;
import org.apache.commons.scxml.env.SimpleErrorHandler;
import org.apache.commons.scxml.env.SimpleErrorReporter;
import org.apache.commons.scxml.env.SimpleSCXMLListener;
import org.apache.commons.scxml.invoke.AsyncTrigger;
import org.apache.commons.scxml.invoke.Invoker;
import org.apache.commons.scxml.invoke.InvokerException;
import org.apache.commons.scxml.io.SCXMLDigester;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SimpleSCXMLInvoker
implements Invoker,
Serializable {
    private static final long serialVersionUID = 1L;
    private String parentStateId;
    private String eventPrefix;
    private SCInstance parentSCInstance;
    private SCXMLExecutor executor;
    private boolean cancelled;
    private static String invokePrefix = ".invoke.";
    private static String invokeDone = "done";
    private static String invokeCancelResponse = "cancel.response";

    public void setParentStateId(String parentStateId) {
        this.parentStateId = parentStateId;
        this.eventPrefix = parentStateId + invokePrefix;
        this.cancelled = false;
    }

    public void setSCInstance(SCInstance scInstance) {
        this.parentSCInstance = scInstance;
    }

    public void invoke(String source, Map params) throws InvokerException {
        SCXML scxml = null;
        try {
            scxml = SCXMLDigester.digest(source, (ErrorHandler)new SimpleErrorHandler(), null);
        }
        catch (ModelException me) {
            throw new InvokerException(me.getMessage(), me.getCause());
        }
        catch (IOException ioe) {
            throw new InvokerException(ioe.getMessage(), ioe.getCause());
        }
        catch (SAXException se) {
            throw new InvokerException(se.getMessage(), se.getCause());
        }
        Evaluator eval = this.parentSCInstance.getEvaluator();
        this.executor = new SCXMLExecutor(eval, new SimpleDispatcher(), new SimpleErrorReporter());
        Context rootCtx = eval.newContext(null);
        Iterator iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            rootCtx.setLocal((String)entry.getKey(), entry.getValue());
        }
        this.executor.setRootContext(rootCtx);
        this.executor.setStateMachine(scxml);
        this.executor.addListener(scxml, (SCXMLListener)new SimpleSCXMLListener());
        try {
            this.executor.go();
        }
        catch (ModelException me) {
            throw new InvokerException(me.getMessage(), me.getCause());
        }
    }

    public void parentEvents(TriggerEvent[] evts) throws InvokerException {
        if (this.cancelled) {
            return;
        }
        boolean doneBefore = this.executor.getCurrentStatus().isFinal();
        try {
            this.executor.triggerEvents(evts);
        }
        catch (ModelException me) {
            throw new InvokerException(me.getMessage(), me.getCause());
        }
        if (!doneBefore && this.executor.getCurrentStatus().isFinal()) {
            TriggerEvent te = new TriggerEvent(this.eventPrefix + invokeDone, 3);
            new AsyncTrigger(this.parentSCInstance.getExecutor(), te);
        }
    }

    public void cancel() throws InvokerException {
        this.cancelled = true;
        TriggerEvent te = new TriggerEvent(this.eventPrefix + invokeCancelResponse, 3);
        new AsyncTrigger(this.parentSCInstance.getExecutor(), te);
    }
}

