/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.env.SimpleScheduler;
import org.apache.commons.scxml.env.Tracer;
import org.apache.commons.scxml.invoke.SimpleSCXMLInvoker;
import org.apache.commons.scxml.io.SCXMLDigester;
import org.apache.commons.scxml.io.SCXMLSerializer;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class StandaloneUtils {
    public static void execute(String uri, Evaluator evaluator) {
        try {
            String documentURI = StandaloneUtils.getCanonicalURI(uri);
            Context rootCtx = evaluator.newContext(null);
            Tracer trc = new Tracer();
            SCXML doc = SCXMLDigester.digest(new URL(documentURI), (ErrorHandler)trc);
            if (doc == null) {
                System.err.println("The SCXML document " + uri + " can not be parsed!");
                System.exit(-1);
            }
            System.out.println(SCXMLSerializer.serialize(doc));
            SCXMLExecutor exec = new SCXMLExecutor(evaluator, null, trc);
            SimpleScheduler ed = new SimpleScheduler(exec);
            exec.setEventdispatcher(ed);
            exec.setStateMachine(doc);
            exec.addListener(doc, (SCXMLListener)trc);
            exec.registerInvokerClass("scxml", SimpleSCXMLInvoker.class);
            exec.setRootContext(rootCtx);
            exec.go();
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String event = null;
            while ((event = br.readLine()) != null) {
                if ((event = event.trim()).equalsIgnoreCase("help") || event.equals("?")) {
                    System.out.println("Enter a space-separated list of events");
                    System.out.println("To populate a variable in the current context, type \"name=value\"");
                    System.out.println("To quit, enter \"quit\"");
                    System.out.println("To reset state machine, enter \"reset\"");
                    continue;
                }
                if (!event.equalsIgnoreCase("quit")) {
                    if (event.equalsIgnoreCase("reset")) {
                        exec.reset();
                        continue;
                    }
                    if (event.indexOf(61) != -1) {
                        int marker = event.indexOf(61);
                        String name = event.substring(0, marker);
                        String value = event.substring(marker + 1);
                        rootCtx.setLocal(name, value);
                        System.out.println("Set variable " + name + " to " + value);
                        continue;
                    }
                    if (SCXMLHelper.isStringEmpty(event) || event.equalsIgnoreCase("null")) {
                        TriggerEvent[] evts = new TriggerEvent[]{new TriggerEvent(null, 3, null)};
                        exec.triggerEvents(evts);
                        if (!exec.getCurrentStatus().isFinal()) continue;
                        System.out.println("A final configuration reached.");
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(event);
                    int tkns = st.countTokens();
                    TriggerEvent[] evts = new TriggerEvent[tkns];
                    for (int i = 0; i < tkns; ++i) {
                        evts[i] = new TriggerEvent(st.nextToken(), 3, null);
                    }
                    exec.triggerEvents(evts);
                    if (!exec.getCurrentStatus().isFinal()) continue;
                    System.out.println("A final configuration reached.");
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private static String getCanonicalURI(String uri) throws IOException {
        if (uri.toLowerCase().startsWith("http://") || uri.toLowerCase().startsWith("file://")) {
            return uri;
        }
        File in = new File(uri);
        return "file:///" + in.getCanonicalPath();
    }

    private StandaloneUtils() {
    }
}

