/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Builtin
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static boolean isMember(Set allStates, String state) {
        Iterator i = allStates.iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)i.next();
            if (!state.equals(tt.getId())) continue;
            return true;
        }
        return false;
    }

    public static Node dataNode(Map namespaces, Object data, String path) {
        Log log;
        if (data == null || !(data instanceof Node)) {
            Log log2 = LogFactory.getLog((Class)Builtin.class);
            log2.error((Object)"Data(): Cannot evaluate an XPath expression in the absence of a context Node, null returned");
            return null;
        }
        Node dataNode = (Node)data;
        NodeList result = null;
        try {
            if (namespaces == null || namespaces.size() == 0) {
                Log log3 = LogFactory.getLog((Class)Builtin.class);
                if (log3.isDebugEnabled()) {
                    log3.debug((Object)("Turning off namespaced XPath evaluation since no namespace information is available for path: " + path));
                }
                result = XPathAPI.selectNodeList((Node)dataNode, (String)path);
            } else {
                XPathContext xpathSupport = new XPathContext();
                DataPrefixResolver prefixResolver = new DataPrefixResolver(namespaces);
                XPath xpath = new XPath(path, null, (PrefixResolver)prefixResolver, 0);
                int ctxtNode = xpathSupport.getDTMHandleFromNode(dataNode);
                result = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver).nodelist();
            }
        }
        catch (TransformerException te) {
            Log log4 = LogFactory.getLog((Class)Builtin.class);
            log4.error((Object)te.getMessage(), (Throwable)te);
            return null;
        }
        int length = result.getLength();
        if (length == 0) {
            log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): No nodes matching the XPath expression \"" + path + "\", returning null"));
            return null;
        }
        if (length > 1) {
            log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): Multiple nodes matching XPath expression" + path + "\", returning first"));
        }
        return result.item(0);
    }

    public static Object data(Map namespaces, Object data, String path) {
        Object retVal = null;
        String strVal = SCXMLHelper.getNodeValue(Builtin.dataNode(namespaces, data, path));
        try {
            double d = Double.parseDouble(strVal);
            retVal = new Double(d);
        }
        catch (NumberFormatException notADouble) {
            try {
                long l = Long.parseLong(strVal);
                retVal = new Long(l);
            }
            catch (NumberFormatException notALong) {
                retVal = strVal;
            }
        }
        return retVal;
    }

    public static Node dataNode(Object data, String path) {
        if (data == null || !(data instanceof Node)) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.error((Object)"Data(): Cannot evaluate an XPath expression in the absence of a context Node, null returned");
            return null;
        }
        Node dataNode = (Node)data;
        NodeList result = null;
        try {
            result = XPathAPI.selectNodeList((Node)dataNode, (String)path);
        }
        catch (TransformerException te) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.error((Object)te.getMessage(), (Throwable)te);
            return null;
        }
        int length = result.getLength();
        if (length == 0) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): No nodes matching the XPath expression \"" + path + "\", returning null"));
            return null;
        }
        if (length > 1) {
            Log log = LogFactory.getLog((Class)Builtin.class);
            log.warn((Object)("Data(): Multiple nodes matching XPath expression" + path + "\", returning first"));
        }
        return result.item(0);
    }

    public static Object data(Object data, String path) {
        Object retVal = null;
        String strVal = SCXMLHelper.getNodeValue(Builtin.dataNode(data, path));
        try {
            double d = Double.parseDouble(strVal);
            retVal = new Double(d);
        }
        catch (NumberFormatException notADouble) {
            try {
                long l = Long.parseLong(strVal);
                retVal = new Long(l);
            }
            catch (NumberFormatException notALong) {
                retVal = strVal;
            }
        }
        return retVal;
    }

    private static class DataPrefixResolver
    implements PrefixResolver {
        private Map namespaces;

        private DataPrefixResolver(Map namespaces) {
            this.namespaces = namespaces;
        }

        public String getNamespaceForPrefix(String prefix) {
            return (String)this.namespaces.get(prefix);
        }

        public String getNamespaceForPrefix(String prefix, Node nsContext) {
            return (String)this.namespaces.get(prefix);
        }

        public String getBaseIdentifier() {
            return null;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    }
}

