/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import java.util.Collection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.PathResolver;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.PathResolverHolder;
import org.apache.commons.scxml.model.State;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Assign
extends Action
implements PathResolverHolder {
    private static final long serialVersionUID = 1L;
    private String name;
    private String location;
    private String src;
    private String expr;
    private PathResolver pathResolver;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public void execute(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Log appLog, Collection derivedEvents) throws ModelException, SCXMLExpressionException {
        State parentState = this.getParentState();
        Context ctx = scInstance.getContext(parentState);
        Evaluator eval = scInstance.getEvaluator();
        ctx.setLocal(Assign.getNamespacesKey(), this.getNamespaces());
        if (!SCXMLHelper.isStringEmpty(this.location)) {
            Node oldNode = eval.evalLocation(ctx, this.location);
            if (oldNode != null) {
                Node newNode = null;
                try {
                    newNode = this.src != null && this.src.trim().length() > 0 ? this.getSrcNode() : eval.evalLocation(ctx, this.expr);
                    if (newNode != null) {
                        for (Node child = newNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                            Node importedNode = oldNode.getOwnerDocument().importNode(child, true);
                            oldNode.appendChild(importedNode);
                        }
                    }
                }
                catch (SCXMLExpressionException see) {
                    Object valueObject = eval.eval(ctx, this.expr);
                    SCXMLHelper.setNodeValue(oldNode, valueObject.toString());
                }
                if (appLog.isDebugEnabled()) {
                    appLog.debug((Object)("<assign>: data node '" + oldNode.getNodeName() + "' updated"));
                }
                TriggerEvent ev = new TriggerEvent(this.name + ".change", 2);
                derivedEvents.add(ev);
            } else {
                appLog.error((Object)"<assign>: location does not point to a <data> node");
            }
        } else if (!ctx.has(this.name)) {
            errRep.onError("UNDEFINED_VARIABLE", this.name + " = null", parentState);
        } else {
            Object varObj = null;
            varObj = this.src != null && this.src.trim().length() > 0 ? this.getSrcNode() : eval.eval(ctx, this.expr);
            ctx.set(this.name, varObj);
            if (appLog.isDebugEnabled()) {
                appLog.debug((Object)("<assign>: Set variable '" + this.name + "' to '" + String.valueOf(varObj) + "'"));
            }
            TriggerEvent ev = new TriggerEvent(this.name + ".change", 2);
            derivedEvents.add(ev);
        }
        ctx.setLocal(Assign.getNamespacesKey(), null);
    }

    private Node getSrcNode() {
        String resolvedSrc = this.src;
        if (this.pathResolver != null) {
            resolvedSrc = this.pathResolver.resolvePath(this.src);
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(resolvedSrc);
        }
        catch (Throwable t) {
            Log log = LogFactory.getLog((Class)Assign.class);
            log.error((Object)t.getMessage(), t);
        }
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement();
    }
}

