/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.semantics;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.TransitionTarget;

final class TransitionTargetComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;

    TransitionTargetComparator() {
    }

    public int compare(Object o1, Object o2) {
        TransitionTarget tt1 = (TransitionTarget)o1;
        TransitionTarget tt2 = (TransitionTarget)o2;
        if (tt1 == tt2) {
            return 0;
        }
        if (SCXMLHelper.isDescendant(tt1, tt2)) {
            return -1;
        }
        if (SCXMLHelper.isDescendant(tt2, tt1)) {
            return 1;
        }
        int tc1 = this.countChainLength(tt1);
        int tc2 = this.countChainLength(tt2);
        return tc2 - tc1;
    }

    private int countChainLength(TransitionTarget tt) {
        int count = 0;
        for (TransitionTarget parent = tt.getParent(); parent != null; parent = parent.getParent()) {
            ++count;
        }
        return count;
    }
}

