/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.io;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.Assign;
import org.apache.commons.scxml.model.Cancel;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.Else;
import org.apache.commons.scxml.model.ElseIf;
import org.apache.commons.scxml.model.Exit;
import org.apache.commons.scxml.model.ExternalContent;
import org.apache.commons.scxml.model.Finalize;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.If;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.OnEntry;
import org.apache.commons.scxml.model.OnExit;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Param;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Send;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.model.Var;
import org.w3c.dom.Node;

public class SCXMLSerializer {
    private static final String INDENT = " ";
    private static final Transformer XFORMER = SCXMLSerializer.getTransformer();

    public static String serialize(SCXML scxml) {
        Datamodel dm;
        StringBuffer b = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<scxml xmlns=\"").append(scxml.getXmlns()).append("\" version=\"").append(scxml.getVersion()).append("\" initialstate=\"").append(scxml.getInitialstate()).append("\">\n");
        if (XFORMER == null) {
            Log log = LogFactory.getLog((Class)SCXMLSerializer.class);
            log.warn((Object)"SCXMLSerializer: DOM serialization pertinent to the document will be skipped since a suitable JAXP Transformer could not be instantiated.");
        }
        if ((dm = scxml.getDatamodel()) != null) {
            SCXMLSerializer.serializeDatamodel(b, dm, INDENT);
        }
        Map c = scxml.getChildren();
        Iterator i = c.keySet().iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)c.get(i.next());
            if (tt instanceof State) {
                SCXMLSerializer.serializeState(b, (State)tt, INDENT);
                continue;
            }
            SCXMLSerializer.serializeParallel(b, (Parallel)tt, INDENT);
        }
        b.append("</scxml>\n");
        return b.toString();
    }

    public static void serializeState(StringBuffer b, State s, String indent) {
        Datamodel dm;
        List h;
        b.append(indent).append("<state");
        SCXMLSerializer.serializeTransitionTargetAttributes(b, s);
        boolean f = s.isFinal();
        if (f) {
            b.append(" final=\"true\"");
        }
        b.append(">\n");
        Initial ini = s.getInitial();
        if (ini != null) {
            SCXMLSerializer.serializeInitial(b, ini, indent + INDENT);
        }
        if ((h = s.getHistory()) != null) {
            SCXMLSerializer.serializeHistory(b, h, indent + INDENT);
        }
        if ((dm = s.getDatamodel()) != null) {
            SCXMLSerializer.serializeDatamodel(b, dm, indent + INDENT);
        }
        SCXMLSerializer.serializeOnEntry(b, s, indent + INDENT);
        List t = s.getTransitionsList();
        for (int i = 0; i < t.size(); ++i) {
            SCXMLSerializer.serializeTransition(b, (Transition)t.get(i), indent + INDENT);
        }
        Parallel p = s.getParallel();
        Invoke inv = s.getInvoke();
        if (p != null) {
            SCXMLSerializer.serializeParallel(b, p, indent + INDENT);
        } else if (inv != null) {
            SCXMLSerializer.serializeInvoke(b, inv, indent + INDENT);
        } else {
            Map c = s.getChildren();
            Iterator j = c.keySet().iterator();
            while (j.hasNext()) {
                State cs = (State)c.get(j.next());
                SCXMLSerializer.serializeState(b, cs, indent + INDENT);
            }
        }
        SCXMLSerializer.serializeOnExit(b, s, indent + INDENT);
        b.append(indent).append("</state>\n");
    }

    public static void serializeParallel(StringBuffer b, Parallel p, String indent) {
        b.append(indent).append("<parallel");
        SCXMLSerializer.serializeTransitionTargetAttributes(b, p);
        b.append(">\n");
        SCXMLSerializer.serializeOnEntry(b, p, indent + INDENT);
        Set s = p.getChildren();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            SCXMLSerializer.serializeState(b, (State)i.next(), indent + INDENT);
        }
        SCXMLSerializer.serializeOnExit(b, p, indent + INDENT);
        b.append(indent).append("</parallel>\n");
    }

    public static void serializeInvoke(StringBuffer b, Invoke i, String indent) {
        b.append(indent).append("<invoke");
        String ttype = i.getTargettype();
        String src = i.getSrc();
        String srcexpr = i.getSrcexpr();
        if (ttype != null) {
            b.append(" targettype=\"").append(ttype).append("\"");
        }
        if (src != null) {
            b.append(" src=\"").append(src).append("\"");
        } else if (srcexpr != null) {
            b.append(" srcexpr=\"").append(srcexpr).append("\"");
        }
        b.append(">\n");
        List params = i.params();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Param p = (Param)iter.next();
            b.append(indent).append(INDENT).append("<param name=\"").append(p.getName()).append("\" expr=\"").append(p.getExpr()).append("\"/>\n");
        }
        Finalize f = i.getFinalize();
        if (f != null) {
            b.append(indent).append(INDENT).append("<finalize>\n");
            SCXMLSerializer.serializeActions(b, f.getActions(), indent + INDENT + INDENT);
            b.append(indent).append(INDENT).append("</finalize>\n");
        }
        b.append(indent).append("</invoke>\n");
    }

    public static void serializeInitial(StringBuffer b, Initial i, String indent) {
        b.append(indent).append("<initial");
        SCXMLSerializer.serializeTransitionTargetAttributes(b, i);
        b.append(">\n");
        SCXMLSerializer.serializeTransition(b, i.getTransition(), indent + INDENT);
        b.append(indent).append("</initial>\n");
    }

    public static void serializeHistory(StringBuffer b, List l, String indent) {
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                History h = (History)l.get(i);
                b.append(indent).append("<history");
                SCXMLSerializer.serializeTransitionTargetAttributes(b, h);
                if (h.isDeep()) {
                    b.append(" type=\"deep\"");
                } else {
                    b.append(" type=\"shallow\"");
                }
                b.append(">\n");
                SCXMLSerializer.serializeTransition(b, h.getTransition(), indent + INDENT);
                b.append(indent).append("</history>\n");
            }
        }
    }

    public static void serializeTransition(StringBuffer b, Transition t, String indent) {
        b.append(indent).append("<transition event=\"").append(t.getEvent()).append("\" cond=\"").append(t.getCond()).append("\">\n");
        boolean exit = SCXMLSerializer.serializeActions(b, t.getActions(), indent + INDENT);
        if (!exit) {
            SCXMLSerializer.serializeTarget(b, t, indent + INDENT);
        }
        b.append(indent).append("</transition>\n");
    }

    public static void serializeTarget(StringBuffer b, Transition t, String indent) {
        b.append(indent).append("<target");
        String n = t.getNext();
        if (n != null) {
            b.append(" next=\"" + n + "\">\n");
        } else {
            b.append(">\n");
            if (t.getTarget() != null) {
                SCXMLSerializer.serializeState(b, (State)t.getTarget(), indent + INDENT);
            }
        }
        b.append(indent).append("</target>\n");
    }

    public static void serializeDatamodel(StringBuffer b, Datamodel dm, String indent) {
        List data = dm.getData();
        if (data != null && data.size() > 0) {
            b.append(indent).append("<datamodel>\n");
            if (XFORMER == null) {
                b.append(indent).append(INDENT).append("<!-- Body content was not serialized -->\n");
                b.append(indent).append("</datamodel>\n");
                return;
            }
            Iterator iter = data.iterator();
            while (iter.hasNext()) {
                Data datum = (Data)iter.next();
                Node dataNode = datum.getNode();
                if (dataNode != null) {
                    StringWriter out = new StringWriter();
                    try {
                        DOMSource input = new DOMSource(dataNode);
                        StreamResult output = new StreamResult(out);
                        XFORMER.transform(input, output);
                    }
                    catch (TransformerException te) {
                        Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLSerializer == null ? SCXMLSerializer.class$("org.apache.commons.scxml.io.SCXMLSerializer") : class$org$apache$commons$scxml$io$SCXMLSerializer));
                        log.error((Object)te.getMessage(), (Throwable)te);
                        b.append(indent).append(INDENT).append("<!-- Data content not serialized -->\n");
                    }
                    b.append(indent).append(INDENT).append(out.toString());
                    continue;
                }
                b.append(indent).append(INDENT).append("<data name=\"").append(datum.getName()).append("\" expr=\"").append(datum.getExpr()).append("\" />\n");
            }
            b.append(indent).append("</datamodel>\n");
        }
    }

    public static void serializeOnEntry(StringBuffer b, TransitionTarget t, String indent) {
        OnEntry e = t.getOnEntry();
        if (e != null && e.getActions().size() > 0) {
            b.append(indent).append("<onentry>\n");
            SCXMLSerializer.serializeActions(b, e.getActions(), indent + INDENT);
            b.append(indent).append("</onentry>\n");
        }
    }

    public static void serializeOnExit(StringBuffer b, TransitionTarget t, String indent) {
        OnExit x = t.getOnExit();
        if (x != null && x.getActions().size() > 0) {
            b.append(indent).append("<onexit>\n");
            SCXMLSerializer.serializeActions(b, x.getActions(), indent + INDENT);
            b.append(indent).append("</onexit>\n");
        }
    }

    public static boolean serializeActions(StringBuffer b, List l, String indent) {
        if (l == null) {
            return false;
        }
        boolean exit = false;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Action a = (Action)i.next();
            if (a instanceof Var) {
                Var v = (Var)a;
                b.append(indent).append("<var name=\"").append(v.getName()).append("\" expr=\"").append(v.getExpr()).append("\"/>\n");
                continue;
            }
            if (a instanceof Assign) {
                Assign asn = (Assign)a;
                b.append(indent).append("<assign");
                if (!SCXMLHelper.isStringEmpty(asn.getLocation())) {
                    b.append(" location=\"").append(asn.getLocation());
                    if (!SCXMLHelper.isStringEmpty(asn.getSrc())) {
                        b.append("\" src=\"").append(asn.getSrc());
                    } else {
                        b.append("\" expr=\"").append(asn.getExpr());
                    }
                } else {
                    b.append(" name=\"").append(asn.getName()).append("\" expr=\"").append(asn.getExpr());
                }
                b.append("\"/>\n");
                continue;
            }
            if (a instanceof Send) {
                SCXMLSerializer.serializeSend(b, (Send)a, indent);
                continue;
            }
            if (a instanceof Cancel) {
                Cancel c = (Cancel)a;
                b.append(indent).append("<cancel sendid=\"").append(c.getSendid()).append("\"/>\n");
                continue;
            }
            if (a instanceof org.apache.commons.scxml.model.Log) {
                org.apache.commons.scxml.model.Log lg = (org.apache.commons.scxml.model.Log)a;
                b.append(indent).append("<log expr=\"").append(lg.getExpr()).append("\"/>\n");
                continue;
            }
            if (a instanceof Exit) {
                Exit e = (Exit)a;
                b.append(indent).append("<exit");
                String expr = e.getExpr();
                String nl = e.getNamelist();
                if (expr != null) {
                    b.append(" expr=\"" + expr + "\"");
                }
                if (nl != null) {
                    b.append(" namelist=\"" + nl + "\"");
                }
                b.append("/>\n");
                exit = true;
                continue;
            }
            if (a instanceof If) {
                If iff = (If)a;
                SCXMLSerializer.serializeIf(b, iff, indent);
                continue;
            }
            if (a instanceof Else) {
                b.append(indent).append("<else/>\n");
                continue;
            }
            if (!(a instanceof ElseIf)) continue;
            ElseIf eif = (ElseIf)a;
            b.append(indent).append("<elseif cond=\"").append(eif.getCond()).append("\" />\n");
        }
        return exit;
    }

    public static void serializeSend(StringBuffer b, Send send, String indent) {
        b.append(indent).append("<send sendid=\"").append(send.getSendid()).append("\" target=\"").append(send.getTarget()).append("\" targetType=\"").append(send.getTargettype()).append("\" namelist=\"").append(send.getNamelist()).append("\" delay=\"").append(send.getDelay()).append("\" events=\"").append(send.getEvent()).append("\" hints=\"").append(send.getHints()).append("\">\n").append(SCXMLSerializer.getBodyContent(send)).append(indent).append("</send>\n");
    }

    public static final String getBodyContent(ExternalContent externalContent) {
        StringBuffer buf = new StringBuffer();
        List externalNodes = externalContent.getExternalNodes();
        if (externalNodes.size() > 0 && XFORMER == null) {
            buf.append("<!-- Body content was not serialized -->\n");
            return buf.toString();
        }
        for (int i = 0; i < externalNodes.size(); ++i) {
            DOMSource input = new DOMSource((Node)externalNodes.get(i));
            StringWriter out = new StringWriter();
            StreamResult output = new StreamResult(out);
            try {
                XFORMER.transform(input, output);
            }
            catch (TransformerException te) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLSerializer == null ? SCXMLSerializer.class$("org.apache.commons.scxml.io.SCXMLSerializer") : class$org$apache$commons$scxml$io$SCXMLSerializer));
                log.error((Object)te.getMessage(), (Throwable)te);
                buf.append("<!-- Not all body content was serialized -->");
            }
            buf.append(out.toString()).append("\n");
        }
        return buf.toString();
    }

    public static void serializeIf(StringBuffer b, If iff, String indent) {
        b.append(indent).append("<if cond=\"").append(iff.getCond()).append("\">\n");
        SCXMLSerializer.serializeActions(b, iff.getActions(), indent + INDENT);
        b.append(indent).append("</if>\n");
    }

    private static void serializeTransitionTargetAttributes(StringBuffer b, TransitionTarget t) {
        String pid;
        TransitionTarget pt;
        String id = t.getId();
        if (id != null) {
            b.append(" id=\"").append(id).append("\"");
        }
        if ((pt = t.getParent()) != null && (pid = pt.getId()) != null) {
            b.append(" parentid=\"").append(pid).append("\"");
        }
    }

    private static Transformer getTransformer() {
        Transformer transformer = null;
        Properties outputProps = new Properties();
        outputProps.put("omit-xml-declaration", "yes");
        outputProps.put("standalone", "no");
        outputProps.put("indent", "yes");
        try {
            TransformerFactory tfFactory = TransformerFactory.newInstance();
            transformer = tfFactory.newTransformer();
            transformer.setOutputProperties(outputProps);
        }
        catch (Throwable t) {
            return null;
        }
        return transformer;
    }

    private SCXMLSerializer() {
    }
}

