/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.OnEntry;
import org.apache.commons.scxml.model.OnExit;
import org.apache.commons.scxml.model.State;

public abstract class TransitionTarget
implements Serializable {
    private String id;
    private OnEntry onEntry = new OnEntry();
    private OnExit onExit;
    private Datamodel datamodel;
    private TransitionTarget parent;
    private List history;

    public TransitionTarget() {
        this.onEntry.setParent(this);
        this.onExit = new OnExit();
        this.onExit.setParent(this);
        this.parent = null;
        this.history = new ArrayList();
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final OnEntry getOnEntry() {
        return this.onEntry;
    }

    public final void setOnEntry(OnEntry onEntry) {
        this.onEntry = onEntry;
        this.onEntry.setParent(this);
    }

    public final OnExit getOnExit() {
        return this.onExit;
    }

    public final void setOnExit(OnExit onExit) {
        this.onExit = onExit;
        this.onExit.setParent(this);
    }

    public final Datamodel getDatamodel() {
        return this.datamodel;
    }

    public final void setDatamodel(Datamodel datamodel) {
        this.datamodel = datamodel;
    }

    public final TransitionTarget getParent() {
        return this.parent;
    }

    public final void setParent(TransitionTarget parent) {
        this.parent = parent;
    }

    public final State getParentState() {
        TransitionTarget tt = this.getParent();
        if (tt == null) {
            return null;
        }
        if (tt instanceof State) {
            return (State)tt;
        }
        return tt.getParentState();
    }

    public final void addHistory(History h) {
        this.history.add(h);
        h.setParent(this);
    }

    public final boolean hasHistory() {
        return !this.history.isEmpty();
    }

    public final List getHistory() {
        return this.history;
    }
}

