/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.io;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;

final class ModelUpdater {
    private static final String ERR_SCXML_NO_INIT = "No SCXML child state with ID \"{0}\" found; illegal initialstate for SCXML document";
    private static final String ERR_STATE_NO_INIT = "No initial element available for {0}";
    private static final String ERR_STATE_BAD_INIT = "Initial state null or not a descendant of {0}";
    private static final String ERR_STATE_BAD_CONTENTS = "{0} should contain either one <parallel>, one <invoke> or any number of <state> children.";
    private static final String ERR_STATE_NO_HIST = "Referenced history state null for {0}";
    private static final String ERR_STATE_BAD_SHALLOW_HIST = "History state for shallow history is not child for {0}";
    private static final String ERR_STATE_BAD_DEEP_HIST = "History state for deep history is not descendant for {0}";
    private static final String ERR_TARGET_NOT_FOUND = "Transition target with ID \"{0}\" not found";
    private static final String ERR_ILLEGAL_TARGETS = "Transition targets \"{0}\" do not satisfy the requirements for target regions belonging to a <parallel>";
    private static final String ERR_HISTORY_SIMPLE_STATE = "Simple {0} contains history elements";
    private static final String ERR_HISTORY_NO_DEFAULT = "No default target specified for history with ID \"{0}\" belonging to {1}";
    private static final String ERR_HISTORY_BAD_DEFAULT = "Default target specified for history with ID \"{0}\" belonging to \"{1}\" is also a history";
    private static final String ERR_INVOKE_NO_TARGETTYPE = "{0} contains <invoke> with no \"targettype\" attribute specified.";
    private static final String ERR_INVOKE_NO_SRC = "{0} contains <invoke> without a \"src\" or \"srcexpr\" attribute specified.";
    private static final String ERR_INVOKE_AMBIGUOUS_SRC = "{0} contains <invoke> with both \"src\" and \"srcexpr\" attributes specified, must specify either one, but not both.";

    static void updateSCXML(SCXML scxml) throws ModelException {
        String initialstate = scxml.getInitialstate();
        TransitionTarget initialTarget = (TransitionTarget)scxml.getTargets().get(initialstate);
        if (initialTarget == null) {
            ModelUpdater.logAndThrowModelError(ERR_SCXML_NO_INIT, new Object[]{initialstate});
        }
        scxml.setInitialTarget(initialTarget);
        Map targets = scxml.getTargets();
        Map children = scxml.getChildren();
        Iterator i = children.keySet().iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)children.get(i.next());
            if (tt instanceof State) {
                ModelUpdater.updateState((State)tt, targets);
                continue;
            }
            ModelUpdater.updateParallel((Parallel)tt, targets);
        }
    }

    private static void updateState(State s, Map targets) throws ModelException {
        Initial ini = s.getInitial();
        Map c = s.getChildren();
        List initialStates = null;
        if (!c.isEmpty()) {
            if (ini == null) {
                ModelUpdater.logAndThrowModelError(ERR_STATE_NO_INIT, new Object[]{ModelUpdater.getStateName(s)});
            }
            Transition initialTransition = ini.getTransition();
            ModelUpdater.updateTransition(initialTransition, targets);
            initialStates = initialTransition.getTargets();
            if (initialStates.size() == 0) {
                ModelUpdater.logAndThrowModelError(ERR_STATE_BAD_INIT, new Object[]{ModelUpdater.getStateName(s)});
            } else {
                for (int i = 0; i < initialStates.size(); ++i) {
                    TransitionTarget initialState = (TransitionTarget)initialStates.get(i);
                    if (SCXMLHelper.isDescendant(initialState, s)) continue;
                    ModelUpdater.logAndThrowModelError(ERR_STATE_BAD_INIT, new Object[]{ModelUpdater.getStateName(s)});
                }
            }
        }
        List histories = s.getHistory();
        Iterator histIter = histories.iterator();
        while (histIter.hasNext()) {
            History h;
            Transition historyTransition;
            if (s.isSimple()) {
                ModelUpdater.logAndThrowModelError(ERR_HISTORY_SIMPLE_STATE, new Object[]{ModelUpdater.getStateName(s)});
            }
            if ((historyTransition = (h = (History)histIter.next()).getTransition()) == null) {
                if (initialStates != null && initialStates.size() > 0) {
                    for (int i = 0; i < initialStates.size(); ++i) {
                        if (!(initialStates.get(i) instanceof History)) continue;
                        ModelUpdater.logAndThrowModelError(ERR_HISTORY_BAD_DEFAULT, new Object[]{h.getId(), ModelUpdater.getStateName(s)});
                    }
                    historyTransition = new Transition();
                    historyTransition.getTargets().addAll(initialStates);
                    h.setTransition(historyTransition);
                } else {
                    ModelUpdater.logAndThrowModelError(ERR_HISTORY_NO_DEFAULT, new Object[]{h.getId(), ModelUpdater.getStateName(s)});
                }
            }
            ModelUpdater.updateTransition(historyTransition, targets);
            List historyStates = historyTransition.getTargets();
            if (historyStates.size() == 0) {
                ModelUpdater.logAndThrowModelError(ERR_STATE_NO_HIST, new Object[]{ModelUpdater.getStateName(s)});
            }
            for (int i = 0; i < historyStates.size(); ++i) {
                TransitionTarget historyState = (TransitionTarget)historyStates.get(i);
                if (!h.isDeep()) {
                    if (c.containsValue(historyState)) continue;
                    ModelUpdater.logAndThrowModelError(ERR_STATE_BAD_SHALLOW_HIST, new Object[]{ModelUpdater.getStateName(s)});
                    continue;
                }
                if (SCXMLHelper.isDescendant(historyState, s)) continue;
                ModelUpdater.logAndThrowModelError(ERR_STATE_BAD_DEEP_HIST, new Object[]{ModelUpdater.getStateName(s)});
            }
        }
        List t = s.getTransitionsList();
        for (int i = 0; i < t.size(); ++i) {
            Transition trn = (Transition)t.get(i);
            ModelUpdater.updateTransition(trn, targets);
        }
        Parallel p = s.getParallel();
        Invoke inv = s.getInvoke();
        if (inv != null && p != null || inv != null && !c.isEmpty() || p != null && !c.isEmpty()) {
            ModelUpdater.logAndThrowModelError(ERR_STATE_BAD_CONTENTS, new Object[]{ModelUpdater.getStateName(s)});
        }
        if (p != null) {
            ModelUpdater.updateParallel(p, targets);
        } else if (inv != null) {
            boolean noSrcexpr;
            String src;
            String ttype = inv.getTargettype();
            if (ttype == null || ttype.trim().length() == 0) {
                ModelUpdater.logAndThrowModelError(ERR_INVOKE_NO_TARGETTYPE, new Object[]{ModelUpdater.getStateName(s)});
            }
            boolean noSrc = (src = inv.getSrc()) == null || src.trim().length() == 0;
            String srcexpr = inv.getSrcexpr();
            boolean bl = noSrcexpr = srcexpr == null || srcexpr.trim().length() == 0;
            if (noSrc && noSrcexpr) {
                ModelUpdater.logAndThrowModelError(ERR_INVOKE_NO_SRC, new Object[]{ModelUpdater.getStateName(s)});
            }
            if (!noSrc && !noSrcexpr) {
                ModelUpdater.logAndThrowModelError(ERR_INVOKE_AMBIGUOUS_SRC, new Object[]{ModelUpdater.getStateName(s)});
            }
        } else {
            Iterator j = c.keySet().iterator();
            while (j.hasNext()) {
                TransitionTarget tt = (TransitionTarget)c.get(j.next());
                if (tt instanceof State) {
                    ModelUpdater.updateState((State)tt, targets);
                    continue;
                }
                if (!(tt instanceof Parallel)) continue;
                ModelUpdater.updateParallel((Parallel)tt, targets);
            }
        }
    }

    private static void updateParallel(Parallel p, Map targets) throws ModelException {
        Iterator i = p.getChildren().iterator();
        while (i.hasNext()) {
            ModelUpdater.updateState((State)i.next(), targets);
        }
    }

    private static void updateTransition(Transition t, Map targets) throws ModelException {
        String next = t.getNext();
        if (next == null) {
            return;
        }
        List tts = t.getTargets();
        if (tts.size() == 0) {
            boolean legal;
            StringTokenizer ids = new StringTokenizer(next);
            while (ids.hasMoreTokens()) {
                String id = ids.nextToken();
                TransitionTarget tt = (TransitionTarget)targets.get(id);
                if (tt == null) {
                    ModelUpdater.logAndThrowModelError(ERR_TARGET_NOT_FOUND, new Object[]{id});
                }
                tts.add(tt);
            }
            if (tts.size() > 1 && !(legal = ModelUpdater.verifyTransitionTargets(tts))) {
                ModelUpdater.logAndThrowModelError(ERR_ILLEGAL_TARGETS, new Object[]{next});
            }
        }
        t.getPaths();
    }

    private static void logAndThrowModelError(String errType, Object[] msgArgs) throws ModelException {
        MessageFormat msgFormat = new MessageFormat(errType);
        String errMsg = msgFormat.format(msgArgs);
        Log log = LogFactory.getLog((Class)ModelUpdater.class);
        log.error((Object)errMsg);
        throw new ModelException(errMsg);
    }

    private static String getStateName(State state) {
        String badState = "anonymous state";
        if (!SCXMLHelper.isStringEmpty(state.getId())) {
            badState = "state with ID \"" + state.getId() + "\"";
        }
        return badState;
    }

    private static boolean verifyTransitionTargets(List tts) {
        if (tts.size() <= 1) {
            return true;
        }
        TransitionTarget lca = SCXMLHelper.getLCA((TransitionTarget)tts.get(0), (TransitionTarget)tts.get(1));
        if (lca == null || !(lca instanceof Parallel)) {
            return false;
        }
        Parallel p = (Parallel)lca;
        HashSet<TransitionTarget> regions = new HashSet<TransitionTarget>();
        for (int i = 0; i < tts.size(); ++i) {
            TransitionTarget tt = (TransitionTarget)tts.get(i);
            while (tt.getParent() != p) {
                tt = tt.getParent();
            }
            if (regions.add(tt)) continue;
            return false;
        }
        return regions.size() == p.getChildren().size();
    }

    private ModelUpdater() {
    }
}

