/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.ExternalContent;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.State;

public class Send
extends Action
implements ExternalContent {
    private static final long serialVersionUID = 1L;
    private static final String TARGETTYPE_SCXML = "scxml";
    private static final String EVENT_ERR_SEND_TARGETUNAVAILABLE = "error.send.targetunavailable";
    private String sendid;
    private String target;
    private String targettype;
    private String delay;
    private String hints;
    private String namelist;
    private List externalNodes = new ArrayList();
    private String event;
    private static final String MILLIS = "ms";
    private static final String SECONDS = "s";
    private static final String MINUTES = "m";
    private static final long MILLIS_IN_A_SECOND = 1000L;
    private static final long MILLIS_IN_A_MINUTE = 60000L;

    public final String getDelay() {
        return this.delay;
    }

    public final void setDelay(String delay) {
        this.delay = delay;
    }

    public final List getExternalNodes() {
        return this.externalNodes;
    }

    public final void setExternalNodes(List externalNodes) {
        this.externalNodes = externalNodes;
    }

    public final String getHints() {
        return this.hints;
    }

    public final void setHints(String hints) {
        this.hints = hints;
    }

    public final String getNamelist() {
        return this.namelist;
    }

    public final void setNamelist(String namelist) {
        this.namelist = namelist;
    }

    public final String getSendid() {
        return this.sendid;
    }

    public final void setSendid(String sendid) {
        this.sendid = sendid;
    }

    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(String target) {
        this.target = target;
    }

    public final String getTargettype() {
        return this.targettype;
    }

    public final void setTargettype(String targettype) {
        this.targettype = targettype;
    }

    public final void setEvent(String event) {
        this.event = event;
    }

    public final String getEvent() {
        return this.event;
    }

    public void execute(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Log appLog, Collection derivedEvents) throws ModelException, SCXMLExpressionException {
        State parentState = this.getParentState();
        Context ctx = scInstance.getContext(parentState);
        ctx.setLocal(Send.getNamespacesKey(), this.getNamespaces());
        Evaluator eval = scInstance.getEvaluator();
        Object hintsValue = null;
        if (!SCXMLHelper.isStringEmpty(this.hints)) {
            hintsValue = eval.eval(ctx, this.hints);
        }
        String targetValue = this.target;
        if (!SCXMLHelper.isStringEmpty(this.target) && SCXMLHelper.isStringEmpty(targetValue = (String)eval.eval(ctx, this.target)) && appLog.isWarnEnabled()) {
            appLog.warn((Object)("<send>: target expression \"" + this.target + "\" evaluated to null or empty String"));
        }
        String targettypeValue = this.targettype;
        if (!SCXMLHelper.isStringEmpty(this.targettype)) {
            targettypeValue = (String)eval.eval(ctx, this.targettype);
            if (SCXMLHelper.isStringEmpty(targettypeValue) && appLog.isWarnEnabled()) {
                appLog.warn((Object)("<send>: targettype expression \"" + this.targettype + "\" evaluated to null or empty String"));
            }
        } else {
            targettypeValue = TARGETTYPE_SCXML;
        }
        HashMap<String, Object> params = null;
        if (!SCXMLHelper.isStringEmpty(this.namelist)) {
            StringTokenizer tkn = new StringTokenizer(this.namelist);
            params = new HashMap<String, Object>(tkn.countTokens());
            while (tkn.hasMoreTokens()) {
                String varName = tkn.nextToken();
                Object varObj = ctx.get(varName);
                if (varObj == null) {
                    errRep.onError("UNDEFINED_VARIABLE", varName + " = null", parentState);
                }
                params.put(varName, varObj);
            }
        }
        long wait = this.parseDelay(appLog);
        if (targettypeValue != null && targettypeValue.trim().equalsIgnoreCase(TARGETTYPE_SCXML)) {
            if (SCXMLHelper.isStringEmpty(targetValue)) {
                if (wait == 0L) {
                    if (appLog.isDebugEnabled()) {
                        appLog.debug((Object)("<send>: Enqueued event '" + this.event + "' with no delay"));
                    }
                    derivedEvents.add(new TriggerEvent(this.event, 3, params));
                    return;
                }
            } else {
                if (appLog.isWarnEnabled()) {
                    appLog.warn((Object)("<send>: Unavailable target - " + targetValue));
                }
                derivedEvents.add(new TriggerEvent(EVENT_ERR_SEND_TARGETUNAVAILABLE, 5));
                return;
            }
        }
        ctx.setLocal(Send.getNamespacesKey(), null);
        if (appLog.isDebugEnabled()) {
            appLog.debug((Object)("<send>: Dispatching event '" + this.event + "' to target '" + targetValue + "' of target type '" + targettypeValue + "' with suggested delay of " + wait + MILLIS));
        }
        evtDispatcher.send(this.sendid, targetValue, targettypeValue, this.event, params, hintsValue, wait, this.externalNodes);
    }

    private long parseDelay(Log appLog) throws SCXMLExpressionException {
        long wait = 0L;
        long multiplier = 1L;
        if (!SCXMLHelper.isStringEmpty(this.delay)) {
            String trimDelay;
            String numericDelay = trimDelay = this.delay.trim();
            if (trimDelay.endsWith(MILLIS)) {
                numericDelay = trimDelay.substring(0, trimDelay.length() - 2);
            } else if (trimDelay.endsWith(SECONDS)) {
                multiplier = 1000L;
                numericDelay = trimDelay.substring(0, trimDelay.length() - 1);
            } else if (trimDelay.endsWith(MINUTES)) {
                multiplier = 60000L;
                numericDelay = trimDelay.substring(0, trimDelay.length() - 1);
            }
            try {
                wait = Long.parseLong(numericDelay);
            }
            catch (NumberFormatException nfe) {
                appLog.error((Object)nfe.getMessage(), (Throwable)nfe);
                throw new SCXMLExpressionException(nfe.getMessage(), nfe);
            }
            wait *= multiplier;
        }
        return wait;
    }
}

