/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.Beta;
import org.apache.commons.numbers.gamma.LogBeta;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.TSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.NormalDistribution;

public abstract class TDistribution
extends AbstractContinuousDistribution {
    static final NormalDistribution STANDARD_NORMAL = NormalDistribution.of(0.0, 1.0);
    private final double degreesOfFreedom;

    private TDistribution(double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public static TDistribution of(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", degreesOfFreedom);
        }
        double variance = StudentsTDistribution.computeVariance(degreesOfFreedom);
        if (variance == 1.0) {
            return new NormalTDistribution(degreesOfFreedom);
        }
        return new StudentsTDistribution(degreesOfFreedom, variance);
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double survivalProbability(double x) {
        return this.cumulativeProbability(-x);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        return -this.inverseCumulativeProbability(p);
    }

    @Override
    public abstract double getMean();

    @Override
    public abstract double getVariance();

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    private static class StudentsTDistribution
    extends TDistribution {
        private static final double TWO = 2.0;
        private static final double CLOSE_TO_ZERO = 0.25;
        private final double mvp1Over2;
        private final double densityNormalisation;
        private final double logDensityNormalisation;
        private final double mean;
        private final double variance;

        StudentsTDistribution(double degreesOfFreedom, double variance) {
            super(degreesOfFreedom);
            this.mvp1Over2 = -0.5 * (degreesOfFreedom + 1.0);
            this.densityNormalisation = Math.sqrt(degreesOfFreedom) * Beta.value((double)0.5, (double)(degreesOfFreedom / 2.0));
            this.logDensityNormalisation = 0.5 * Math.log(degreesOfFreedom) + LogBeta.value((double)0.5, (double)(degreesOfFreedom / 2.0));
            this.mean = degreesOfFreedom > 1.0 ? 0.0 : Double.NaN;
            this.variance = variance;
        }

        static double computeVariance(double degreesOfFreedom) {
            if (degreesOfFreedom == Double.POSITIVE_INFINITY) {
                return 1.0;
            }
            if (degreesOfFreedom > 2.0) {
                return degreesOfFreedom / (degreesOfFreedom - 2.0);
            }
            if (degreesOfFreedom > 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }

        @Override
        public double density(double x) {
            double t2OverV = x * x / this.getDegreesOfFreedom();
            if (t2OverV < 0.25) {
                return Math.exp(Math.log1p(t2OverV) * this.mvp1Over2) / this.densityNormalisation;
            }
            return Math.pow(1.0 + t2OverV, this.mvp1Over2) / this.densityNormalisation;
        }

        @Override
        public double logDensity(double x) {
            return Math.log1p(x * x / this.getDegreesOfFreedom()) * this.mvp1Over2 - this.logDensityNormalisation;
        }

        @Override
        public double cumulativeProbability(double x) {
            double t2;
            if (x == 0.0) {
                return 0.5;
            }
            double v = this.getDegreesOfFreedom();
            double z = v < 2.0 * (t2 = x * x) ? RegularizedBeta.value((double)(v / (v + t2)), (double)(v / 2.0), (double)0.5) / 2.0 : RegularizedBeta.complement((double)(t2 / (v + t2)), (double)0.5, (double)(v / 2.0)) / 2.0;
            return x > 0.0 ? 1.0 - z : z;
        }

        @Override
        public double getMean() {
            return this.mean;
        }

        @Override
        public double getVariance() {
            return this.variance;
        }

        @Override
        double getMedian() {
            return 0.0;
        }

        @Override
        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            return () -> ((TSampler)TSampler.of((UniformRandomProvider)rng, (double)this.getDegreesOfFreedom())).sample();
        }
    }

    private static class NormalTDistribution
    extends TDistribution {
        NormalTDistribution(double degreesOfFreedom) {
            super(degreesOfFreedom);
        }

        @Override
        public double density(double x) {
            return STANDARD_NORMAL.density(x);
        }

        @Override
        public double probability(double x0, double x1) {
            return STANDARD_NORMAL.probability(x0, x1);
        }

        @Override
        public double logDensity(double x) {
            return STANDARD_NORMAL.logDensity(x);
        }

        @Override
        public double cumulativeProbability(double x) {
            return STANDARD_NORMAL.cumulativeProbability(x);
        }

        @Override
        public double inverseCumulativeProbability(double p) {
            return STANDARD_NORMAL.inverseCumulativeProbability(p);
        }

        @Override
        public double getMean() {
            return 0.0;
        }

        @Override
        public double getVariance() {
            return 1.0;
        }

        @Override
        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            return STANDARD_NORMAL.createSampler(rng);
        }
    }
}

