/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;

public final class LongSum
implements LongStatistic,
StatisticAccumulator<LongSum> {
    private final Int128 sum;

    private LongSum() {
        this(Int128.create());
    }

    private LongSum(Int128 sum) {
        this.sum = sum;
    }

    public static LongSum create() {
        return new LongSum();
    }

    public static LongSum of(long ... values) {
        Int128 s = Int128.create();
        for (long x : values) {
            s.add(x);
        }
        return new LongSum(s);
    }

    Int128 getSum() {
        return this.sum;
    }

    @Override
    public void accept(long value) {
        this.sum.add(value);
    }

    @Override
    public int getAsInt() {
        return this.sum.toIntExact();
    }

    @Override
    public long getAsLong() {
        return this.sum.toLongExact();
    }

    @Override
    public double getAsDouble() {
        return this.sum.toDouble();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.sum.toBigInteger();
    }

    @Override
    public LongSum combine(LongSum other) {
        this.sum.add(other.sum);
        return this;
    }
}

