/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Arrays;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.combinatorics.LogFactorial;
import org.apache.commons.numbers.core.DD;
import org.apache.commons.numbers.core.DDMath;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.inference.SquareMatrixSupport;

final class KolmogorovSmirnovDistribution {
    private static final double PI2 = Math.PI * Math.PI;
    private static final double ROOT_TWO_PI = 2.5066282746310007;
    private static final double X_KS_HALF = 0.8275735551899077;
    private static final double X_KS_ONE = 0.1754243674345323;
    private static final double EPS = 2.220446049250313E-16;

    private KolmogorovSmirnovDistribution() {
    }

    static double ksSum(double x) {
        if (x < 0.8275735551899077) {
            if (x < 0.1754243674345323) {
                return 1.0;
            }
            double logt = -9.869604401089358 / (8.0 * x * x);
            double t = Math.exp(logt);
            double s = 2.5066282746310007 / x;
            double t8 = Math.pow(t, 8.0);
            if (t8 < 2.220446049250313E-16) {
                return -Math.expm1(Math.log(s) + logt);
            }
            double sum = 1.0 + t8 * (1.0 + t8 * t8 * (1.0 + t8 * t8 * t8));
            return 1.0 - s * t * sum;
        }
        double t = Math.exp(-2.0 * x * x);
        double t2 = t * t;
        double t3 = t * t * t;
        double t4 = t2 * t2;
        double sum = t * (1.0 - t3 * (1.0 - t2 * t3 * (1.0 - t3 * t4 * (1.0 - t2 * t3 * t4))));
        return KolmogorovSmirnovDistribution.clipProbability(2.0 * sum);
    }

    static double clipProbability(double p) {
        return Math.min(1.0, Math.max(0.0, p));
    }

    static final class One {
        private static final int VERY_LARGE_N = 1000000;
        private static final int SD_MAX_TERMS = 3;
        private static final int SD_MIN_N = 8;
        private static final int SUM_PRECISION_BITS = 53;
        private static final int SD_SUM_PRECISION_BITS = 107;
        private static final ScaledPower POWER_DEFAULT = null;

        private One() {
        }

        static double sf(double x, int n) {
            double p = One.sfExact(x, n);
            if (p >= 0.0) {
                return p;
            }
            if (n > 1000000) {
                return One.sfAsymptotic(x, n);
            }
            return One.sf(x, n, POWER_DEFAULT);
        }

        private static double sfExact(double x, int n) {
            if ((double)n * x * x >= 372.5 || x >= 1.0) {
                return 0.0;
            }
            if (x <= 0.0) {
                return 1.0;
            }
            if (n == 1) {
                return x;
            }
            double nx = (double)n * x;
            if (nx <= 1.0) {
                return 1.0 - x * Math.exp((double)(n - 1) * Math.log1p(x));
            }
            if ((double)(n - 1) <= nx) {
                return Math.pow(1.0 - x, n);
            }
            return -1.0;
        }

        private static double sfAsymptotic(double x, int n) {
            return Math.exp(-Math.pow(6.0 * (double)n * x + 1.0, 2.0) / (18.0 * (double)n));
        }

        static double sf(double x, int n, ScaledPower power) {
            long esum;
            DD sum;
            int maxN;
            double[] alpha = new double[]{0.0};
            int k = One.splitX(n, x, alpha);
            int regN = n - k - 1;
            int sdN = k - (alpha[0] == 0.0 ? 1 : 0);
            boolean sd = false;
            if (sdN < regN) {
                sd = sdN <= 1;
                sd |= sdN <= 3 && n >= 8;
            }
            int n2 = maxN = sd ? sdN : regN;
            ScaledPower fpow = power == POWER_DEFAULT ? (sd ? DDMath::pow : DD::pow) : power;
            int sumBits = sd ? 107 : 53 + One.log2(maxN >> 1);
            int[] ie = new int[]{0};
            long[] le = new long[]{0L};
            if (sd) {
                sum = fpow.pow(DD.ofSum((double)1.0, (double)x), n - 1, le);
                esum = le[0];
            } else {
                sum = fpow.pow(DD.ofDifference((double)1.0, (double)x), n, le);
                esum = le[0];
                sum = sum.divide(x).frexp(ie);
                esum += (long)ie[0];
            }
            DD c = DD.ONE;
            long ec = 0L;
            for (int i = 1; i <= maxN; ++i) {
                int b = Math.getExponent((c = c.multiply(DD.fromQuotient((double)(n - i + 1), (double)i))).hi());
                if (b != 0) {
                    c = c.scalb(-b);
                    ec += (long)b;
                }
                int j = sd ? n - i : i;
                DD s = fpow.pow(DD.fromQuotient((double)j, (double)n).add(x), j - 1, le);
                long es = le[0];
                DD t = fpow.pow(DD.fromQuotient((double)(n - j), (double)n).subtract(x), n - j, le);
                long et = le[0];
                long eaj = ec + es + et;
                if (eaj <= esum - (long)sumBits) break;
                DD aj = c.multiply(t).multiply(s);
                aj = aj.scalb((int)(eaj - esum));
                sum = sum.add(aj);
                sum = sum.frexp(ie);
                esum += (long)ie[0];
            }
            sum = sum.multiply(x);
            sum = sum.scalb((int)esum);
            if (sd) {
                sum = sum.negate().add(1.0);
            }
            return KolmogorovSmirnovDistribution.clipProbability(sum.doubleValue());
        }

        static int splitX(int n, double x, double[] alpha) {
            DD z = DD.ofProduct((double)n, (double)x);
            int k = (int)z.floor().hi();
            if ((z = z.subtract((double)k)).hi() == 1.0) {
                ++k;
                alpha[0] = 0.0;
            } else {
                alpha[0] = z.hi();
            }
            return k;
        }

        private static int log2(int n) {
            return 31 - Integer.numberOfLeadingZeros(n);
        }

        static interface ScaledPower {
            public DD pow(DD var1, int var2, long[] var3);
        }
    }

    static final class Two {
        private static final double PI2 = Math.PI * Math.PI;
        private static final double PI4 = 97.40909103400244;
        private static final double PI6 = 961.3891935753045;
        private static final double ROOT_TWO_PI = 2.5066282746310007;
        private static final double ROOT_HALF_PI = 1.2533141373155003;
        private static final double LOG_PG_MIN = -55.451774444795625;
        private static final double FOUR_A = -288.3492271129372;
        private static final double MTW_SCALE_THRESHOLD = 3.8725919148493183E-121;
        private static final double MTW_UP_SCALE = 2.5822498780869086E120;
        private static final int MTW_UP_SCALE_POWER = 400;
        private static final double P_DOWN_SCALE = 2.938735877055719E-39;
        private static final double P_UP_SCALE = 3.402823669209385E38;
        private static final int P_SCALE_POWER = 128;
        private static final int MAX_FACTORIAL = 170;
        private static final int LOG_MIN_NORMAL = -708;
        private static final int N140 = 140;
        private static final double NXX_0_754693 = 0.754693;
        private static final int NXX_4 = 4;
        private static final double NXX_2_2 = 2.2;
        private static final int N_100000 = 100000;
        private static final double NX32_1_4 = 1.4;
        private static final double HALF = 0.5;

        private Two() {
        }

        static double sf(double x, int n) {
            double p = Two.sfExact(x, n);
            if (p >= 0.0) {
                return p;
            }
            double nxx = (double)n * x * x;
            if (n <= 140) {
                if (nxx < 0.754693) {
                    return 1.0 - Two.durbinMTW(x, n);
                }
                if (nxx < 4.0) {
                    return 1.0 - Two.pomeranz(x, n);
                }
                return 2.0 * One.sf(x, n);
            }
            if (nxx >= 2.2) {
                return 2.0 * One.sf(x, n);
            }
            if (n <= 100000 && (double)n * Math.pow(x, 1.5) < 1.4) {
                return 1.0 - Two.durbinMTW(x, n);
            }
            return Two.pelzGood(x, n);
        }

        private static double sfExact(double x, int n) {
            if ((double)n * x * x >= 370.0 || x >= 1.0) {
                return 0.0;
            }
            double nx = x * (double)n;
            if (nx <= 1.0) {
                if (nx <= 0.5) {
                    return 1.0;
                }
                if (n == 1) {
                    return 2.0 - 2.0 * x;
                }
                double f = 2.0 * x - 1.0 / (double)n;
                double logf = Math.log(f);
                if (n <= 170 && (double)n * logf > -708.0) {
                    return 1.0 - Factorial.doubleValue((int)n) * Math.pow(f, n);
                }
                return -Math.expm1(LogFactorial.create().value(n) + (double)n * logf);
            }
            if ((double)(n - 1) <= nx) {
                return 2.0 * Math.pow(1.0 - x, n);
            }
            return -1.0;
        }

        private static double durbinMTW(double x, int n) {
            int k = (int)Math.ceil((double)n * x);
            SquareMatrixSupport.RealSquareMatrix h = Two.createH(x, n).power(n);
            double pFrac = h.get(k - 1, k - 1);
            int scale = h.scale();
            for (int i = 1; i < n; ++i) {
                if (!((pFrac *= (double)i / (double)n) < 3.8725919148493183E-121)) continue;
                pFrac *= 2.5822498780869086E120;
                scale -= 400;
            }
            return KolmogorovSmirnovDistribution.clipProbability(Math.scalb(pFrac, scale));
        }

        private static SquareMatrixSupport.RealSquareMatrix createH(double x, int n) {
            int i;
            int k = (int)Math.ceil((double)n * x);
            double h = (double)k - (double)n * x;
            int m = 2 * k - 1;
            double[] data = new double[m * m];
            for (int i2 = 0; i2 < m; ++i2) {
                int jend = Math.min(m - 1, i2 + 1);
                for (int j = i2 * m; j <= i2 * m + jend; ++j) {
                    data[j] = 1.0;
                }
            }
            double[] hp = new double[m];
            hp[0] = h;
            for (i = 1; i < m; ++i) {
                hp[i] = Math.pow(h, i + 1);
            }
            for (i = 0; i < m; ++i) {
                int n2 = i * m;
                data[n2] = data[n2] - hp[i];
                int n3 = (m - 1) * m + i;
                data[n3] = data[n3] - hp[m - i - 1];
            }
            if (2.0 * h - 1.0 > 0.0) {
                int n4 = (m - 1) * m;
                data[n4] = data[n4] + Math.pow(2.0 * h - 1.0, m);
            }
            for (i = 0; i < m; ++i) {
                int im = i * m;
                for (int j = 0; j < i + 1; ++j) {
                    int n5 = im + j;
                    data[n5] = data[n5] / Factorial.doubleValue((int)(i - j + 1));
                }
            }
            return SquareMatrixSupport.create(m, data);
        }

        private static double pomeranz(double x, int n) {
            double t = (double)n * x;
            int[] amt = new int[2 * n + 3];
            int[] apt = new int[2 * n + 3];
            Two.computeA(n, t, amt, apt);
            int n2 = n + 2;
            double[][] ap = new double[3][n2];
            double a2 = Math.min(t - Math.floor(t), Math.ceil(t) - t);
            Two.computeAP(ap[0], a2 / (double)n);
            Two.computeAP(ap[1], (1.0 - 2.0 * a2) / (double)n);
            Two.computeAP(ap[2], 2.0 * a2 / (double)n);
            double[] vc = new double[n2];
            double[] vp = new double[n2];
            int scale = 0;
            vc[1] = 1.0;
            for (int i = 2; i <= 2 * n + 2; ++i) {
                int j;
                double[] v = vc;
                vc = vp;
                vp = v;
                Arrays.fill(vc, 0.0);
                double[] p = i == 2 || i == 2 * n + 2 ? ap[0] : ap[2 - (i & 1)];
                int jmin = Math.max(1, amt[i] + 2);
                int jmax = Math.min(n + 1, apt[i]);
                int k1 = Math.max(1, amt[i - 1] + 2);
                double max = 0.0;
                for (j = jmin; j <= jmax; ++j) {
                    int k2 = Math.min(j, apt[i - 1]);
                    double sum = 0.0;
                    for (int k = k1; k <= k2; ++k) {
                        sum += vp[k] * p[j - k];
                    }
                    vc[j] = sum;
                    if (!(max < sum)) continue;
                    max = sum;
                }
                if (!(max < 2.938735877055719E-39)) continue;
                j = jmin;
                while (j <= jmax) {
                    int n3 = j++;
                    vc[n3] = vc[n3] * 3.402823669209385E38;
                }
                scale -= 128;
            }
            double v = vc[n + 1];
            return Math.scalb(v *= Factorial.doubleValue((int)n), scale);
        }

        private static void computeAP(double[] p, double z) {
            p[0] = 1.0;
            p[1] = z;
            for (int j = 2; j < p.length; ++j) {
                p[j] = Math.pow(z, j) / Factorial.doubleValue((int)j);
            }
        }

        static void computeA(int n, double t, int[] amt, int[] apt) {
            int l = (int)Math.floor(t);
            double f = t - (double)l;
            int limit = 2 * n + 2;
            if (f > 0.5) {
                int i;
                int j;
                for (j = 2; j <= limit; j += 2) {
                    i = j >>> 1;
                    amt[j] = i - 2 - l;
                    apt[j] = i + l;
                }
                for (j = 1; j <= limit; j += 2) {
                    i = j >>> 1;
                    amt[j] = i - 1 - l;
                    apt[j] = i + 1 + l;
                }
            } else if (f > 0.0) {
                amt[1] = -l - 1;
                apt[1] = l + 1;
                for (int j = 2; j <= limit; ++j) {
                    int i = j >>> 1;
                    amt[j] = i - 1 - l;
                    apt[j] = i + l;
                }
            } else {
                int i;
                int j;
                for (j = 2; j <= limit; j += 2) {
                    i = j >>> 1;
                    amt[j] = i - 1 - l;
                    apt[j] = i - 1 + l;
                }
                for (j = 1; j <= limit; j += 2) {
                    i = j >>> 1;
                    amt[j] = i - l;
                    apt[j] = i + l;
                }
            }
        }

        static double pelzGood(double x, int n) {
            int max;
            double z2 = x * x * (double)n;
            double lne = -9.869604401089358 / (8.0 * z2);
            if (lne < -55.451774444795625) {
                return 1.0;
            }
            double k0 = 0.0;
            double k1 = 0.0;
            double k2 = 0.0;
            double k3 = 0.0;
            double rootN = Math.sqrt(n);
            double z = x * rootN;
            double z3 = z * z2;
            double z4 = z2 * z2;
            double z6 = Math.pow(z2, 3.0);
            double z7 = Math.pow(z2, 3.5);
            double z8 = Math.pow(z2, 4.0);
            double z10 = Math.pow(z2, 5.0);
            double a1 = 2.4674011002723395;
            double a2 = 6.0 * z6 + 2.0 * z4;
            double b2 = Math.PI * Math.PI * (2.0 * z4 - 5.0 * z2) / 4.0;
            double c2 = 97.40909103400244 * (1.0 - 2.0 * z2) / 16.0;
            double a3 = 961.3891935753045 * (5.0 - 30.0 * z2) / 64.0;
            double b3 = 97.40909103400244 * (-60.0 * z2 + 212.0 * z4) / 16.0;
            double c3 = Math.PI * Math.PI * (135.0 * z4 - 96.0 * z6) / 4.0;
            double d3 = -(30.0 * z6 + 90.0 * z8);
            for (int k = max = (int)Math.ceil((1.0 + Math.sqrt(1.0 - -288.3492271129372 * z2 / (Math.PI * Math.PI))) / 2.0); k > 0; --k) {
                int j = 2 * k - 1;
                double j2 = (double)j * (double)j;
                double j4 = Math.pow(j, 4.0);
                double j6 = Math.pow(j, 6.0);
                double e = Math.exp(lne * j2);
                k0 += e;
                k1 += (2.4674011002723395 * j2 - z2) * e;
                k2 += (a2 + b2 * j2 + c2 * j4) * e;
                k3 += (a3 * j6 + b3 * j4 + c3 * j2 + d3) * e;
            }
            k0 *= 2.5066282746310007 / z;
            k1 *= 1.2533141373155003 / (3.0 * z4);
            k2 *= 1.2533141373155003 / (36.0 * z7);
            k3 *= 1.2533141373155003 / (3240.0 * z10);
            double k2b = 0.0;
            double k3b = 0.0;
            lne *= 4.0;
            double a3b = 29.608813203268074 * z2;
            for (int j = max; j > 0; --j) {
                double j2 = (double)j * (double)j;
                double j4 = Math.pow(j, 4.0);
                double e = Math.exp(lne * j2);
                k2b += Math.PI * Math.PI * j2 * e;
                k3b += (-97.40909103400244 * j4 + a3b * j2) * e;
            }
            k2b *= 1.2533141373155003 / (18.0 * z3);
            k3b *= 1.2533141373155003 / (108.0 * z6);
            return KolmogorovSmirnovDistribution.clipProbability(Sum.of((double[])new double[]{1.0, -k0, -(k1 /= rootN), -(k2 /= (double)n), -(k3 /= (double)n * rootN), k2b /= (double)n, -(k3b /= (double)n * rootN)}).getAsDouble());
        }
    }
}

