/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.statistics.distribution.NormalDistribution;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.ContinuityCorrection;
import org.apache.commons.statistics.inference.PValueMethod;
import org.apache.commons.statistics.inference.WilcoxonSignedRankTest;
import org.apache.commons.statistics.ranking.NaNStrategy;
import org.apache.commons.statistics.ranking.NaturalRanking;
import org.apache.commons.statistics.ranking.RankingAlgorithm;
import org.apache.commons.statistics.ranking.TiesStrategy;

public final class MannWhitneyUTest {
    private static final int AUTO_LIMIT = 50;
    private static final RankingAlgorithm RANKING = new NaturalRanking(NaNStrategy.FAILED, TiesStrategy.AVERAGE);
    private static final double UNSET = -1.0;
    private static final Object LOCK = new Object();
    private static SoftReference<double[][][]> cacheF = new SoftReference<Object>(null);
    private static final MannWhitneyUTest DEFAULT = new MannWhitneyUTest(AlternativeHypothesis.TWO_SIDED, PValueMethod.AUTO, true, 0.0);
    private final AlternativeHypothesis alternative;
    private final PValueMethod pValueMethod;
    private final boolean continuityCorrection;
    private final double mu;

    private MannWhitneyUTest(AlternativeHypothesis alternative, PValueMethod method, boolean continuityCorrection, double mu) {
        this.alternative = alternative;
        this.pValueMethod = method;
        this.continuityCorrection = continuityCorrection;
        this.mu = mu;
    }

    public static MannWhitneyUTest withDefaults() {
        return DEFAULT;
    }

    public MannWhitneyUTest with(AlternativeHypothesis v) {
        return new MannWhitneyUTest(Objects.requireNonNull(v), this.pValueMethod, this.continuityCorrection, this.mu);
    }

    public MannWhitneyUTest with(PValueMethod v) {
        return new MannWhitneyUTest(this.alternative, Arguments.checkOption(v, EnumSet.of(PValueMethod.AUTO, PValueMethod.EXACT, PValueMethod.ASYMPTOTIC)), this.continuityCorrection, this.mu);
    }

    public MannWhitneyUTest with(ContinuityCorrection v) {
        return new MannWhitneyUTest(this.alternative, this.pValueMethod, Objects.requireNonNull(v) == ContinuityCorrection.ENABLED, this.mu);
    }

    public MannWhitneyUTest withMu(double v) {
        return new MannWhitneyUTest(this.alternative, this.pValueMethod, this.continuityCorrection, Arguments.checkFinite(v));
    }

    public double statistic(double[] x, double[] y) {
        MannWhitneyUTest.checkSamples(x, y);
        double[] z = MannWhitneyUTest.concatenateSamples(this.mu, x, y);
        double[] ranks = RANKING.apply(z);
        double sumRankX = Arrays.stream(ranks).limit(x.length).sum();
        return sumRankX - (double)((long)x.length * (long)(x.length + 1)) * 0.5;
    }

    public Result test(double[] x, double[] y) {
        double p;
        MannWhitneyUTest.checkSamples(x, y);
        double[] z = MannWhitneyUTest.concatenateSamples(this.mu, x, y);
        double[] ranks = RANKING.apply(z);
        double sumRankX = Arrays.stream(ranks).limit(x.length).sum();
        double u1 = sumRankX - (double)((long)x.length * (long)(x.length + 1)) * 0.5;
        double c = WilcoxonSignedRankTest.calculateTieCorrection(ranks);
        boolean tiedValues = c != 0.0;
        PValueMethod method = this.pValueMethod;
        int n = x.length;
        int m = y.length;
        if (method == PValueMethod.AUTO && Math.max(n, m) < 50) {
            method = PValueMethod.EXACT;
        }
        double d = p = method == PValueMethod.EXACT && !tiedValues ? MannWhitneyUTest.calculateExactPValue(u1, n, m, this.alternative) : -1.0;
        if (p < 0.0) {
            p = this.calculateAsymptoticPValue(u1, n, m, c);
        }
        return new Result(u1, tiedValues, p);
    }

    private static void checkSamples(double[] x, double[] y) {
        Arguments.checkValuesRequiredSize(x.length, 1);
        Arguments.checkValuesRequiredSize(y.length, 1);
    }

    private static double[] concatenateSamples(double mu, double[] x, double[] y) {
        double[] z = new double[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        if (mu != 0.0) {
            int i = 0;
            while (i < x.length) {
                int n = i++;
                z[n] = z[n] - mu;
            }
        }
        return z;
    }

    private double calculateAsymptoticPValue(double u, int n1, int n2, double c) {
        long n1n2 = (long)n1 * (long)n2;
        long n = (long)n1 + (long)n2;
        double e = (double)n1n2 * 0.5;
        double variance = (double)n1n2 / 12.0 * ((double)n + 1.0 - c / (double)n / (double)(n - 1L));
        double z = u - e;
        if (this.continuityCorrection) {
            z = this.alternative == AlternativeHypothesis.GREATER_THAN ? (z -= 0.5) : (this.alternative == AlternativeHypothesis.LESS_THAN ? (z += 0.5) : (z -= Math.signum(z) * 0.5));
        }
        z /= Math.sqrt(variance);
        NormalDistribution standardNormal = NormalDistribution.of((double)0.0, (double)1.0);
        if (this.alternative == AlternativeHypothesis.GREATER_THAN) {
            return standardNormal.survivalProbability(z);
        }
        if (this.alternative == AlternativeHypothesis.LESS_THAN) {
            return standardNormal.cumulativeProbability(z);
        }
        return 2.0 * standardNormal.survivalProbability(Math.abs(z));
    }

    static double calculateExactPValue(double u, int m, int n, AlternativeHypothesis alternative) {
        if ((double)((int)u) != u) {
            return -1.0;
        }
        double binom = BinomialCoefficientDouble.value((int)(n + m), (int)m);
        if (binom == Double.POSITIVE_INFINITY) {
            return -1.0;
        }
        int u1 = (int)u;
        int u2 = (int)((long)m * (long)n - (long)u1);
        int n1 = Math.min(m, n);
        int n2 = Math.max(m, n);
        if (alternative == AlternativeHypothesis.GREATER_THAN) {
            return MannWhitneyUTest.sf(u1 - 1, u2 + 1, n1, n2, binom);
        }
        if (alternative == AlternativeHypothesis.LESS_THAN) {
            return MannWhitneyUTest.cdf(u1, u2, n1, n2, binom);
        }
        double p = 2.0 * MannWhitneyUTest.computeCdf(Math.min(u1, u2), n1, n2, binom);
        return Math.min(1.0, p);
    }

    private static double cdf(int u1, int u2, int m, int n, double binom) {
        return u2 > u1 ? MannWhitneyUTest.computeCdf(u1, m, n, binom) : 1.0 - MannWhitneyUTest.computeCdf(u2 - 1, m, n, binom);
    }

    private static double sf(int u1, int u2, int m, int n, double binom) {
        return u2 > u1 ? 1.0 - MannWhitneyUTest.computeCdf(u1, m, n, binom) : MannWhitneyUTest.computeCdf(u2 - 1, m, n, binom);
    }

    private static double computeCdf(int k, int m, int n, double binom) {
        if (k < 0) {
            return 0.0;
        }
        double[][][] f = MannWhitneyUTest.getF(m, n, k);
        return IntStream.rangeClosed(0, k).mapToDouble(i -> MannWhitneyUTest.fmnk(f, m, n, i)).sum() / binom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[][][] getF(int m, int n, int k) {
        Object object = LOCK;
        synchronized (object) {
            boolean growK;
            double[][][] f = cacheF.get();
            if (f == null) {
                double[][][] dArray = f = new double[m + 1][n + 1][k + 1];
                int n2 = dArray.length;
                for (int i = 0; i < n2; ++i) {
                    double[][] a;
                    for (double[] b : a = dArray[i]) {
                        MannWhitneyUTest.initialize(b);
                    }
                }
                cacheF = new SoftReference<double[][][]>(f);
                return f;
            }
            int m1 = f.length;
            int n1 = f[0].length;
            int k1 = f[0][0].length;
            boolean growM = m1 - m < 1;
            boolean growN = n1 - n < 1;
            boolean bl = growK = k1 - k < 1;
            if (growM | growN | growK) {
                int x;
                int sn = Math.max(n1, n + 1);
                int sk = Math.max(k1, k + 1);
                if (growM) {
                    f = (double[][][])Arrays.copyOf(f, m + 1);
                    for (x = m1; x <= m; ++x) {
                        f[x] = new double[sn][sk];
                        for (double[] b : f[x]) {
                            MannWhitneyUTest.initialize(b);
                        }
                    }
                }
                if (growN) {
                    for (x = 0; x < m1; ++x) {
                        f[x] = (double[][])Arrays.copyOf(f[x], sn);
                        for (int y = n1; y < sn; ++y) {
                            double[] dArray = new double[sk];
                            f[x][y] = dArray;
                            double[] b = dArray;
                            MannWhitneyUTest.initialize(b);
                        }
                    }
                }
                if (growK) {
                    for (x = 0; x < m1; ++x) {
                        for (int y = 0; y < n1; ++y) {
                            double[] dArray = Arrays.copyOf(f[x][y], sk);
                            f[x][y] = dArray;
                            double[] b = dArray;
                            for (int z = k1; z < sk; ++z) {
                                b[z] = -1.0;
                            }
                        }
                    }
                }
                cacheF = new SoftReference<double[][][]>(f);
            }
            return f;
        }
    }

    private static void initialize(double[] fmn) {
        Arrays.fill(fmn, -1.0);
        fmn[0] = 1.0;
    }

    private static double fmnk(double[][][] f, int m, int n, int k) {
        if ((k | m | n) < 0) {
            return 0.0;
        }
        double fmnk = f[m][n][k];
        if (fmnk < 0.0) {
            f[m][n][k] = fmnk = MannWhitneyUTest.fmnk(f, m - 1, n, k - n) + MannWhitneyUTest.fmnk(f, m, n - 1, k);
        }
        return fmnk;
    }

    public static final class Result
    extends BaseSignificanceResult {
        private final boolean tiedValues;

        Result(double statistic, boolean tiedValues, double p) {
            super(statistic, p);
            this.tiedValues = tiedValues;
        }

        @Override
        public double getStatistic() {
            return super.getStatistic();
        }

        public boolean hasTiedValues() {
            return this.tiedValues;
        }
    }
}

