/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.IntVariance;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.UInt128;
import org.apache.commons.statistics.descriptive.UInt96;

public final class IntStandardDeviation
implements IntStatistic,
StatisticAccumulator<IntStandardDeviation> {
    private final UInt128 sumSq;
    private final Int128 sum;
    private long n;
    private boolean biased;

    private IntStandardDeviation() {
        this(UInt128.create(), Int128.create(), 0);
    }

    private IntStandardDeviation(UInt128 sumSq, Int128 sum, int n) {
        this.sumSq = sumSq;
        this.sum = sum;
        this.n = n;
    }

    public static IntStandardDeviation create() {
        return new IntStandardDeviation();
    }

    public static IntStandardDeviation of(int ... values) {
        if (values.length < 10) {
            IntStandardDeviation stat = new IntStandardDeviation();
            for (int x : values) {
                stat.accept(x);
            }
            return stat;
        }
        long s = 0L;
        UInt96 ss = UInt96.create();
        int end = values.length & 0xFFFFFFFE;
        for (int i = 0; i < end; i += 2) {
            long x = values[i];
            long y = values[i + 1];
            s += x + y;
            ss.addPositive(x * x + y * y);
        }
        if (end < values.length) {
            long x = values[end];
            s += x;
            ss.addPositive(x * x);
        }
        return new IntStandardDeviation(UInt128.of(ss), Int128.of(s), values.length);
    }

    @Override
    public void accept(int value) {
        this.sumSq.addPositive((long)value * (long)value);
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return IntVariance.computeVarianceOrStd(this.sumSq, this.sum, this.n, this.biased, true);
    }

    @Override
    public IntStandardDeviation combine(IntStandardDeviation other) {
        this.sumSq.add(other.sumSq);
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }

    public IntStandardDeviation setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

