/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.IntVariance;
import org.apache.commons.statistics.descriptive.LongVariance;
import org.apache.commons.statistics.descriptive.SumOfCubedDeviations;

class SumOfFourthDeviations
extends SumOfCubedDeviations {
    private double sumFourthDev;

    SumOfFourthDeviations() {
    }

    private SumOfFourthDeviations(double sq, SumOfCubedDeviations sc) {
        super(sc);
        this.sumFourthDev = sq;
    }

    private SumOfFourthDeviations(double sq, double sc, double ss, double m1, long n) {
        super(sc, ss, m1, n);
        this.sumFourthDev = sq;
    }

    static SumOfFourthDeviations of(double ... values) {
        if (values.length == 0) {
            return new SumOfFourthDeviations();
        }
        return SumOfFourthDeviations.create(SumOfCubedDeviations.of(values), values);
    }

    static SumOfFourthDeviations create(Sum sum, double[] values) {
        if (values.length == 0) {
            return new SumOfFourthDeviations();
        }
        return SumOfFourthDeviations.create(SumOfCubedDeviations.create(sum, values), values);
    }

    private static SumOfFourthDeviations create(SumOfCubedDeviations sc, double[] values) {
        double xbar = sc.getFirstMoment();
        if (!(Double.isFinite(xbar) && Double.isFinite(sc.sumSquaredDev) && Double.isFinite(sc.sumCubedDev))) {
            return new SumOfFourthDeviations(Double.NaN, sc);
        }
        double s = 0.0;
        for (double x : values) {
            s += SumOfFourthDeviations.pow4(x - xbar);
        }
        return new SumOfFourthDeviations(s, sc);
    }

    private static double pow4(double x) {
        double x2 = x * x;
        return x2 * x2;
    }

    static SumOfFourthDeviations of(int ... values) {
        if (values.length == 0) {
            return new SumOfFourthDeviations();
        }
        IntVariance variance = IntVariance.of(values);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        double sq = 0.0;
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double y = nArray[i];
            double x = y - xbar;
            double x2 = x * x;
            sc += x2 * x;
            sq += x2 * x2;
        }
        if (values.length <= 2) {
            sc = 0.0;
        }
        return new SumOfFourthDeviations(sq, sc, ss, xbar, values.length);
    }

    static SumOfFourthDeviations of(long ... values) {
        if (values.length == 0) {
            return new SumOfFourthDeviations();
        }
        LongVariance variance = LongVariance.of(values);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        double sq = 0.0;
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double y = lArray[i];
            double x = y - xbar;
            double x2 = x * x;
            sc += x2 * x;
            sq += x2 * x2;
        }
        if (values.length <= 2) {
            sc = 0.0;
        }
        return new SumOfFourthDeviations(sq, sc, ss, xbar, values.length);
    }

    @Override
    public void accept(double value) {
        double ss = this.sumSquaredDev;
        double sc = this.sumCubedDev;
        double np = this.n;
        super.accept(value);
        double np1 = this.n;
        this.sumFourthDev = this.sumFourthDev - sc * this.nDev * 8.0 + ss * this.nDev * this.nDev * 24.0 + np * (np1 * np1 - 3.0 * np) * this.nDev * this.nDev * this.nDev * this.dev * 16.0;
    }

    double getSumOfFourthDeviations() {
        return Double.isFinite(this.getFirstMoment()) ? this.sumFourthDev : Double.NaN;
    }

    SumOfFourthDeviations combine(SumOfFourthDeviations other) {
        if (this.n == 0L) {
            this.sumFourthDev = other.sumFourthDev;
        } else if (other.n != 0L) {
            double halfDiffOfMean = this.getFirstMomentHalfDifference(other);
            this.sumFourthDev += other.sumFourthDev;
            if (halfDiffOfMean != 0.0) {
                double n1 = this.n;
                double n2 = other.n;
                if (n1 == n2) {
                    this.sumFourthDev += (this.sumCubedDev - other.sumCubedDev) * halfDiffOfMean * 4.0 + (this.sumSquaredDev + other.sumSquaredDev) * (halfDiffOfMean * halfDiffOfMean) * 6.0 + SumOfFourthDeviations.pow4(halfDiffOfMean) * n1 * 2.0;
                } else {
                    double n1n2 = n1 + n2;
                    double dm = 2.0 * (halfDiffOfMean / n1n2);
                    this.sumFourthDev += (this.sumCubedDev * n2 - other.sumCubedDev * n1) * dm * 4.0 + (n2 * n2 * this.sumSquaredDev + n1 * n1 * other.sumSquaredDev) * (dm * dm) * 6.0 + n1 * n2 * (n1n2 * n1n2 - 3.0 * (n1 * n2)) * SumOfFourthDeviations.pow4(dm) * n1n2;
                }
            }
        }
        super.combine(other);
        return this;
    }
}

