/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.text.beta.StrBuilder;
import org.junit.Assert;
import org.junit.Test;

public class StrBuilderAppendInsertTest {
    private static final String SEP = System.lineSeparator();
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    @Test
    public void testAppendNewLine() {
        StrBuilder sb = new StrBuilder("---");
        sb.appendNewLine().append("+++");
        Assert.assertEquals((Object)("---" + SEP + "+++"), (Object)sb.toString());
        sb = new StrBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        Assert.assertEquals((Object)("---#" + SEP), (Object)sb.toString());
    }

    @Test
    public void testAppendWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.appendNull();
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb.append(null);
        Assert.assertEquals((Object)"NULLNULL", (Object)sb.toString());
        sb.append(FOO);
        Assert.assertEquals((Object)"NULLNULLfoo", (Object)sb.toString());
        sb.append((String)null);
        Assert.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("");
        Assert.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("bar");
        Assert.assertEquals((Object)"NULLNULLfooNULLbar", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assert.assertEquals((Object)"NULLNULLfooNULLbarNULL", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assert.assertEquals((Object)"NULLNULLfooNULLbarNULLbaz", (Object)sb.toString());
    }

    @Test
    public void testAppend_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendNull();
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append(null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append(FOO);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assert.assertEquals((Object)"foobaz", (Object)sb.toString());
        sb.append(new StrBuilder("yes"));
        Assert.assertEquals((Object)"foobazyes", (Object)sb.toString());
        sb.append((CharSequence)"Seq");
        Assert.assertEquals((Object)"foobazyesSeq", (Object)sb.toString());
        sb.append(new StringBuilder("bld"));
        Assert.assertEquals((Object)"foobazyesSeqbld", (Object)sb.toString());
    }

    @Test
    public void testAppend_StringBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder(""));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("bar"));
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_String() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("bar");
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_String_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("foo", 0, 3);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        try {
            sb.append("bar", -1, 1);
            Assert.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 3, 1);
            Assert.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, -1);
            Assert.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, 3);
            Assert.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", -1, 3);
            Assert.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 4, 0);
            Assert.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("bar", 3, 0);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("abcbardef", 3, 3);
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append((CharSequence)"abcbardef", 4, 3);
        Assert.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    public void testAppend_StringBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"), 0, 3);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        try {
            sb.append(new StringBuilder("bar"), -1, 1);
            Assert.fail((String)"append(StringBuilder, -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 3, 1);
            Assert.fail((String)"append(StringBuilder, 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, -1);
            Assert.fail((String)"append(StringBuilder,, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, 3);
            Assert.fail((String)"append(StringBuilder, 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), -1, 3);
            Assert.fail((String)"append(StringBuilder, -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 4, 0);
            Assert.fail((String)"append(StringBuilder, 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuilder("bar"), 3, 0);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 3, 3);
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 4, 3);
        Assert.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    public void testAppend_StringBuffer() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer(""));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("bar"));
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_StringBuffer_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null, 0, 1);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        try {
            sb.append(new StringBuffer("bar"), -1, 1);
            Assert.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 3, 1);
            Assert.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, -1);
            Assert.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, 3);
            Assert.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), -1, 3);
            Assert.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 4, 0);
            Assert.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuffer("bar"), 3, 0);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_StrBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder(""));
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder("bar"));
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_StrBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null, 0, 1);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"), 0, 3);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        try {
            sb.append(new StrBuilder("bar"), -1, 1);
            Assert.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 3, 1);
            Assert.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, -1);
            Assert.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, 3);
            Assert.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), -1, 3);
            Assert.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 4, 0);
            Assert.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StrBuilder("bar"), 3, 0);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder("abcbardef"), 3, 3);
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_CharArray() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[0]);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append(new char[]{'f', 'o', 'o'});
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
    }

    @Test
    public void testAppend_CharArray_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null, 0, 1);
        Assert.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 1);
            Assert.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 3, 1);
            Assert.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, -1);
            Assert.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, 3);
            Assert.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 3);
            Assert.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 4, 0);
            Assert.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        Assert.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    public void testAppend_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.append(true);
        Assert.assertEquals((Object)"true", (Object)sb.toString());
        sb.append(false);
        Assert.assertEquals((Object)"truefalse", (Object)sb.toString());
        sb.append('!');
        Assert.assertEquals((Object)"truefalse!", (Object)sb.toString());
    }

    @Test
    public void testAppend_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.append(0);
        Assert.assertEquals((Object)"0", (Object)sb.toString());
        sb.append(1L);
        Assert.assertEquals((Object)"01", (Object)sb.toString());
        sb.append(2.3f);
        Assert.assertEquals((Object)"012.3", (Object)sb.toString());
        sb.append(4.5);
        Assert.assertEquals((Object)"012.34.5", (Object)sb.toString());
    }

    @Test
    public void testAppendln_FormattedString() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("Hello %s", new Object[]{"Alice"});
        Assert.assertEquals((Object)("Hello Alice" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)2L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(null);
        Assert.assertEquals((Object)("" + SEP), (Object)sb.toString());
        sb.appendln(FOO);
        Assert.assertEquals((Object)(SEP + "foo" + SEP), (Object)sb.toString());
        sb.appendln((Object)6);
        Assert.assertEquals((Object)(SEP + "foo" + SEP + "6" + SEP), (Object)sb.toString());
    }

    @Test
    public void testAppendln_String() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo");
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)2L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_String_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo", 0, 3);
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StringBuffer() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuffer str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"));
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StringBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"));
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StringBuffer_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuffer str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"), 0, 3);
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StringBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"), 0, 3);
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StrBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StrBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"));
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_StrBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StrBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"), 0, 3);
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_CharArray() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(char[] str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray());
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_CharArray_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(char[] str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray(), 0, 3);
        Assert.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)count[0]);
        Assert.assertEquals((long)1L, (long)count[1]);
    }

    @Test
    public void testAppendln_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(true);
        Assert.assertEquals((Object)("true" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(false);
        Assert.assertEquals((Object)("false" + SEP), (Object)sb.toString());
    }

    @Test
    public void testAppendln_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(0);
        Assert.assertEquals((Object)("0" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(1L);
        Assert.assertEquals((Object)("1" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(2.3f);
        Assert.assertEquals((Object)("2.3" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(4.5);
        Assert.assertEquals((Object)("4.5" + SEP), (Object)sb.toString());
    }

    @Test
    public void testAppendPadding() {
        StrBuilder sb = new StrBuilder();
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(-1, '-');
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(0, '-');
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(1, '-');
        Assert.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.appendPadding(16, '-');
        Assert.assertEquals((long)20L, (long)sb.length());
        Assert.assertEquals((Object)"foo-----------------", (Object)sb.toString());
    }

    @Test
    public void testAppendFixedWidthPadLeft() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        Assert.assertEquals((Object)"o", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        Assert.assertEquals((Object)"oo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        Assert.assertEquals((Object)"-foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        Assert.assertEquals((long)10L, (long)sb.length());
        Assert.assertEquals((Object)"-------foo", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        Assert.assertEquals((Object)"-null", (Object)sb.toString());
    }

    @Test
    public void testAppendFixedWidthPadLeft_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        Assert.assertEquals((Object)"3", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        Assert.assertEquals((Object)"23", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        Assert.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        Assert.assertEquals((Object)"-123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        Assert.assertEquals((long)10L, (long)sb.length());
        Assert.assertEquals((Object)"-------123", (Object)sb.toString());
    }

    @Test
    public void testAppendFixedWidthPadRight() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assert.assertEquals((Object)"f", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        Assert.assertEquals((Object)"fo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        Assert.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        Assert.assertEquals((long)10L, (long)sb.length());
        Assert.assertEquals((Object)"foo-------", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        Assert.assertEquals((Object)"null-", (Object)sb.toString());
    }

    @Test
    public void testLang299() {
        StrBuilder sb = new StrBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assert.assertEquals((Object)"f", (Object)sb.toString());
    }

    @Test
    public void testAppendFixedWidthPadRight_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        Assert.assertEquals((Object)"1", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        Assert.assertEquals((Object)"12", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        Assert.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        Assert.assertEquals((Object)"123-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        Assert.assertEquals((long)10L, (long)sb.length());
        Assert.assertEquals((Object)"123-------", (Object)sb.toString());
    }

    @Test
    public void testAppend_FormattedString() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hi", (Object[])null);
        Assert.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi", new Object[]{"Alice"});
        Assert.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi %s", new Object[]{"Alice"});
        Assert.assertEquals((Object)"Hi Alice", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi %s %,d", new Object[]{"Alice", 5000});
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        String expected = "Hi Alice 5" + groupingSeparator + "000";
        Assert.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    public void testAppendAll_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Object[])null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(new Object[0]);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(new Object[]{"foo", "bar", "baz"});
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    public void testAppendAll_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterable)null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    public void testAppendAll_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterator)null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    public void testAppendWithSeparators_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[0], ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        Assert.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assert.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    public void testAppendWithSeparators_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        Assert.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assert.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    public void testAppendWithSeparators_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        Assert.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        Assert.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    public void testAppendWithSeparatorsWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assert.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assert.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_String() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",");
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_String_String() {
        StrBuilder sb = new StrBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", null);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assert.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, null);
        Assert.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, "order by ");
        Assert.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)"order by foo", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assert.assertEquals((Object)"order by foo,", (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_char() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',');
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_char_char() {
        StrBuilder sb = new StrBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        Assert.assertEquals((Object)String.valueOf(':'), (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)(String.valueOf(':') + "foo"), (Object)sb.toString());
        sb.appendSeparator(',', ':');
        Assert.assertEquals((Object)(String.valueOf(':') + "foo" + ','), (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_String_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",", 0);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",", 1);
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(",", -1);
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    public void testAppendSeparator_char_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',', 0);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assert.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',', 1);
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(',', -1);
        Assert.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    public void testInsert() {
        StrBuilder sb = new StrBuilder();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, FOO);
            Assert.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            Assert.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, null);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, "foo");
            Assert.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            Assert.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, new char[]{'f', 'o', 'o'});
            Assert.fail((String)"insert(-1, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'f', 'o', 'o'});
            Assert.fail((String)"insert(7, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (char[])null);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[0]);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'f', 'o', 'o'});
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            Assert.fail((String)"insert(-1, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            Assert.fail((String)"insert(7, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (char[])null, 0, 0);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[0], 0, 0);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3);
            Assert.fail((String)"insert(0, char[], -1, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3);
            Assert.fail((String)"insert(0, char[], 10, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1);
            Assert.fail((String)"insert(0, char[], 0, -1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10);
            Assert.fail((String)"insert(0, char[], 0, 10) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        Assert.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, true);
            Assert.fail((String)"insert(-1, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, true);
            Assert.fail((String)"insert(7, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, true);
        Assert.assertEquals((Object)"truebarbaz", (Object)sb.toString());
        sb.insert(0, false);
        Assert.assertEquals((Object)"falsetruebarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, '!');
            Assert.fail((String)"insert(-1, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, '!');
            Assert.fail((String)"insert(7, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, '!');
        Assert.assertEquals((Object)"!barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, 0);
            Assert.fail((String)"insert(-1, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 0);
            Assert.fail((String)"insert(7, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, '0');
        Assert.assertEquals((Object)"0barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, 1L);
            Assert.fail((String)"insert(-1, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 1L);
            Assert.fail((String)"insert(7, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 1L);
        Assert.assertEquals((Object)"1barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, 2.3f);
            Assert.fail((String)"insert(-1, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 2.3f);
            Assert.fail((String)"insert(7, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 2.3f);
        Assert.assertEquals((Object)"2.3barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, 4.5);
            Assert.fail((String)"insert(-1, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 4.5);
            Assert.fail((String)"insert(7, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 4.5);
        Assert.assertEquals((Object)"4.5barbaz", (Object)sb.toString());
    }

    @Test
    public void testInsertWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, FOO);
            Assert.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            Assert.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, null);
        Assert.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assert.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)sb.toString());
        try {
            sb.insert(-1, "foo");
            Assert.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            Assert.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        Assert.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assert.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.insert(0, (char[])null);
        Assert.assertEquals((Object)"nullfoonullbarbaz", (Object)sb.toString());
        sb.insert(0, (char[])null, 0, 0);
        Assert.assertEquals((Object)"nullnullfoonullbarbaz", (Object)sb.toString());
    }
}

