/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.text.beta.similarity.CosineDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CosineDistanceTest {
    private static CosineDistance cosineDistance;

    @BeforeClass
    public static void setUp() {
        cosineDistance = new CosineDistance();
    }

    @Test
    public void testCosineDistance() {
        Assert.assertEquals((Object)0.5, (Object)this.roundValue(cosineDistance.apply((CharSequence)"the house", (CharSequence)"da house")));
        Assert.assertEquals((Object)0.0, (Object)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"AB")));
        Assert.assertEquals((Object)1.0, (Object)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"BA")));
        Assert.assertEquals((Object)0.08, (Object)this.roundValue(cosineDistance.apply((CharSequence)"the boy was from tamana shi, kumamoto ken, and the girl was from rio de janeiro, rio", (CharSequence)"the boy was from tamana shi, kumamoto, and the boy was from rio de janeiro, rio de janeiro")));
    }

    private Double roundValue(Double value) {
        return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }
}

