/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import java.util.Locale;
import org.apache.commons.text.beta.similarity.FuzzyScore;
import org.junit.Assert;
import org.junit.Test;

public class FuzzyScoreTest {
    private static final FuzzyScore ENGLISH_SCORE = new FuzzyScore(Locale.ENGLISH);

    @Test
    public void testGetFuzzyScore() throws Exception {
        Assert.assertEquals((long)0L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"", (CharSequence)"").intValue());
        Assert.assertEquals((long)0L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"b").intValue());
        Assert.assertEquals((long)1L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Room", (CharSequence)"o").intValue());
        Assert.assertEquals((long)1L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"w").intValue());
        Assert.assertEquals((long)2L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"ws").intValue());
        Assert.assertEquals((long)4L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"wo").intValue());
        Assert.assertEquals((long)3L, (long)ENGLISH_SCORE.fuzzyScore((CharSequence)"Apache Software Foundation", (CharSequence)"asf").intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFuzzyScore_StringNullLocale() throws Exception {
        ENGLISH_SCORE.fuzzyScore((CharSequence)"not null", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFuzzyScore_NullStringLocale() throws Exception {
        ENGLISH_SCORE.fuzzyScore(null, (CharSequence)"not null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFuzzyScore_NullNullLocale() throws Exception {
        ENGLISH_SCORE.fuzzyScore(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingLocale() throws Exception {
        new FuzzyScore((Locale)null);
    }
}

