/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import org.apache.commons.text.beta.similarity.HammingDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HammingDistanceTest {
    private static HammingDistance distance;

    @BeforeClass
    public static void setUp() {
        distance = new HammingDistance();
    }

    @Test
    public void testHammingDistance() {
        Assert.assertEquals((Object)0, (Object)distance.apply((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((Object)0, (Object)distance.apply((CharSequence)"pappa", (CharSequence)"pappa"));
        Assert.assertEquals((Object)1, (Object)distance.apply((CharSequence)"papaa", (CharSequence)"pappa"));
        Assert.assertEquals((Object)3, (Object)distance.apply((CharSequence)"karolin", (CharSequence)"kathrin"));
        Assert.assertEquals((Object)3, (Object)distance.apply((CharSequence)"karolin", (CharSequence)"kerstin"));
        Assert.assertEquals((Object)2, (Object)distance.apply((CharSequence)"1011101", (CharSequence)"1001001"));
        Assert.assertEquals((Object)3, (Object)distance.apply((CharSequence)"2173896", (CharSequence)"2233796"));
        Assert.assertEquals((Object)2, (Object)distance.apply((CharSequence)"ATCG", (CharSequence)"ACCC"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHammingDistance_nullLeftValue() {
        distance.apply(null, (CharSequence)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHammingDistance_nullRightValue() {
        distance.apply((CharSequence)"", null);
    }
}

