/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import org.apache.commons.text.beta.similarity.JaroWinklerDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaroWinklerDistanceTest {
    private static JaroWinklerDistance distance;

    @BeforeClass
    public static void setUp() {
        distance = new JaroWinklerDistance();
    }

    @Test
    public void testGetJaroWinklerDistance_StringString() {
        Assert.assertEquals((double)0.93, (double)distance.apply((CharSequence)"frog", (CharSequence)"fog"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)distance.apply((CharSequence)"fly", (CharSequence)"ant"), (double)0.0);
        Assert.assertEquals((double)0.44, (double)distance.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)0.0);
        Assert.assertEquals((double)0.93, (double)distance.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)0.0);
        Assert.assertEquals((double)0.95, (double)distance.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)0.0);
        Assert.assertEquals((double)0.92, (double)distance.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)0.0);
        Assert.assertEquals((double)0.88, (double)distance.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullNull() throws Exception {
        distance.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_StringNull() throws Exception {
        distance.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullString() throws Exception {
        distance.apply(null, (CharSequence)"clear");
    }
}

