/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import org.apache.commons.text.beta.similarity.LevenshteinDistance;
import org.junit.Assert;
import org.junit.Test;

public class LevenshteinDistanceTest {
    private static final LevenshteinDistance UNLIMITED_DISTANCE = new LevenshteinDistance();

    @Test
    public void testGetLevenshteinDistance_StringString() {
        Assert.assertEquals((long)0L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"").intValue());
        Assert.assertEquals((long)1L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"a").intValue());
        Assert.assertEquals((long)7L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"aaapppp", (CharSequence)"").intValue());
        Assert.assertEquals((long)1L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"frog", (CharSequence)"fog").intValue());
        Assert.assertEquals((long)3L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"fly", (CharSequence)"ant").intValue());
        Assert.assertEquals((long)7L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"elephant", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)7L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"elephant").intValue());
        Assert.assertEquals((long)8L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz").intValue());
        Assert.assertEquals((long)8L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)1L, (long)UNLIMITED_DISTANCE.apply((CharSequence)"hello", (CharSequence)"hallo").intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_NullString() throws Exception {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_StringNull() throws Exception {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test
    public void testGetLevenshteinDistance_StringStringInt() {
        Assert.assertEquals((long)0L, (long)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"", (CharSequence)"").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"b", (CharSequence)"a").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"a", (CharSequence)"b").intValue());
        Assert.assertEquals((long)0L, (long)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"aa", (CharSequence)"aa").intValue());
        Assert.assertEquals((long)0L, (long)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"aa", (CharSequence)"aa").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"aaa", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)3L, (long)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"aaa", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)6L, (long)new LevenshteinDistance(Integer.valueOf(10)).apply((CharSequence)"aaaaaa", (CharSequence)"b").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"b").intValue());
        Assert.assertEquals((long)3L, (long)new LevenshteinDistance(Integer.valueOf(4)).apply((CharSequence)"a", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"b").intValue());
        Assert.assertEquals((long)3L, (long)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"a", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"a", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"bbb", (CharSequence)"a").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"b").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"a", (CharSequence)"bbb").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"bbb", (CharSequence)"a").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"12345", (CharSequence)"1234567").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"1234567", (CharSequence)"12345").intValue());
        Assert.assertEquals((long)1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"frog", (CharSequence)"fog").intValue());
        Assert.assertEquals((long)3L, (long)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"fly", (CharSequence)"ant").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"elephant", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"elephant", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant").intValue());
        Assert.assertEquals((long)-1L, (long)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"hippo", (CharSequence)"elephant").intValue());
        Assert.assertEquals((long)8L, (long)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz").intValue());
        Assert.assertEquals((long)8L, (long)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)1L, (long)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"hello", (CharSequence)"hallo").intValue());
        Assert.assertEquals((long)1L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"frog", (CharSequence)"fog").intValue());
        Assert.assertEquals((long)3L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"fly", (CharSequence)"ant").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"elephant", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)7L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"elephant").intValue());
        Assert.assertEquals((long)8L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz").intValue());
        Assert.assertEquals((long)8L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo").intValue());
        Assert.assertEquals((long)1L, (long)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hello", (CharSequence)"hallo").intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_NullStringInt() throws Exception {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_StringNullInt() throws Exception {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorWithNegativeThreshold() throws Exception {
        new LevenshteinDistance(Integer.valueOf(-1));
    }
}

