/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import java.util.Arrays;
import org.apache.commons.text.beta.similarity.EditDistance;
import org.apache.commons.text.beta.similarity.EditDistanceFrom;
import org.apache.commons.text.beta.similarity.HammingDistance;
import org.apache.commons.text.beta.similarity.LevenshteinDistance;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedEditDistanceFromTest<R> {
    private final EditDistance<R> editDistance;
    private final CharSequence left;
    private final CharSequence right;
    private final R distance;

    public ParameterizedEditDistanceFromTest(EditDistance<R> editDistance, CharSequence left, CharSequence right, R distance) {
        this.editDistance = editDistance;
        this.left = left;
        this.right = right;
        this.distance = distance;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({new HammingDistance(), "Sam I am.", "Ham I am.", 1}, {new HammingDistance(), "Japtheth, Ham, Shem", "Japtheth, HAM, Shem", 2}, {new HammingDistance(), "Hamming", "Hamming", 0}, {new LevenshteinDistance(), "Apache", "a patchy", 4}, {new LevenshteinDistance(), "go", "no go", 3}, {new LevenshteinDistance(), "go", "go", 0}, {new LevenshteinDistance(Integer.valueOf(4)), "Apache", "a patchy", 4}, {new LevenshteinDistance(Integer.valueOf(4)), "go", "no go", 3}, {new LevenshteinDistance(Integer.valueOf(0)), "go", "go", 0}, {new EditDistance<Boolean>(){

            public Boolean apply(CharSequence left, CharSequence right) {
                return left == right || left != null && left.equals(right);
            }
        }, "Bob's your uncle.", "Every good boy does fine.", false});
    }

    @Test
    public void test() {
        EditDistanceFrom editDistanceFrom = new EditDistanceFrom(this.editDistance, this.left);
        Assert.assertThat((Object)editDistanceFrom.apply(this.right), (Matcher)IsEqual.equalTo(this.distance));
    }
}

