/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.similarity;

import org.apache.commons.text.beta.similarity.EditDistance;
import org.apache.commons.text.beta.similarity.EditDistanceFrom;
import org.apache.commons.text.beta.similarity.LevenshteinDistance;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class StringMetricFromTest {
    @Test
    public void testEquivalence() {
        LevenshteinDistance metric = new LevenshteinDistance();
        String left = "Apache";
        String right = "a patchy";
        Integer distance = 4;
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        Assert.assertThat((Object)metricFrom.apply((CharSequence)"a patchy"), (Matcher)IsEqual.equalTo((Object)distance));
        Assert.assertThat((Object)metricFrom.apply((CharSequence)"a patchy"), (Matcher)IsEqual.equalTo((Object)metric.apply((CharSequence)"Apache", (CharSequence)"a patchy")));
    }

    @Test
    public void testJavadocExample() {
        LevenshteinDistance metric = new LevenshteinDistance();
        String target = "Apache";
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        String mostSimilar = null;
        Integer shortestDistance = null;
        for (String test : new String[]{"Appaloosa", "a patchy", "apple"}) {
            Integer distance = (Integer)metricFrom.apply((CharSequence)test);
            if (shortestDistance != null && distance >= shortestDistance) continue;
            shortestDistance = distance;
            mostSimilar = test;
        }
        Assert.assertThat(mostSimilar, (Matcher)IsEqual.equalTo((Object)"a patchy"));
        Assert.assertThat(shortestDistance, (Matcher)IsEqual.equalTo((Object)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingMetric() {
        new EditDistanceFrom(null, (CharSequence)"no go");
    }
}

