/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.translate;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Map;
import org.apache.commons.text.beta.translate.EntityArrays;
import org.junit.Assert;
import org.junit.Test;

public class EntityArraysTest {
    @Test
    public void testConstructorExists() {
        new EntityArrays();
    }

    @Test
    public void testForDuplicatedDeclaredMapKeys() throws Exception {
        String packageDirectory = EntityArraysTest.class.getPackage().getName().replace(".", "/");
        try (BufferedReader br = new BufferedReader(new FileReader("src/main/java/" + packageDirectory + "/EntityArrays.java"));){
            String line;
            int mapDeclarationCounter = 0;
            while ((line = br.readLine()) != null) {
                if (line.contains("new HashMap<>();")) {
                    mapDeclarationCounter = 0;
                    continue;
                }
                if (line.contains(".put(")) {
                    ++mapDeclarationCounter;
                    continue;
                }
                if (!line.contains("Collections.unmodifiableMap(initialMap);")) continue;
                String mapVariableName = line.split("=")[0].trim();
                Map mapValue = (Map)EntityArrays.class.getDeclaredField(mapVariableName).get(EntityArrays.class);
                Assert.assertEquals((long)mapDeclarationCounter, (long)mapValue.keySet().size());
            }
        }
    }

    @Test
    public void testForDuplicateDeclaredMapValuesISO8859Map() {
        Assert.assertEquals((long)EntityArrays.ISO8859_1_ESCAPE.keySet().size(), (long)EntityArrays.ISO8859_1_UNESCAPE.keySet().size());
    }

    @Test
    public void testISO8859Map() {
        this.testEscapeVsUnescapeMaps(EntityArrays.ISO8859_1_ESCAPE, EntityArrays.ISO8859_1_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesHtml40ExtendedMap() {
        Assert.assertEquals((long)EntityArrays.HTML40_EXTENDED_ESCAPE.keySet().size(), (long)EntityArrays.HTML40_EXTENDED_UNESCAPE.keySet().size());
    }

    @Test
    public void testHtml40ExtendedMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.HTML40_EXTENDED_ESCAPE, EntityArrays.HTML40_EXTENDED_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesAposMap() {
        Assert.assertEquals((long)EntityArrays.APOS_ESCAPE.keySet().size(), (long)EntityArrays.APOS_UNESCAPE.keySet().size());
    }

    @Test
    public void testAposMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.APOS_ESCAPE, EntityArrays.APOS_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesBasicMap() {
        Assert.assertEquals((long)EntityArrays.BASIC_ESCAPE.keySet().size(), (long)EntityArrays.BASIC_UNESCAPE.keySet().size());
    }

    @Test
    public void testBasicMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.BASIC_ESCAPE, EntityArrays.BASIC_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesJavaCtrlCharsMap() {
        Assert.assertEquals((long)EntityArrays.JAVA_CTRL_CHARS_ESCAPE.keySet().size(), (long)EntityArrays.JAVA_CTRL_CHARS_UNESCAPE.keySet().size());
    }

    @Test
    public void testJavaCntrlCharsMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.JAVA_CTRL_CHARS_ESCAPE, EntityArrays.JAVA_CTRL_CHARS_UNESCAPE);
    }

    private void testEscapeVsUnescapeMaps(Map<CharSequence, CharSequence> escapeMap, Map<CharSequence, CharSequence> unescapeMap) {
        for (CharSequence escapeKey : escapeMap.keySet()) {
            for (CharSequence unescapeKey : unescapeMap.keySet()) {
                if (escapeKey != unescapeMap.get(unescapeKey)) continue;
                Assert.assertEquals((Object)escapeMap.get(escapeKey), (Object)unescapeKey);
            }
        }
    }
}

