/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LongestCommonSubsequenceDistanceTest {
    private static LongestCommonSubsequenceDistance subject;

    @BeforeClass
    public static void setup() {
        subject = new LongestCommonSubsequenceDistance();
    }

    @Test
    public void testGettingLogestCommonSubsequenceDistacne() {
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((Object)4, (Object)subject.apply((CharSequence)"left", (CharSequence)""));
        Assert.assertEquals((Object)5, (Object)subject.apply((CharSequence)"", (CharSequence)"right"));
        Assert.assertEquals((Object)1, (Object)subject.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assert.assertEquals((Object)6, (Object)subject.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assert.assertEquals((Object)11, (Object)subject.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assert.assertEquals((Object)7, (Object)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assert.assertEquals((Object)4, (Object)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assert.assertEquals((Object)9, (Object)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assert.assertEquals((Object)3, (Object)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assert.assertEquals((Object)7, (Object)subject.apply((CharSequence)"left", (CharSequence)"right"));
        Assert.assertEquals((Object)9, (Object)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceDistanceNullNull() throws Exception {
        subject.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceDistanceStringNull() throws Exception {
        subject.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceDistanceNullString() throws Exception {
        subject.apply(null, (CharSequence)"right");
    }
}

