/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;
import org.junit.Assert;
import org.junit.Test;

public class AggregateTranslatorTest {
    @Test
    public void testNullConstructor() throws Exception {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator((CharSequenceTranslator[])null);
        Assert.assertEquals((Object)"foo", (Object)subject.translate((CharSequence)"foo"));
    }

    @Test
    public void testNullVarargConstructor() throws Exception {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{null});
        Assert.assertEquals((Object)"foo", (Object)subject.translate((CharSequence)"foo"));
    }

    @Test
    public void testNonNull() throws IOException {
        HashMap<String, String> oneTwoMap = new HashMap<String, String>();
        oneTwoMap.put("one", "two");
        HashMap<String, String> threeFourMap = new HashMap<String, String>();
        threeFourMap.put("three", "four");
        LookupTranslator translator1 = new LookupTranslator(oneTwoMap);
        LookupTranslator translator2 = new LookupTranslator(threeFourMap);
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{translator1, translator2});
        StringWriter out1 = new StringWriter();
        int result1 = subject.translate((CharSequence)new StringBuffer("one"), 0, (Writer)out1);
        Assert.assertEquals((String)"Incorrect codepoint consumption", (long)3L, (long)result1);
        Assert.assertEquals((String)"Incorrect value", (Object)"two", (Object)out1.toString());
        StringWriter out2 = new StringWriter();
        int result2 = subject.translate((CharSequence)new StringBuffer("three"), 0, (Writer)out2);
        Assert.assertEquals((String)"Incorrect codepoint consumption", (long)5L, (long)result2);
        Assert.assertEquals((String)"Incorrect value", (Object)"four", (Object)out2.toString());
    }
}

