/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.UnsupportedEncodingException;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.junit.Assert;
import org.junit.Test;

public class JavaUnicodeEscaperTest {
    @Test
    public void testBelow() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assert.assertEquals((String)"Failed to escape Unicode characters via the below method", (Object)"\\u0041\\u0044FGZ", (Object)result);
    }

    @Test
    public void testBetween() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assert.assertEquals((String)"Failed to escape Unicode characters via the between method", (Object)"AD\\u0046\\u0047Z", (Object)result);
    }

    @Test
    public void testAbove() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.above((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assert.assertEquals((String)"Failed to escape Unicode characters via the above method", (Object)"ADF\\u0047\\u005A", (Object)result);
    }

    @Test
    public void testToUtf16Escape() throws UnsupportedEncodingException {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String encoding = jue.toUtf16Escape(Integer.parseInt("024B62", 16));
        Assert.assertEquals((Object)"\\uD852\\uDF62", (Object)encoding);
    }
}

