/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.commons.text.TextRandomProvider;
import org.junit.Assert;
import org.junit.Test;

public class RandomStringGeneratorTest {
    private static final CharacterPredicate A_FILTER = new CharacterPredicate(){

        public boolean test(int codePoint) {
            return codePoint == 97;
        }
    };
    private static final CharacterPredicate B_FILTER = new CharacterPredicate(){

        public boolean test(int codePoint) {
            return codePoint == 98;
        }
    };

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLength() {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        generator.generate(-1);
    }

    private static int codePointLength(String s) {
        return s.codePointCount(0, s.length());
    }

    @Test
    public void testSetLength() {
        int length = 99;
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        String str = generator.generate(99);
        Assert.assertEquals((long)99L, (long)RandomStringGeneratorTest.codePointLength(str));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadMinimumCodePoint() {
        new RandomStringGenerator.Builder().withinRange(-1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadMaximumCodePoint() {
        new RandomStringGenerator.Builder().withinRange(0, 0x110000);
    }

    @Test
    public void testWithinRange() {
        int codePoint;
        int length = 5000;
        int minimumCodePoint = 97;
        int maximumCodePoint = 122;
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange(97, 122).build();
        String str = generator.generate(5000);
        int i = 0;
        do {
            Assert.assertTrue(((codePoint = str.codePointAt(i)) >= 97 && codePoint <= 122 ? 1 : 0) != 0);
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testNoLoneSurrogates() {
        int length = 5000;
        String str = new RandomStringGenerator.Builder().build().generate(5000);
        char lastChar = str.charAt(0);
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLowSurrogate(c)) {
                Assert.assertTrue((boolean)Character.isHighSurrogate(lastChar));
            }
            if (Character.isHighSurrogate(lastChar)) {
                Assert.assertTrue((boolean)Character.isLowSurrogate(c));
            }
            if (Character.isHighSurrogate(c)) {
                Assert.assertTrue((i + 1 < str.length() ? 1 : 0) != 0);
            }
            lastChar = c;
        }
    }

    @Test
    public void testUsingRandom() {
        int testChar = 97;
        TextRandomProvider testRandom = new TextRandomProvider(){

            public int nextInt(int n) {
                return 97;
            }
        };
        String str = new RandomStringGenerator.Builder().usingRandom(testRandom).build().generate(10);
        for (char c : str.toCharArray()) {
            Assert.assertEquals((long)97L, (long)c);
        }
    }

    @Test
    public void testMultipleFilters() {
        String str = new RandomStringGenerator.Builder().withinRange(97, 100).filteredBy(new CharacterPredicate[]{A_FILTER, B_FILTER}).build().generate(5000);
        boolean aFound = false;
        boolean bFound = false;
        for (char c : str.toCharArray()) {
            if (c == 'a') {
                aFound = true;
                continue;
            }
            if (c == 'b') {
                bFound = true;
                continue;
            }
            Assert.fail((String)"Invalid character");
        }
        Assert.assertTrue((aFound && bFound ? 1 : 0) != 0);
    }

    @Test
    public void testNoPrivateCharacters() {
        int codePoint;
        int startOfPrivateBMPChars = 57344;
        String str = new RandomStringGenerator.Builder().withinRange(57344, 65535).build().generate(5000);
        int i = 0;
        do {
            Assert.assertFalse((Character.getType(codePoint = str.codePointAt(i)) == 18 ? 1 : 0) != 0);
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadMinAndMax() throws Exception {
        new RandomStringGenerator.Builder().withinRange(2, 1);
    }

    @Test
    public void testRemoveFilters() {
        RandomStringGenerator.Builder builder = new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        builder.filteredBy(new CharacterPredicate[0]);
        String str = builder.build().generate(100);
        for (char c : str.toCharArray()) {
            if (c == 'a') continue;
            return;
        }
        Assert.fail((String)"Filter appears to have remained in place");
    }

    @Test
    public void testChangeOfFilter() {
        RandomStringGenerator.Builder builder = new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        String str = builder.filteredBy(new CharacterPredicate[]{B_FILTER}).build().generate(100);
        for (char c : str.toCharArray()) {
            Assert.assertTrue((c == 'b' ? 1 : 0) != 0);
        }
    }

    @Test
    public void testZeroLength() {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        Assert.assertEquals((Object)"", (Object)generator.generate(0));
    }
}

