/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.StringsComparator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringsComparatorTest {
    private List<String> before;
    private List<String> after;
    private int[] length;
    private int[] lcs;

    @Test
    public void testLength() {
        for (int i = 0; i < this.before.size(); ++i) {
            StringsComparator comparator = new StringsComparator(this.before.get(i), this.after.get(i));
            Assert.assertEquals((long)this.length[i], (long)comparator.getScript().getModifications());
        }
    }

    @Test
    public void testLongestCommonSubsequence() {
        for (int i = 0; i < this.before.size(); ++i) {
            StringsComparator comparator = new StringsComparator(this.before.get(i), this.after.get(i));
            Assert.assertEquals((long)this.lcs[i], (long)comparator.getScript().getLCSLength());
        }
    }

    @Test
    public void testExecution() {
        for (int i = 0; i < this.before.size(); ++i) {
            ExecutionVisitor ev = new ExecutionVisitor();
            new StringsComparator(this.before.get(i), this.after.get(i)).getScript().visit(ev);
            Assert.assertEquals((Object)this.after.get(i), (Object)ev.getString());
        }
    }

    @Before
    public void setUp() {
        this.before = Arrays.asList("bottle", "nematode knowledge", "", "aa", "prefixed string", "ABCABBA", "glop glop", "coq", "spider-man");
        this.after = Arrays.asList("noodle", "empty bottle", "", "C", "prefix", "CBABAC", "pas glop pas glop", "ane", "klingon");
        this.length = new int[]{6, 16, 0, 3, 9, 5, 8, 6, 13};
        this.lcs = new int[]{3, 7, 0, 0, 6, 4, 9, 0, 2};
    }

    @After
    public void tearDown() {
        this.before = null;
        this.after = null;
        this.length = null;
    }

    private class ExecutionVisitor<T>
    implements CommandVisitor<T> {
        private final StringBuilder v = new StringBuilder();

        public void visitInsertCommand(T object) {
            this.v.append(object);
        }

        public void visitKeepCommand(T object) {
            this.v.append(object);
        }

        public void visitDeleteCommand(T object) {
        }

        public String getString() {
            return this.v.toString();
        }
    }
}

