/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.AlphabetConverter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AlphabetConverterTest {
    private static Character[] lower_case_english = new Character[]{Character.valueOf(' '), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    private static Character[] english_and_numbers = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf(' ')};
    private static Character[] lower_case_english_and_numbers = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf(' ')};
    private static Character[] numbers = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
    private static Character[] binary = new Character[]{Character.valueOf('0'), Character.valueOf('1')};
    private static Character[] hebrew = new Character[]{Character.valueOf('_'), Character.valueOf(' '), Character.valueOf('\u05e7'), Character.valueOf('\u05e8'), Character.valueOf('\u05d0'), Character.valueOf('\u05d8'), Character.valueOf('\u05d5'), Character.valueOf('\u05df'), Character.valueOf('\u05dd'), Character.valueOf('\u05e4'), Character.valueOf('\u05e9'), Character.valueOf('\u05d3'), Character.valueOf('\u05d2'), Character.valueOf('\u05db'), Character.valueOf('\u05e2'), Character.valueOf('\u05d9'), Character.valueOf('\u05d7'), Character.valueOf('\u05dc'), Character.valueOf('\u05da'), Character.valueOf('\u05e3'), Character.valueOf('\u05d6'), Character.valueOf('\u05e1'), Character.valueOf('\u05d1'), Character.valueOf('\u05d4'), Character.valueOf('\u05e0'), Character.valueOf('\u05de'), Character.valueOf('\u05e6'), Character.valueOf('\u05ea'), Character.valueOf('\u05e5')};
    private static Character[] empty = new Character[0];
    private static Integer[] unicode = new Integer[]{32, 35395, 35397, 36302, 36291, 35203, 35201, 35215, 35219, 35268, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 1001, 1002, 1003, 1004, 1005};
    private static Integer[] lower_case_english_codepoints = new Integer[]{32, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static Integer[] doNotEncodePoints = new Integer[]{32, 97, 98, 99};
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void encodeFailureTest() throws UnsupportedEncodingException {
        this.thrown.expect(UnsupportedEncodingException.class);
        this.thrown.expectMessage("Couldn't find encoding for '3'");
        this.test(binary, numbers, empty, "3");
    }

    @Test
    public void binaryTest() throws UnsupportedEncodingException {
        this.test(binary, numbers, empty, "0", "1", "10", "11");
        this.test(numbers, binary, empty, "12345", "0");
        this.test(lower_case_english, binary, empty, "abc", "a");
    }

    @Test
    public void hebrewTest() throws UnsupportedEncodingException {
        this.test(hebrew, binary, empty, "\u05d0", "\u05e2", "\u05d0\u05dc\u05e3_\u05d0\u05d5\u05d4\u05d1\u05dc_\u05d1\u05d9\u05ea_\u05d6\u05d4_\u05d1\u05d9\u05ea_\u05d2\u05d9\u05de\u05dc_\u05d6\u05d4_\u05db\u05de\u05dc_\u05d2\u05d3\u05d5\u05dc");
        this.test(hebrew, numbers, empty, "\u05d0", "\u05e2", "\u05d0\u05dc\u05e3_\u05d0\u05d5\u05d4\u05d1\u05dc_\u05d1\u05d9\u05ea_\u05d6\u05d4_\u05d1\u05d9\u05ea_\u05d2\u05d9\u05de\u05dc_\u05d6\u05d4_\u05db\u05de\u05dc_\u05d2\u05d3\u05d5\u05dc");
        this.test(numbers, hebrew, empty, "123456789", "1", "5");
        this.test(lower_case_english, hebrew, empty, "this is a test");
    }

    @Test
    public void doNotEncodeTest() throws UnsupportedEncodingException {
        this.test(english_and_numbers, lower_case_english_and_numbers, lower_case_english, "1", "456", "abc", "ABC", "this will not be converted but THIS WILL");
        this.test(english_and_numbers, lower_case_english_and_numbers, numbers, "1", "456", "abc", "ABC", "this will be converted but 12345 and this will be");
    }

    private AlphabetConverter createJavadocExample() {
        Character[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')};
        Character[] encoding = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('d')};
        Character[] doNotEncode = new Character[]{Character.valueOf('d')};
        return AlphabetConverter.createConverterFromChars((Character[])original, (Character[])encoding, (Character[])doNotEncode);
    }

    @Test
    public void javadocExampleTest() throws UnsupportedEncodingException {
        AlphabetConverter ac = this.createJavadocExample();
        Assert.assertEquals((Object)"00", (Object)ac.encode("a"));
        Assert.assertEquals((Object)"01", (Object)ac.encode("b"));
        Assert.assertEquals((Object)"0d", (Object)ac.encode("c"));
        Assert.assertEquals((Object)"d", (Object)ac.encode("d"));
        Assert.assertEquals((Object)"00010dd", (Object)ac.encode("abcd"));
    }

    @Test
    public void unexpectedEndwhileDecodingTest() throws UnsupportedEncodingException {
        String toDecode = "00d01d0";
        this.thrown.expect(UnsupportedEncodingException.class);
        this.thrown.expectMessage("Unexpected end of string while decoding 00d01d0");
        AlphabetConverter ac = this.createJavadocExample();
        ac.decode("00d01d0");
    }

    @Test
    public void unexpectedStringWhileDecodingTest() throws UnsupportedEncodingException {
        String toDecode = "00XX";
        this.thrown.expect(UnsupportedEncodingException.class);
        this.thrown.expectMessage("Unexpected string without decoding (XX) in 00XX");
        AlphabetConverter ac = this.createJavadocExample();
        ac.decode("00XX");
    }

    @Test
    public void unicodeTest() throws UnsupportedEncodingException {
        AlphabetConverter ac = AlphabetConverter.createConverter((Integer[])unicode, (Integer[])lower_case_english_codepoints, (Integer[])doNotEncodePoints);
        Assert.assertEquals((long)2L, (long)ac.getEncodedCharLength());
        String original = "\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983";
        String encoded = ac.encode("\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983");
        String decoded = ac.decode(encoded);
        Assert.assertEquals((String)("Encoded '\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983' into '" + encoded + "', but decoded into '" + decoded + "'"), (Object)"\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983", (Object)decoded);
    }

    @Test
    public void noEncodingLettersTest() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Must have at least two encoding characters (excluding those in the 'do not encode' list), but has 0");
        AlphabetConverter.createConverterFromChars((Character[])english_and_numbers, (Character[])numbers, (Character[])numbers);
    }

    @Test
    public void onlyOneEncodingLettersTest() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Must have at least two encoding characters (excluding those in the 'do not encode' list), but has 1");
        Character[] numbersPlusUnderscore = Arrays.copyOf(numbers, numbers.length + 1);
        numbersPlusUnderscore[numbersPlusUnderscore.length - 1] = Character.valueOf('_');
        AlphabetConverter.createConverterFromChars((Character[])english_and_numbers, (Character[])numbersPlusUnderscore, (Character[])numbers);
    }

    @Test
    public void missingDoNotEncodeLettersFromEncodingTest() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Can not use 'do not encode' list because encoding alphabet does not contain");
        AlphabetConverter.createConverterFromChars((Character[])english_and_numbers, (Character[])lower_case_english, (Character[])numbers);
    }

    @Test
    public void missingDoNotEncodeLettersFromOriginalTest() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Can not use 'do not encode' list because original alphabet does not contain");
        AlphabetConverter.createConverterFromChars((Character[])lower_case_english, (Character[])english_and_numbers, (Character[])numbers);
    }

    private void test(Character[] originalChars, Character[] encodingChars, Character[] doNotEncodeChars, String ... strings) throws UnsupportedEncodingException {
        AlphabetConverter ac = AlphabetConverter.createConverterFromChars((Character[])originalChars, (Character[])encodingChars, (Character[])doNotEncodeChars);
        AlphabetConverter reconstructedAlphabetConverter = AlphabetConverter.createConverterFromMap((Map)ac.getOriginalToEncoded());
        Assert.assertEquals((Object)ac, (Object)reconstructedAlphabetConverter);
        Assert.assertEquals((long)ac.hashCode(), (long)reconstructedAlphabetConverter.hashCode());
        Assert.assertEquals((Object)ac.toString(), (Object)reconstructedAlphabetConverter.toString());
        Assert.assertEquals(null, (Object)ac.encode(null));
        Assert.assertEquals((Object)"", (Object)ac.encode(""));
        for (String s : strings) {
            String encoded = ac.encode(s);
            List<Character> originalEncodingChars = Arrays.asList(encodingChars);
            for (int i = 0; i < encoded.length(); ++i) {
                Assert.assertTrue((boolean)originalEncodingChars.contains(Character.valueOf(encoded.charAt(i))));
            }
            String decoded = ac.decode(encoded);
            List<Character> originalCharsList = Arrays.asList(originalChars);
            for (int i = 0; i < decoded.length(); ++i) {
                Assert.assertTrue((boolean)originalCharsList.contains(Character.valueOf(decoded.charAt(i))));
            }
            Assert.assertEquals((String)("Encoded '" + s + "' into '" + encoded + "', but decoded into '" + decoded + "'"), (Object)s, (Object)decoded);
        }
    }
}

