/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrTokenizer;
import org.junit.Assert;
import org.junit.Test;

public class StrBuilderTest {
    static final StrMatcher A_NUMBER_MATCHER = new StrMatcher(){

        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            if (buffer[pos] == 'A' && ++pos < bufferEnd && buffer[pos] >= '0' && buffer[pos] <= '9') {
                return 2;
            }
            return 0;
        }
    };

    @Test
    public void testConstructors() {
        StrBuilder sb0 = new StrBuilder();
        Assert.assertEquals((long)32L, (long)sb0.capacity());
        Assert.assertEquals((long)0L, (long)sb0.length());
        Assert.assertEquals((long)0L, (long)sb0.size());
        StrBuilder sb1 = new StrBuilder(32);
        Assert.assertEquals((long)32L, (long)sb1.capacity());
        Assert.assertEquals((long)0L, (long)sb1.length());
        Assert.assertEquals((long)0L, (long)sb1.size());
        StrBuilder sb2 = new StrBuilder(0);
        Assert.assertEquals((long)32L, (long)sb2.capacity());
        Assert.assertEquals((long)0L, (long)sb2.length());
        Assert.assertEquals((long)0L, (long)sb2.size());
        StrBuilder sb3 = new StrBuilder(-1);
        Assert.assertEquals((long)32L, (long)sb3.capacity());
        Assert.assertEquals((long)0L, (long)sb3.length());
        Assert.assertEquals((long)0L, (long)sb3.size());
        StrBuilder sb4 = new StrBuilder(1);
        Assert.assertEquals((long)1L, (long)sb4.capacity());
        Assert.assertEquals((long)0L, (long)sb4.length());
        Assert.assertEquals((long)0L, (long)sb4.size());
        StrBuilder sb5 = new StrBuilder((String)null);
        Assert.assertEquals((long)32L, (long)sb5.capacity());
        Assert.assertEquals((long)0L, (long)sb5.length());
        Assert.assertEquals((long)0L, (long)sb5.size());
        StrBuilder sb6 = new StrBuilder("");
        Assert.assertEquals((long)32L, (long)sb6.capacity());
        Assert.assertEquals((long)0L, (long)sb6.length());
        Assert.assertEquals((long)0L, (long)sb6.size());
        StrBuilder sb7 = new StrBuilder("foo");
        Assert.assertEquals((long)35L, (long)sb7.capacity());
        Assert.assertEquals((long)3L, (long)sb7.length());
        Assert.assertEquals((long)3L, (long)sb7.size());
    }

    @Test
    public void testChaining() {
        StrBuilder sb = new StrBuilder();
        Assert.assertSame((Object)sb, (Object)sb.setNewLineText(null));
        Assert.assertSame((Object)sb, (Object)sb.setNullText(null));
        Assert.assertSame((Object)sb, (Object)sb.setLength(1));
        Assert.assertSame((Object)sb, (Object)sb.setCharAt(0, 'a'));
        Assert.assertSame((Object)sb, (Object)sb.ensureCapacity(0));
        Assert.assertSame((Object)sb, (Object)sb.minimizeCapacity());
        Assert.assertSame((Object)sb, (Object)sb.clear());
        Assert.assertSame((Object)sb, (Object)sb.reverse());
        Assert.assertSame((Object)sb, (Object)sb.trim());
    }

    @Test
    public void testReadFromReader() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)new StringReader(s));
            Assert.assertEquals((long)s.length(), (long)len);
            Assert.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReaderAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)new StringReader(" 123"));
        Assert.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromCharBuffer() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)CharBuffer.wrap(s));
            Assert.assertEquals((long)s.length(), (long)len);
            Assert.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromCharBufferAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)CharBuffer.wrap(" 123"));
        Assert.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReadable() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)new MockReadable(s));
            Assert.assertEquals((long)s.length(), (long)len);
            Assert.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReadableAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)new MockReadable(" 123"));
        Assert.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testGetSetNewLineText() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals(null, (Object)sb.getNewLineText());
        sb.setNewLineText("#");
        Assert.assertEquals((Object)"#", (Object)sb.getNewLineText());
        sb.setNewLineText("");
        Assert.assertEquals((Object)"", (Object)sb.getNewLineText());
        sb.setNewLineText((String)null);
        Assert.assertEquals(null, (Object)sb.getNewLineText());
    }

    @Test
    public void testGetSetNullText() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals(null, (Object)sb.getNullText());
        sb.setNullText("null");
        Assert.assertEquals((Object)"null", (Object)sb.getNullText());
        sb.setNullText("");
        Assert.assertEquals(null, (Object)sb.getNullText());
        sb.setNullText("NULL");
        Assert.assertEquals((Object)"NULL", (Object)sb.getNullText());
        sb.setNullText((String)null);
        Assert.assertEquals(null, (Object)sb.getNullText());
    }

    @Test
    public void testCapacityAndLength() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)32L, (long)sb.capacity());
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertEquals((long)0L, (long)sb.size());
        Assert.assertTrue((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        Assert.assertEquals((long)0L, (long)sb.capacity());
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertEquals((long)0L, (long)sb.size());
        Assert.assertTrue((boolean)sb.isEmpty());
        sb.ensureCapacity(32);
        Assert.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertEquals((long)0L, (long)sb.size());
        Assert.assertTrue((boolean)sb.isEmpty());
        sb.append("foo");
        Assert.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)sb.length());
        Assert.assertEquals((long)3L, (long)sb.size());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.clear();
        Assert.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertEquals((long)0L, (long)sb.size());
        Assert.assertTrue((boolean)sb.isEmpty());
        sb.append("123456789012345678901234567890123");
        Assert.assertTrue((sb.capacity() > 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)33L, (long)sb.length());
        Assert.assertEquals((long)33L, (long)sb.size());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.ensureCapacity(16);
        Assert.assertTrue((sb.capacity() > 16 ? 1 : 0) != 0);
        Assert.assertEquals((long)33L, (long)sb.length());
        Assert.assertEquals((long)33L, (long)sb.size());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.minimizeCapacity();
        Assert.assertEquals((long)33L, (long)sb.capacity());
        Assert.assertEquals((long)33L, (long)sb.length());
        Assert.assertEquals((long)33L, (long)sb.size());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        try {
            sb.setLength(-1);
            Assert.fail((String)"setLength(-1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.setLength(33);
        Assert.assertEquals((long)33L, (long)sb.capacity());
        Assert.assertEquals((long)33L, (long)sb.length());
        Assert.assertEquals((long)33L, (long)sb.size());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(16);
        Assert.assertTrue((sb.capacity() >= 16 ? 1 : 0) != 0);
        Assert.assertEquals((long)16L, (long)sb.length());
        Assert.assertEquals((long)16L, (long)sb.size());
        Assert.assertEquals((Object)"1234567890123456", (Object)sb.toString());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(32);
        Assert.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)32L, (long)sb.length());
        Assert.assertEquals((long)32L, (long)sb.size());
        Assert.assertEquals((Object)"1234567890123456\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", (Object)sb.toString());
        Assert.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(0);
        Assert.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertEquals((long)0L, (long)sb.size());
        Assert.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testLength() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)0L, (long)sb.length());
        sb.append("Hello");
        Assert.assertEquals((long)5L, (long)sb.length());
    }

    @Test
    public void testSetLength() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.setLength(2);
        Assert.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(2);
        Assert.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(3);
        Assert.assertEquals((Object)"He\u0000", (Object)sb.toString());
        try {
            sb.setLength(-1);
            Assert.fail((String)"setLength(-1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testCapacity() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)sb.buffer.length, (long)sb.capacity());
        sb.append("HelloWorldHelloWorldHelloWorldHelloWorld");
        Assert.assertEquals((long)sb.buffer.length, (long)sb.capacity());
    }

    @Test
    public void testEnsureCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.ensureCapacity(2);
        Assert.assertTrue((sb.capacity() >= 2 ? 1 : 0) != 0);
        sb.ensureCapacity(-1);
        Assert.assertTrue((sb.capacity() >= 0 ? 1 : 0) != 0);
        sb.append("HelloWorld");
        sb.ensureCapacity(40);
        Assert.assertTrue((sb.capacity() >= 40 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimizeCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.minimizeCapacity();
        Assert.assertEquals((long)0L, (long)sb.capacity());
        sb.append("HelloWorld");
        sb.minimizeCapacity();
        Assert.assertEquals((long)10L, (long)sb.capacity());
    }

    @Test
    public void testSize() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)0L, (long)sb.size());
        sb.append("Hello");
        Assert.assertEquals((long)5L, (long)sb.size());
    }

    @Test
    public void testIsEmpty() {
        StrBuilder sb = new StrBuilder();
        Assert.assertTrue((boolean)sb.isEmpty());
        sb.append("Hello");
        Assert.assertFalse((boolean)sb.isEmpty());
        sb.clear();
        Assert.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testClear() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.clear();
        Assert.assertEquals((long)0L, (long)sb.length());
        Assert.assertTrue((sb.buffer.length >= 5 ? 1 : 0) != 0);
    }

    @Test
    public void testCharAt() {
        StrBuilder sb = new StrBuilder();
        try {
            sb.charAt(0);
            Assert.fail((String)"charAt(0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.charAt(-1);
            Assert.fail((String)"charAt(-1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("foo");
        Assert.assertEquals((long)102L, (long)sb.charAt(0));
        Assert.assertEquals((long)111L, (long)sb.charAt(1));
        Assert.assertEquals((long)111L, (long)sb.charAt(2));
        try {
            sb.charAt(-1);
            Assert.fail((String)"charAt(-1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.charAt(3);
            Assert.fail((String)"charAt(3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSetCharAt() {
        StrBuilder sb = new StrBuilder();
        try {
            sb.setCharAt(0, 'f');
            Assert.fail((String)"setCharAt(0,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.setCharAt(-1, 'f');
            Assert.fail((String)"setCharAt(-1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("foo");
        sb.setCharAt(0, 'b');
        sb.setCharAt(1, 'a');
        sb.setCharAt(2, 'r');
        try {
            sb.setCharAt(3, '!');
            Assert.fail((String)"setCharAt(3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"bar", (Object)sb.toString());
    }

    @Test
    public void testDeleteCharAt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.deleteCharAt(0);
        Assert.assertEquals((Object)"bc", (Object)sb.toString());
        try {
            sb.deleteCharAt(1000);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testToCharArray() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)0L, (long)sb.toCharArray().length);
        char[] a = sb.toCharArray();
        Assert.assertNotNull((String)"toCharArray() result is null", (Object)a);
        Assert.assertEquals((String)"toCharArray() result is too large", (long)0L, (long)a.length);
        sb.append("junit");
        a = sb.toCharArray();
        Assert.assertEquals((String)"toCharArray() result incorrect length", (long)5L, (long)a.length);
        Assert.assertTrue((String)"toCharArray() result does not match", (boolean)Arrays.equals("junit".toCharArray(), a));
    }

    @Test
    public void testToCharArrayIntInt() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)0L, (long)sb.toCharArray(0, 0).length);
        sb.append("junit");
        char[] a = sb.toCharArray(0, 20);
        Assert.assertEquals((String)"toCharArray(int,int) result incorrect length", (long)5L, (long)a.length);
        Assert.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("junit".toCharArray(), a));
        a = sb.toCharArray(0, 4);
        Assert.assertEquals((String)"toCharArray(int,int) result incorrect length", (long)4L, (long)a.length);
        Assert.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("juni".toCharArray(), a));
        a = sb.toCharArray(0, 4);
        Assert.assertEquals((String)"toCharArray(int,int) result incorrect length", (long)4L, (long)a.length);
        Assert.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("juni".toCharArray(), a));
        a = sb.toCharArray(0, 1);
        Assert.assertNotNull((String)"toCharArray(int,int) result is null", (Object)a);
        try {
            sb.toCharArray(-1, 5);
            Assert.fail((String)"no string index out of bound on -1");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.toCharArray(6, 5);
            Assert.fail((String)"no string index out of bound on -1");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChars() {
        StrBuilder sb = new StrBuilder();
        char[] input = new char[10];
        char[] a = sb.getChars(input);
        Assert.assertSame((Object)input, (Object)a);
        Assert.assertTrue((boolean)Arrays.equals(new char[10], a));
        sb.append("junit");
        a = sb.getChars(input);
        Assert.assertSame((Object)input, (Object)a);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'j', 'u', 'n', 'i', 't', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, a));
        a = sb.getChars(null);
        Assert.assertNotSame((Object)input, (Object)a);
        Assert.assertEquals((long)5L, (long)a.length);
        Assert.assertTrue((boolean)Arrays.equals("junit".toCharArray(), a));
        input = new char[5];
        a = sb.getChars(input);
        Assert.assertSame((Object)input, (Object)a);
        input = new char[4];
        a = sb.getChars(input);
        Assert.assertNotSame((Object)input, (Object)a);
    }

    @Test
    public void testGetCharsIntIntCharArrayInt() {
        StrBuilder sb = new StrBuilder();
        sb.append("junit");
        char[] a = new char[5];
        sb.getChars(0, 5, a, 0);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'j', 'u', 'n', 'i', 't'}, a));
        a = new char[5];
        sb.getChars(0, 2, a, 3);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\u0000', '\u0000', 'j', 'u'}, a));
        try {
            sb.getChars(-1, 0, a, 0);
            Assert.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(0, -1, a, 0);
            Assert.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(0, 20, a, 0);
            Assert.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(4, 2, a, 0);
            Assert.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIntInt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.delete(0, 1);
        Assert.assertEquals((Object)"bc", (Object)sb.toString());
        sb.delete(1, 2);
        Assert.assertEquals((Object)"b", (Object)sb.toString());
        sb.delete(0, 1);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb.delete(0, 1000);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        try {
            sb.delete(1, 2);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.delete(-1, 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb = new StrBuilder("anything");
        try {
            sb.delete(2, 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteAll_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll('X');
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll('a');
        Assert.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll('c');
        Assert.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll('b');
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll('b');
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_char() {
        StrBuilder sb = new StrBuilder("abcba");
        sb.deleteFirst('X');
        Assert.assertEquals((Object)"abcba", (Object)sb.toString());
        sb.deleteFirst('a');
        Assert.assertEquals((Object)"bcba", (Object)sb.toString());
        sb.deleteFirst('c');
        Assert.assertEquals((Object)"bba", (Object)sb.toString());
        sb.deleteFirst('b');
        Assert.assertEquals((Object)"ba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst('b');
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll((String)null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("X");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("a");
        Assert.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll("c");
        Assert.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll("b");
        Assert.assertEquals((Object)"", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteAll("bc");
        Assert.assertEquals((Object)"acba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll("bc");
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteFirst((String)null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("X");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("a");
        Assert.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.deleteFirst("c");
        Assert.assertEquals((Object)"bbccba", (Object)sb.toString());
        sb.deleteFirst("b");
        Assert.assertEquals((Object)"bccba", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteFirst("bc");
        Assert.assertEquals((Object)"abccba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst("bc");
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteAll((StrMatcher)null);
        Assert.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteAll(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"xy", (Object)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteAll(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteFirst((StrMatcher)null);
        Assert.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteFirst(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"xA1A2yA3", (Object)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteFirst(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst(A_NUMBER_MATCHER);
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReplace_int_int_String() {
        StrBuilder sb = new StrBuilder("abc");
        sb.replace(0, 1, "d");
        Assert.assertEquals((Object)"dbc", (Object)sb.toString());
        sb.replace(0, 1, "aaa");
        Assert.assertEquals((Object)"aaabc", (Object)sb.toString());
        sb.replace(0, 3, "");
        Assert.assertEquals((Object)"bc", (Object)sb.toString());
        sb.replace(1, 2, (String)null);
        Assert.assertEquals((Object)"b", (Object)sb.toString());
        sb.replace(1, 1000, "text");
        Assert.assertEquals((Object)"btext", (Object)sb.toString());
        sb.replace(0, 1000, "text");
        Assert.assertEquals((Object)"text", (Object)sb.toString());
        sb = new StrBuilder("atext");
        sb.replace(1, 1, "ny");
        Assert.assertEquals((Object)"anytext", (Object)sb.toString());
        try {
            sb.replace(2, 1, "anything");
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb = new StrBuilder();
        try {
            sb.replace(1, 2, "anything");
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.replace(-1, 1, "anything");
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceAll_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll('x', 'y');
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll('a', 'd');
        Assert.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll('b', 'e');
        Assert.assertEquals((Object)"dececced", (Object)sb.toString());
        sb.replaceAll('c', 'f');
        Assert.assertEquals((Object)"defeffed", (Object)sb.toString());
        sb.replaceAll('d', 'd');
        Assert.assertEquals((Object)"defeffed", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst('x', 'y');
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst('a', 'd');
        Assert.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst('b', 'e');
        Assert.assertEquals((Object)"decbccba", (Object)sb.toString());
        sb.replaceFirst('c', 'f');
        Assert.assertEquals((Object)"defbccba", (Object)sb.toString());
        sb.replaceFirst('d', 'd');
        Assert.assertEquals((Object)"defbccba", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((String)null, null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((String)null, "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("x", "y");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("a", "d");
        Assert.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll("d", null);
        Assert.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll("cb", "-");
        Assert.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll("b", "xbx");
        Assert.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll("b", "xbx");
        Assert.assertEquals((Object)"xbxxbx", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((String)null, null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((String)null, "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("x", "y");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("a", "d");
        Assert.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst("d", null);
        Assert.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst("cb", "-");
        Assert.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst("b", "xbx");
        Assert.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst("b", "xbx");
        Assert.assertEquals((Object)"xbxb", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((StrMatcher)null, null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((StrMatcher)null, "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'x'), "y");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'a'), "d");
        Assert.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'d'), null);
        Assert.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll(StrMatcher.stringMatcher((String)"cb"), "-");
        Assert.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        Assert.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        Assert.assertEquals((Object)"xbxxbx", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceAll(A_NUMBER_MATCHER, "***");
        Assert.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new StrBuilder("Dear X, hello X.");
        sb.replaceAll(StrMatcher.stringMatcher((String)"X"), "012345678901234567");
        Assert.assertEquals((Object)"Dear 012345678901234567, hello 012345678901234567.", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((StrMatcher)null, null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((StrMatcher)null, "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), null);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), "anything");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'x'), "y");
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'a'), "d");
        Assert.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'d'), null);
        Assert.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.stringMatcher((String)"cb"), "-");
        Assert.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        Assert.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        Assert.assertEquals((Object)"xbxb", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceFirst(A_NUMBER_MATCHER, "***");
        Assert.assertEquals((Object)"***-A2A3-A4", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryMatcher() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace((StrMatcher)null, "x", 0, sb.length(), -1);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replace(StrMatcher.charMatcher((char)'a'), "x", 0, sb.length(), -1);
        Assert.assertEquals((Object)"xbcbccbx", (Object)sb.toString());
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "x", 0, sb.length(), -1);
        Assert.assertEquals((Object)"xbxcxx", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        Assert.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new StrBuilder();
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryReplace() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "cb", 0, sb.length(), -1);
        Assert.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "-", 0, sb.length(), -1);
        Assert.assertEquals((Object)"ab-c-a", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "+++", 0, sb.length(), -1);
        Assert.assertEquals((Object)"ab+++c+++a", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "", 0, sb.length(), -1);
        Assert.assertEquals((Object)"abca", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), null, 0, sb.length(), -1);
        Assert.assertEquals((Object)"abca", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryStartIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, sb.length(), -1);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 1, sb.length(), -1);
        Assert.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, sb.length(), -1);
        Assert.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 3, sb.length(), -1);
        Assert.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 4, sb.length(), -1);
        Assert.assertEquals((Object)"aaxa-ay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 5, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaa-y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 6, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 7, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 8, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 9, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 10, sb.length(), -1);
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 11, sb.length(), -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", -1, sb.length(), -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryEndIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 0, -1);
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 2, -1);
        Assert.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 3, -1);
        Assert.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 4, -1);
        Assert.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 5, -1);
        Assert.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 6, -1);
        Assert.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 7, -1);
        Assert.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 8, -1);
        Assert.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 9, -1);
        Assert.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 1000, -1);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, 1, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryCount() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 0);
        Assert.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 1);
        Assert.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 2);
        Assert.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 3);
        Assert.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 4);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 5);
        Assert.assertEquals((Object)"-x--y-", (Object)sb.toString());
    }

    @Test
    public void testReverse() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.clear().append(true);
        Assert.assertEquals((Object)"eurt", (Object)sb.reverse().toString());
        Assert.assertEquals((Object)"true", (Object)sb.reverse().toString());
    }

    @Test
    public void testTrim() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.clear().append(" \u0000 ");
        Assert.assertEquals((Object)"", (Object)sb.trim().toString());
        sb.clear().append(" \u0000 a b c");
        Assert.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append("a b c \u0000 ");
        Assert.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append(" \u0000 a b c \u0000 ");
        Assert.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append("a b c");
        Assert.assertEquals((Object)"a b c", (Object)sb.trim().toString());
    }

    @Test
    public void testStartsWith() {
        StrBuilder sb = new StrBuilder();
        Assert.assertFalse((boolean)sb.startsWith("a"));
        Assert.assertFalse((boolean)sb.startsWith(null));
        Assert.assertTrue((boolean)sb.startsWith(""));
        sb.append("abc");
        Assert.assertTrue((boolean)sb.startsWith("a"));
        Assert.assertTrue((boolean)sb.startsWith("ab"));
        Assert.assertTrue((boolean)sb.startsWith("abc"));
        Assert.assertFalse((boolean)sb.startsWith("cba"));
    }

    @Test
    public void testEndsWith() {
        StrBuilder sb = new StrBuilder();
        Assert.assertFalse((boolean)sb.endsWith("a"));
        Assert.assertFalse((boolean)sb.endsWith("c"));
        Assert.assertTrue((boolean)sb.endsWith(""));
        Assert.assertFalse((boolean)sb.endsWith(null));
        sb.append("abc");
        Assert.assertTrue((boolean)sb.endsWith("c"));
        Assert.assertTrue((boolean)sb.endsWith("bc"));
        Assert.assertTrue((boolean)sb.endsWith("abc"));
        Assert.assertFalse((boolean)sb.endsWith("cba"));
        Assert.assertFalse((boolean)sb.endsWith("abcd"));
        Assert.assertFalse((boolean)sb.endsWith(" abc"));
        Assert.assertFalse((boolean)sb.endsWith("abc "));
    }

    @Test
    public void testSubSequenceIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        try {
            sb.subSequence(-1, 5);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.subSequence(2, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.subSequence(2, sb.length() + 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.subSequence(3, 2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"hello", (Object)sb.subSequence(0, 5));
        Assert.assertEquals((Object)"hello goodbye".subSequence(0, 6), (Object)sb.subSequence(0, 6));
        Assert.assertEquals((Object)"goodbye", (Object)sb.subSequence(6, 13));
        Assert.assertEquals((Object)"hello goodbye".subSequence(6, 13), (Object)sb.subSequence(6, 13));
    }

    @Test
    public void testSubstringInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        Assert.assertEquals((Object)"goodbye", (Object)sb.substring(6));
        Assert.assertEquals((Object)"hello goodbye".substring(6), (Object)sb.substring(6));
        Assert.assertEquals((Object)"hello goodbye", (Object)sb.substring(0));
        Assert.assertEquals((Object)"hello goodbye".substring(0), (Object)sb.substring(0));
        try {
            sb.substring(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.substring(15);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSubstringIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        Assert.assertEquals((Object)"hello", (Object)sb.substring(0, 5));
        Assert.assertEquals((Object)"hello goodbye".substring(0, 6), (Object)sb.substring(0, 6));
        Assert.assertEquals((Object)"goodbye", (Object)sb.substring(6, 13));
        Assert.assertEquals((Object)"hello goodbye".substring(6, 13), (Object)sb.substring(6, 13));
        Assert.assertEquals((Object)"goodbye", (Object)sb.substring(6, 20));
        try {
            sb.substring(-1, 5);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.substring(15, 20);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testMidString() {
        StrBuilder sb = new StrBuilder("hello goodbye hello");
        Assert.assertEquals((Object)"goodbye", (Object)sb.midString(6, 7));
        Assert.assertEquals((Object)"hello", (Object)sb.midString(0, 5));
        Assert.assertEquals((Object)"hello", (Object)sb.midString(-5, 5));
        Assert.assertEquals((Object)"", (Object)sb.midString(0, -1));
        Assert.assertEquals((Object)"", (Object)sb.midString(20, 2));
        Assert.assertEquals((Object)"hello", (Object)sb.midString(14, 22));
    }

    @Test
    public void testRightString() {
        StrBuilder sb = new StrBuilder("left right");
        Assert.assertEquals((Object)"right", (Object)sb.rightString(5));
        Assert.assertEquals((Object)"", (Object)sb.rightString(0));
        Assert.assertEquals((Object)"", (Object)sb.rightString(-5));
        Assert.assertEquals((Object)"left right", (Object)sb.rightString(15));
    }

    @Test
    public void testLeftString() {
        StrBuilder sb = new StrBuilder("left right");
        Assert.assertEquals((Object)"left", (Object)sb.leftString(4));
        Assert.assertEquals((Object)"", (Object)sb.leftString(0));
        Assert.assertEquals((Object)"", (Object)sb.leftString(-5));
        Assert.assertEquals((Object)"left right", (Object)sb.leftString(15));
    }

    @Test
    public void testContains_char() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        Assert.assertTrue((boolean)sb.contains('a'));
        Assert.assertTrue((boolean)sb.contains('o'));
        Assert.assertTrue((boolean)sb.contains('z'));
        Assert.assertFalse((boolean)sb.contains('1'));
    }

    @Test
    public void testContains_String() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        Assert.assertTrue((boolean)sb.contains("a"));
        Assert.assertTrue((boolean)sb.contains("pq"));
        Assert.assertTrue((boolean)sb.contains("z"));
        Assert.assertFalse((boolean)sb.contains("zyx"));
        Assert.assertFalse((boolean)sb.contains((String)null));
    }

    @Test
    public void testContains_StrMatcher() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        Assert.assertTrue((boolean)sb.contains(StrMatcher.charMatcher((char)'a')));
        Assert.assertTrue((boolean)sb.contains(StrMatcher.stringMatcher((String)"pq")));
        Assert.assertTrue((boolean)sb.contains(StrMatcher.charMatcher((char)'z')));
        Assert.assertFalse((boolean)sb.contains(StrMatcher.stringMatcher((String)"zy")));
        Assert.assertFalse((boolean)sb.contains((StrMatcher)null));
        sb = new StrBuilder();
        Assert.assertFalse((boolean)sb.contains(A_NUMBER_MATCHER));
        sb.append("B A1 C");
        Assert.assertTrue((boolean)sb.contains(A_NUMBER_MATCHER));
    }

    @Test
    public void testIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)0L, (long)sb.indexOf('a'));
        Assert.assertEquals((long)"abab".indexOf(97), (long)sb.indexOf('a'));
        Assert.assertEquals((long)1L, (long)sb.indexOf('b'));
        Assert.assertEquals((long)"abab".indexOf(98), (long)sb.indexOf('b'));
        Assert.assertEquals((long)-1L, (long)sb.indexOf('z'));
    }

    @Test
    public void testIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)0L, (long)sb.indexOf('a', -1));
        Assert.assertEquals((long)0L, (long)sb.indexOf('a', 0));
        Assert.assertEquals((long)2L, (long)sb.indexOf('a', 1));
        Assert.assertEquals((long)-1L, (long)sb.indexOf('a', 4));
        Assert.assertEquals((long)-1L, (long)sb.indexOf('a', 5));
        Assert.assertEquals((long)"abab".indexOf(97, 1), (long)sb.indexOf('a', 1));
        Assert.assertEquals((long)3L, (long)sb.indexOf('b', 2));
        Assert.assertEquals((long)"abab".indexOf(98, 2), (long)sb.indexOf('b', 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        Assert.assertEquals((long)2L, (long)sb.indexOf('z', 0));
        Assert.assertEquals((long)-1L, (long)sb.indexOf('z', 3));
    }

    @Test
    public void testLastIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf('a'));
        Assert.assertEquals((long)"abab".lastIndexOf(97), (long)sb.lastIndexOf('a'));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf('b'));
        Assert.assertEquals((long)"abab".lastIndexOf(98), (long)sb.lastIndexOf('b'));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf('z'));
    }

    @Test
    public void testLastIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf('a', -1));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf('a', 0));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf('a', 1));
        Assert.assertEquals((long)"abab".lastIndexOf(97, 1), (long)sb.lastIndexOf('a', 1));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf('b', 2));
        Assert.assertEquals((long)"abab".lastIndexOf(98, 2), (long)sb.lastIndexOf('b', 2));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf('z', sb.length()));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf('z', 1));
    }

    @Test
    public void testIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)0L, (long)sb.indexOf("a"));
        Assert.assertEquals((long)"abab".indexOf("a"), (long)sb.indexOf("a"));
        Assert.assertEquals((long)0L, (long)sb.indexOf("ab"));
        Assert.assertEquals((long)"abab".indexOf("ab"), (long)sb.indexOf("ab"));
        Assert.assertEquals((long)1L, (long)sb.indexOf("b"));
        Assert.assertEquals((long)"abab".indexOf("b"), (long)sb.indexOf("b"));
        Assert.assertEquals((long)1L, (long)sb.indexOf("ba"));
        Assert.assertEquals((long)"abab".indexOf("ba"), (long)sb.indexOf("ba"));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("z"));
        Assert.assertEquals((long)-1L, (long)sb.indexOf((String)null));
    }

    @Test
    public void testIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)0L, (long)sb.indexOf("a", -1));
        Assert.assertEquals((long)0L, (long)sb.indexOf("a", 0));
        Assert.assertEquals((long)2L, (long)sb.indexOf("a", 1));
        Assert.assertEquals((long)2L, (long)sb.indexOf("a", 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("a", 3));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("a", 4));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("a", 5));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("abcdef", 0));
        Assert.assertEquals((long)0L, (long)sb.indexOf("", 0));
        Assert.assertEquals((long)1L, (long)sb.indexOf("", 1));
        Assert.assertEquals((long)"abab".indexOf("a", 1), (long)sb.indexOf("a", 1));
        Assert.assertEquals((long)2L, (long)sb.indexOf("ab", 1));
        Assert.assertEquals((long)"abab".indexOf("ab", 1), (long)sb.indexOf("ab", 1));
        Assert.assertEquals((long)3L, (long)sb.indexOf("b", 2));
        Assert.assertEquals((long)"abab".indexOf("b", 2), (long)sb.indexOf("b", 2));
        Assert.assertEquals((long)1L, (long)sb.indexOf("ba", 1));
        Assert.assertEquals((long)"abab".indexOf("ba", 2), (long)sb.indexOf("ba", 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        Assert.assertEquals((long)2L, (long)sb.indexOf("za", 0));
        Assert.assertEquals((long)-1L, (long)sb.indexOf("za", 3));
        Assert.assertEquals((long)-1L, (long)sb.indexOf((String)null, 2));
    }

    @Test
    public void testLastIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("a"));
        Assert.assertEquals((long)"abab".lastIndexOf("a"), (long)sb.lastIndexOf("a"));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("ab"));
        Assert.assertEquals((long)"abab".lastIndexOf("ab"), (long)sb.lastIndexOf("ab"));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf("b"));
        Assert.assertEquals((long)"abab".lastIndexOf("b"), (long)sb.lastIndexOf("b"));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf("ba"));
        Assert.assertEquals((long)"abab".lastIndexOf("ba"), (long)sb.lastIndexOf("ba"));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf("z"));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((String)null));
    }

    @Test
    public void testLastIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf("a", -1));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf("a", 0));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf("a", 1));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("a", 2));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("a", 3));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("a", 4));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("a", 5));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf("abcdef", 3));
        Assert.assertEquals((long)"abab".lastIndexOf("", 3), (long)sb.lastIndexOf("", 3));
        Assert.assertEquals((long)"abab".lastIndexOf("", 1), (long)sb.lastIndexOf("", 1));
        Assert.assertEquals((long)"abab".lastIndexOf("a", 1), (long)sb.lastIndexOf("a", 1));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf("ab", 1));
        Assert.assertEquals((long)"abab".lastIndexOf("ab", 1), (long)sb.lastIndexOf("ab", 1));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf("b", 2));
        Assert.assertEquals((long)"abab".lastIndexOf("b", 2), (long)sb.lastIndexOf("b", 2));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf("ba", 2));
        Assert.assertEquals((long)"abab".lastIndexOf("ba", 2), (long)sb.lastIndexOf("ba", 2));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf("za", sb.length()));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf("za", 1));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((String)null, 2));
    }

    @Test
    public void testIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)-1L, (long)sb.indexOf((StrMatcher)null));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        Assert.assertEquals((long)0L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        Assert.assertEquals((long)1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b')));
        Assert.assertEquals((long)2L, (long)sb.indexOf(StrMatcher.spaceMatcher()));
        Assert.assertEquals((long)4L, (long)sb.indexOf(StrMatcher.charMatcher((char)'d')));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.noneMatcher()));
        Assert.assertEquals((long)-1L, (long)sb.indexOf((StrMatcher)null));
        sb.append(" A1 junction");
        Assert.assertEquals((long)6L, (long)sb.indexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)-1L, (long)sb.indexOf((StrMatcher)null, 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        sb.append("ab bd");
        Assert.assertEquals((long)0L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), -2));
        Assert.assertEquals((long)0L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'a'), 20));
        Assert.assertEquals((long)1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), -1));
        Assert.assertEquals((long)1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 0));
        Assert.assertEquals((long)1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 1));
        Assert.assertEquals((long)3L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 2));
        Assert.assertEquals((long)3L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 3));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 4));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 5));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.charMatcher((char)'b'), 6));
        Assert.assertEquals((long)2L, (long)sb.indexOf(StrMatcher.spaceMatcher(), -2));
        Assert.assertEquals((long)2L, (long)sb.indexOf(StrMatcher.spaceMatcher(), 0));
        Assert.assertEquals((long)2L, (long)sb.indexOf(StrMatcher.spaceMatcher(), 2));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.spaceMatcher(), 4));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.spaceMatcher(), 20));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(StrMatcher.noneMatcher(), 0));
        Assert.assertEquals((long)-1L, (long)sb.indexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        Assert.assertEquals((long)6L, (long)sb.indexOf(A_NUMBER_MATCHER, 5));
        Assert.assertEquals((long)6L, (long)sb.indexOf(A_NUMBER_MATCHER, 6));
        Assert.assertEquals((long)23L, (long)sb.indexOf(A_NUMBER_MATCHER, 7));
        Assert.assertEquals((long)23L, (long)sb.indexOf(A_NUMBER_MATCHER, 22));
        Assert.assertEquals((long)23L, (long)sb.indexOf(A_NUMBER_MATCHER, 23));
        Assert.assertEquals((long)-1L, (long)sb.indexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testLastIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((StrMatcher)null));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b')));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher()));
        Assert.assertEquals((long)4L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'d')));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.noneMatcher()));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((StrMatcher)null));
        sb.append(" A1 junction");
        Assert.assertEquals((long)6L, (long)sb.lastIndexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testLastIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((StrMatcher)null, 2));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -1));
        sb.append("ab bd");
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -2));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        Assert.assertEquals((long)0L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 20));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), -1));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 0));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 1));
        Assert.assertEquals((long)1L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 2));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 3));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 4));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 5));
        Assert.assertEquals((long)3L, (long)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 6));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher(), -2));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher(), 0));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher(), 2));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher(), 4));
        Assert.assertEquals((long)2L, (long)sb.lastIndexOf(StrMatcher.spaceMatcher(), 20));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(StrMatcher.noneMatcher(), 0));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 5));
        Assert.assertEquals((long)-1L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 6));
        Assert.assertEquals((long)6L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 7));
        Assert.assertEquals((long)6L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 22));
        Assert.assertEquals((long)6L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 23));
        Assert.assertEquals((long)23L, (long)sb.lastIndexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testAsTokenizer() throws Exception {
        StrBuilder b = new StrBuilder();
        b.append("a b ");
        StrTokenizer t = b.asTokenizer();
        String[] tokens1 = t.getTokenArray();
        Assert.assertEquals((long)2L, (long)tokens1.length);
        Assert.assertEquals((Object)"a", (Object)tokens1[0]);
        Assert.assertEquals((Object)"b", (Object)tokens1[1]);
        Assert.assertEquals((long)2L, (long)t.size());
        b.append("c d ");
        String[] tokens2 = t.getTokenArray();
        Assert.assertEquals((long)2L, (long)tokens2.length);
        Assert.assertEquals((Object)"a", (Object)tokens2[0]);
        Assert.assertEquals((Object)"b", (Object)tokens2[1]);
        Assert.assertEquals((long)2L, (long)t.size());
        Assert.assertEquals((Object)"a", (Object)t.next());
        Assert.assertEquals((Object)"b", (Object)t.next());
        t.reset();
        String[] tokens3 = t.getTokenArray();
        Assert.assertEquals((long)4L, (long)tokens3.length);
        Assert.assertEquals((Object)"a", (Object)tokens3[0]);
        Assert.assertEquals((Object)"b", (Object)tokens3[1]);
        Assert.assertEquals((Object)"c", (Object)tokens3[2]);
        Assert.assertEquals((Object)"d", (Object)tokens3[3]);
        Assert.assertEquals((long)4L, (long)t.size());
        Assert.assertEquals((Object)"a", (Object)t.next());
        Assert.assertEquals((Object)"b", (Object)t.next());
        Assert.assertEquals((Object)"c", (Object)t.next());
        Assert.assertEquals((Object)"d", (Object)t.next());
        Assert.assertEquals((Object)"a b c d ", (Object)t.getContent());
    }

    @Test
    public void testAsReader() throws Exception {
        StrBuilder sb = new StrBuilder("some text");
        Reader reader = sb.asReader();
        Assert.assertTrue((boolean)reader.ready());
        char[] buf = new char[40];
        Assert.assertEquals((long)9L, (long)reader.read(buf));
        Assert.assertEquals((Object)"some text", (Object)new String(buf, 0, 9));
        Assert.assertEquals((long)-1L, (long)reader.read());
        Assert.assertFalse((boolean)reader.ready());
        Assert.assertEquals((long)0L, (long)reader.skip(2L));
        Assert.assertEquals((long)0L, (long)reader.skip(-1L));
        Assert.assertTrue((boolean)reader.markSupported());
        reader = sb.asReader();
        Assert.assertEquals((long)115L, (long)reader.read());
        reader.mark(-1);
        char[] array = new char[3];
        Assert.assertEquals((long)3L, (long)reader.read(array, 0, 3));
        Assert.assertEquals((long)111L, (long)array[0]);
        Assert.assertEquals((long)109L, (long)array[1]);
        Assert.assertEquals((long)101L, (long)array[2]);
        reader.reset();
        Assert.assertEquals((long)1L, (long)reader.read(array, 1, 1));
        Assert.assertEquals((long)111L, (long)array[0]);
        Assert.assertEquals((long)111L, (long)array[1]);
        Assert.assertEquals((long)101L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)reader.skip(2L));
        Assert.assertEquals((long)32L, (long)reader.read());
        Assert.assertTrue((boolean)reader.ready());
        reader.close();
        Assert.assertTrue((boolean)reader.ready());
        reader = sb.asReader();
        array = new char[3];
        try {
            reader.read(array, -1, 0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(array, 0, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(array, 100, 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(array, 0, 100);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(array, Integer.MAX_VALUE, Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)reader.read(array, 0, 0));
        Assert.assertEquals((long)0L, (long)array[0]);
        Assert.assertEquals((long)0L, (long)array[1]);
        Assert.assertEquals((long)0L, (long)array[2]);
        reader.skip(9L);
        Assert.assertEquals((long)-1L, (long)reader.read(array, 0, 1));
        reader.reset();
        array = new char[30];
        Assert.assertEquals((long)9L, (long)reader.read(array, 0, 30));
    }

    @Test
    public void testAsWriter() throws Exception {
        StrBuilder sb = new StrBuilder("base");
        Writer writer = sb.asWriter();
        writer.write(108);
        Assert.assertEquals((Object)"basel", (Object)sb.toString());
        writer.write(new char[]{'i', 'n'});
        Assert.assertEquals((Object)"baselin", (Object)sb.toString());
        writer.write(new char[]{'n', 'e', 'r'}, 1, 2);
        Assert.assertEquals((Object)"baseliner", (Object)sb.toString());
        writer.write(" rout");
        Assert.assertEquals((Object)"baseliner rout", (Object)sb.toString());
        writer.write("ping that server", 1, 3);
        Assert.assertEquals((Object)"baseliner routing", (Object)sb.toString());
        writer.flush();
        Assert.assertEquals((Object)"baseliner routing", (Object)sb.toString());
        writer.close();
        Assert.assertEquals((Object)"baseliner routing", (Object)sb.toString());
        writer.write(" hi");
        Assert.assertEquals((Object)"baseliner routing hi", (Object)sb.toString());
        sb.setLength(4);
        writer.write(100);
        Assert.assertEquals((Object)"based", (Object)sb.toString());
    }

    @Test
    public void testEqualsIgnoreCase() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        Assert.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb1.append("abc");
        Assert.assertFalse((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.append("ABC");
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.clear().append("abc");
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        Assert.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb2.clear().append("aBc");
        Assert.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
    }

    @Test
    public void testEquals() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        Assert.assertTrue((boolean)sb1.equals(sb2));
        Assert.assertTrue((boolean)sb1.equals(sb1));
        Assert.assertTrue((boolean)sb2.equals(sb2));
        Assert.assertTrue((boolean)sb1.equals((Object)sb2));
        sb1.append("abc");
        Assert.assertFalse((boolean)sb1.equals(sb2));
        Assert.assertFalse((boolean)sb1.equals((Object)sb2));
        sb2.append("ABC");
        Assert.assertFalse((boolean)sb1.equals(sb2));
        Assert.assertFalse((boolean)sb1.equals((Object)sb2));
        sb2.clear().append("abc");
        Assert.assertTrue((boolean)sb1.equals(sb2));
        Assert.assertTrue((boolean)sb1.equals((Object)sb2));
        Assert.assertFalse((boolean)sb1.equals((Object)1));
        Assert.assertFalse((boolean)sb1.equals((Object)"abc"));
    }

    @Test
    public void test_LANG_1131_EqualsWithNullStrBuilder() throws Exception {
        StrBuilder sb = new StrBuilder();
        StrBuilder other = null;
        Assert.assertFalse((boolean)sb.equals(other));
    }

    @Test
    public void testHashCode() {
        StrBuilder sb = new StrBuilder();
        int hc1a = sb.hashCode();
        int hc1b = sb.hashCode();
        Assert.assertEquals((long)0L, (long)hc1a);
        Assert.assertEquals((long)hc1a, (long)hc1b);
        sb.append("abc");
        int hc2a = sb.hashCode();
        int hc2b = sb.hashCode();
        Assert.assertTrue((hc2a != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)hc2a, (long)hc2b);
    }

    @Test
    public void testToString() {
        StrBuilder sb = new StrBuilder("abc");
        Assert.assertEquals((Object)"abc", (Object)sb.toString());
    }

    @Test
    public void testToStringBuffer() {
        StrBuilder sb = new StrBuilder();
        Assert.assertEquals((Object)new StringBuffer().toString(), (Object)sb.toStringBuffer().toString());
        sb.append("junit");
        Assert.assertEquals((Object)new StringBuffer("junit").toString(), (Object)sb.toStringBuffer().toString());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testToStringBuilder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.genStringConcat(StringBuilderRewriter.java:193)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.testAppendChain(StringBuilderRewriter.java:180)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:43)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:786)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testLang294() {
        StrBuilder sb = new StrBuilder("\n%BLAH%\nDo more stuff\neven more stuff\n%BLAH%\n");
        sb.deleteAll("\n%BLAH%");
        Assert.assertEquals((Object)"\nDo more stuff\neven more stuff\n", (Object)sb.toString());
    }

    @Test
    public void testIndexOfLang294() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        Assert.assertEquals((long)-1L, (long)sb.indexOf("three"));
    }

    @Test
    public void testLang295() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        Assert.assertFalse((String)"The contains(char) method is looking beyond the end of the string", (boolean)sb.contains('h'));
        Assert.assertEquals((String)"The indexOf(char) method is looking beyond the end of the string", (long)-1L, (long)sb.indexOf('h'));
    }

    @Test
    public void testLang412Right() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(null, 10, '*');
        Assert.assertEquals((String)"Failed to invoke appendFixedWidthPadRight correctly", (Object)"**********", (Object)sb.toString());
    }

    @Test
    public void testLang412Left() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(null, 10, '*');
        Assert.assertEquals((String)"Failed to invoke appendFixedWidthPadLeft correctly", (Object)"**********", (Object)sb.toString());
    }

    @Test
    public void testAsBuilder() {
        StrBuilder sb = new StrBuilder().appendAll((Object[])new String[]{"Lorem", " ", "ipsum", " ", "dolor"});
        Assert.assertEquals((Object)sb.toString(), (Object)sb.build());
    }

    @Test
    public void testAppendCharBuffer() {
        StrBuilder sb1 = new StrBuilder();
        CharBuffer buf = CharBuffer.allocate(10);
        buf.append("0123456789");
        buf.flip();
        sb1.append(buf);
        Assert.assertEquals((Object)"0123456789", (Object)sb1.toString());
        StrBuilder sb2 = new StrBuilder();
        sb2.append(buf, 1, 8);
        Assert.assertEquals((Object)"12345678", (Object)sb2.toString());
    }

    @Test
    public void testAppendToWriter() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringWriter writer = new StringWriter();
        writer.append("Test ");
        sb.appendTo((Appendable)writer);
        Assert.assertEquals((Object)"Test 1234567890", (Object)writer.toString());
    }

    @Test
    public void testAppendToStringBuilder() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringBuilder builder = new StringBuilder("Test ");
        sb.appendTo((Appendable)builder);
        Assert.assertEquals((Object)"Test 1234567890", (Object)builder.toString());
    }

    @Test
    public void testAppendToStringBuffer() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringBuffer buffer = new StringBuffer("Test ");
        sb.appendTo((Appendable)buffer);
        Assert.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    @Test
    public void testAppendToCharBuffer() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        String text = "Test ";
        CharBuffer buffer = CharBuffer.allocate(sb.size() + "Test ".length());
        buffer.put("Test ");
        sb.appendTo((Appendable)buffer);
        buffer.flip();
        Assert.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    private static class MockReadable
    implements Readable {
        private final CharBuffer src;

        public MockReadable(String src) {
            this.src = CharBuffer.wrap(src);
        }

        @Override
        public int read(CharBuffer cb) throws IOException {
            return this.src.read(cb);
        }
    }
}

