/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrSubstitutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StrSubstitutorTest {
    private Map<String, String> values;

    @Before
    public void setUp() throws Exception {
        this.values = new HashMap<String, String>();
        this.values.put("animal", "quick brown fox");
        this.values.put("target", "lazy dog");
    }

    @After
    public void tearDown() throws Exception {
        this.values = null;
    }

    @Test
    public void testReplaceSimple() {
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceSolo() {
        this.doTestReplace("quick brown fox", "${animal}", false);
    }

    @Test
    public void testReplaceNoVariables() {
        this.doTestNoReplace("The balloon arrived.");
    }

    @Test
    public void testReplaceNull() {
        this.doTestNoReplace(null);
    }

    @Test
    public void testReplaceEmpty() {
        this.doTestNoReplace("");
    }

    @Test
    public void testReplaceChangedMap() {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        this.values.put("target", "moon");
        Assert.assertEquals((Object)"The quick brown fox jumps over the moon.", (Object)sub.replace("The ${animal} jumps over the ${target}."));
    }

    @Test
    public void testReplaceUnknownKey() {
        this.doTestReplace("The ${person} jumps over the lazy dog.", "The ${person} jumps over the ${target}.", true);
        this.doTestReplace("The ${person} jumps over the lazy dog. 1234567890.", "The ${person} jumps over the ${target}. ${undefined.number:-1234567890}.", true);
    }

    @Test
    public void testReplaceAdjacentAtStart() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assert.assertEquals((Object)"GBP12.50 charged", (Object)sub.replace("${code}${amount} charged"));
    }

    @Test
    public void testReplaceAdjacentAtEnd() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assert.assertEquals((Object)"Amount is GBP12.50", (Object)sub.replace("Amount is ${code}${amount}"));
    }

    @Test
    public void testReplaceRecursive() {
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
        this.values.put("pet", "${petCharacteristicUnknown:-lazy} dog");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceEscaping() {
        this.doTestReplace("The ${animal} jumps over the lazy dog.", "The $${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceSoloEscaping() {
        this.doTestReplace("${animal}", "$${animal}", false);
    }

    @Test
    public void testReplaceComplexEscaping() {
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog.", "The $${${animal}} jumps over the ${target}.", true);
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog. ${1234567890}.", "The $${${animal}} jumps over the ${target}. $${${undefined.number:-1234567890}}.", true);
    }

    @Test
    public void testReplaceNoPrefixNoSuffix() {
        this.doTestReplace("The animal jumps over the lazy dog.", "The animal jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceIncompletePrefix() {
        this.doTestReplace("The {animal} jumps over the lazy dog.", "The {animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplacePrefixNoSuffix() {
        this.doTestReplace("The ${animal jumps over the ${target} lazy dog.", "The ${animal jumps over the ${target} ${target}.", true);
    }

    @Test
    public void testReplaceNoPrefixSuffix() {
        this.doTestReplace("The animal} jumps over the lazy dog.", "The animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceEmptyKeys() {
        this.doTestReplace("The ${} jumps over the lazy dog.", "The ${} jumps over the ${target}.", true);
        this.doTestReplace("The animal jumps over the lazy dog.", "The ${:-animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceToIdentical() {
        this.values.put("animal", "$${${thing}}");
        this.values.put("thing", "animal");
        this.doTestReplace("The ${animal} jumps.", "The ${animal} jumps.", true);
    }

    @Test
    public void testCyclicReplacement() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("animal", "${critter}");
        map.put("target", "${pet}");
        map.put("pet", "${petCharacteristic} dog");
        map.put("petCharacteristic", "lazy");
        map.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        map.put("critterSpeed", "quick");
        map.put("critterColor", "brown");
        map.put("critterType", "${animal}");
        StrSubstitutor sub = new StrSubstitutor(map);
        try {
            sub.replace("The ${animal} jumps over the ${target}.");
            Assert.fail((String)"Cyclic replacement was not detected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        map.put("critterType", "${animal:-fox}");
        sub = new StrSubstitutor(map);
        try {
            sub.replace("The ${animal} jumps over the ${target}.");
            Assert.fail((String)"Cyclic replacement was not detected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceWeirdPattens() {
        this.doTestNoReplace("");
        this.doTestNoReplace("${}");
        this.doTestNoReplace("${ }");
        this.doTestNoReplace("${\t}");
        this.doTestNoReplace("${\n}");
        this.doTestNoReplace("${\b}");
        this.doTestNoReplace("${");
        this.doTestNoReplace("$}");
        this.doTestNoReplace("}");
        this.doTestNoReplace("${}$");
        this.doTestNoReplace("${${");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${$${}}");
        this.doTestNoReplace("${$$${}}");
        this.doTestNoReplace("${$$${$}}");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${${ }}");
    }

    @Test
    public void testReplacePartialString_noReplace() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertEquals((Object)"${animal} jumps", (Object)sub.replace("The ${animal} jumps over the ${target}.", 4, 15));
    }

    @Test
    public void testReplaceInVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        Assert.assertEquals((String)"Wrong result (1)", (Object)"The mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        Assert.assertEquals((String)"Wrong result (2)", (Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        Assert.assertEquals((String)"Wrong result (3)", (Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${unknown.animal.${unknown.species:-1}:-fox} jumps over the ${unknow.target:-lazy dog}."));
    }

    @Test
    public void testReplaceInVariableDisabled() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assert.assertEquals((String)"Wrong result (1)", (Object)"The ${animal.${species}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        Assert.assertEquals((String)"Wrong result (2)", (Object)"The ${animal.${species:-1}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species:-1}} jumps over the ${target}."));
    }

    @Test
    public void testReplaceInVariableRecursive() {
        this.values.put("animal.2", "brown fox");
        this.values.put("animal.1", "white mouse");
        this.values.put("color", "white");
        this.values.put("species.white", "1");
        this.values.put("species.brown", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        Assert.assertEquals((String)"Wrong result (1)", (Object)"The white mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${color}}} jumps over the ${target}."));
        Assert.assertEquals((String)"Wrong result (2)", (Object)"The brown fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${unknownColor:-brown}}} jumps over the ${target}."));
    }

    @Test
    public void testDefaultValueDelimiters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("animal", "fox");
        map.put("target", "dog");
        StrSubstitutor sub = new StrSubstitutor(map, "${", "}", '$');
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number:-1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "?:");
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number?:1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "||");
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number||1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "!");
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "");
        sub.setValueDelimiterMatcher(null);
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. ${undefined.number!1234567890}.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$');
        sub.setValueDelimiterMatcher(null);
        Assert.assertEquals((Object)"The fox jumps over the lazy dog. ${undefined.number!1234567890}.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
    }

    @Test
    public void testResolveVariable() {
        final StrBuilder builder = new StrBuilder("Hi ${name}!");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map){

            protected String resolveVariable(String variableName, StrBuilder buf, int startPos, int endPos) {
                Assert.assertEquals((Object)"name", (Object)variableName);
                Assert.assertSame((Object)builder, (Object)buf);
                Assert.assertEquals((long)3L, (long)startPos);
                Assert.assertEquals((long)10L, (long)endPos);
                return "jakarta";
            }
        };
        sub.replaceIn(builder);
        Assert.assertEquals((Object)"Hi jakarta!", (Object)builder.toString());
    }

    @Test
    public void testConstructorNoArgs() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertEquals((Object)"Hi ${name}", (Object)sub.replace("Hi ${name}"));
    }

    @Test
    public void testConstructorMapPrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">");
        Assert.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi $< <name>"));
    }

    @Test
    public void testConstructorMapFull() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">", '!');
        Assert.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi !< <name>"));
        sub = new StrSubstitutor(map, "<", ">", '!', "||");
        Assert.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi !< <name2||commons>"));
    }

    @Test
    public void testGetSetEscape() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertEquals((long)36L, (long)sub.getEscapeChar());
        sub.setEscapeChar('<');
        Assert.assertEquals((long)60L, (long)sub.getEscapeChar());
    }

    @Test
    public void testGetSetPrefix() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        sub.setVariablePrefix('<');
        Assert.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.CharMatcher));
        sub.setVariablePrefix("<<");
        Assert.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        try {
            sub.setVariablePrefix((String)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariablePrefixMatcher(matcher);
        Assert.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
        try {
            sub.setVariablePrefixMatcher((StrMatcher)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
    }

    @Test
    public void testGetSetSuffix() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        sub.setVariableSuffix('<');
        Assert.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.CharMatcher));
        sub.setVariableSuffix("<<");
        Assert.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        try {
            sub.setVariableSuffix((String)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariableSuffixMatcher(matcher);
        Assert.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
        try {
            sub.setVariableSuffixMatcher((StrMatcher)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
    }

    @Test
    public void testGetSetValueDelimiter() {
        StrSubstitutor sub = new StrSubstitutor();
        Assert.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof StrMatcher.StringMatcher));
        sub.setValueDelimiter(':');
        Assert.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof StrMatcher.CharMatcher));
        sub.setValueDelimiter("||");
        Assert.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof StrMatcher.StringMatcher));
        sub.setValueDelimiter((String)null);
        Assert.assertNull((Object)sub.getValueDelimiterMatcher());
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setValueDelimiterMatcher(matcher);
        Assert.assertSame((Object)matcher, (Object)sub.getValueDelimiterMatcher());
        sub.setValueDelimiterMatcher((StrMatcher)null);
        Assert.assertNull((Object)sub.getValueDelimiterMatcher());
    }

    @Test
    public void testStaticReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        Assert.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi ${name}!", map));
    }

    @Test
    public void testStaticReplacePrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        Assert.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi <name>!", map, (String)"<", (String)">"));
    }

    @Test
    public void testStaticReplaceSystemProperties() {
        StrBuilder buf = new StrBuilder();
        buf.append("Hi ").append(System.getProperty("user.name"));
        buf.append(", you are working with ");
        buf.append(System.getProperty("os.name"));
        buf.append(", your home directory is ");
        buf.append(System.getProperty("user.home")).append('.');
        Assert.assertEquals((Object)buf.toString(), (Object)StrSubstitutor.replaceSystemProperties((Object)"Hi ${user.name}, you are working with ${os.name}, your home directory is ${user.home}."));
    }

    @Test
    public void testLANG1055() {
        System.setProperty("test_key", "test_value");
        String expected = StrSubstitutor.replace((Object)"test_key=${test_key}", (Properties)System.getProperties());
        String actual = StrSubstitutor.replaceSystemProperties((Object)"test_key=${test_key}");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSubstituteDefaultProperties() {
        String org = "${doesnotwork}";
        System.setProperty("doesnotwork", "It works!");
        Properties props = new Properties(System.getProperties());
        Assert.assertEquals((Object)"It works!", (Object)StrSubstitutor.replace((Object)"${doesnotwork}", (Properties)props));
    }

    @Test
    public void testSamePrefixAndSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("greeting", "Hello");
        map.put(" there ", "XXX");
        map.put("name", "commons");
        Assert.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi @name@!", map, (String)"@", (String)"@"));
        Assert.assertEquals((Object)"Hello there commons!", (Object)StrSubstitutor.replace((Object)"@greeting@ there @name@!", map, (String)"@", (String)"@"));
    }

    @Test
    public void testSubstitutePreserveEscape() {
        String org = "${not-escaped} $${escaped}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("not-escaped", "value");
        StrSubstitutor sub = new StrSubstitutor(map, "${", "}", '$');
        Assert.assertFalse((boolean)sub.isPreserveEscapes());
        Assert.assertEquals((Object)"value ${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
        sub.setPreserveEscapes(true);
        Assert.assertTrue((boolean)sub.isPreserveEscapes());
        Assert.assertEquals((Object)"value $${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
    }

    private void doTestReplace(String expectedResult, String replaceTemplate, boolean substring) {
        String expectedShortResult = expectedResult.substring(1, expectedResult.length() - 1);
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace(replaceTemplate));
        if (substring) {
            Assert.assertEquals((Object)expectedShortResult, (Object)sub.replace(replaceTemplate, 1, replaceTemplate.length() - 2));
        }
        char[] chars = replaceTemplate.toCharArray();
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace(chars));
        if (substring) {
            Assert.assertEquals((Object)expectedShortResult, (Object)sub.replace(chars, 1, chars.length - 2));
        }
        StringBuffer buf = new StringBuffer(replaceTemplate);
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace(buf));
        if (substring) {
            Assert.assertEquals((Object)expectedShortResult, (Object)sub.replace(buf, 1, buf.length() - 2));
        }
        StringBuilder builder = new StringBuilder(replaceTemplate);
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace((CharSequence)builder));
        if (substring) {
            Assert.assertEquals((Object)expectedShortResult, (Object)sub.replace((CharSequence)builder, 1, builder.length() - 2));
        }
        StrBuilder bld = new StrBuilder(replaceTemplate);
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace(bld));
        if (substring) {
            Assert.assertEquals((Object)expectedShortResult, (Object)sub.replace(bld, 1, bld.length() - 2));
        }
        MutableObject obj = new MutableObject((Object)replaceTemplate);
        Assert.assertEquals((Object)expectedResult, (Object)sub.replace((Object)obj));
        buf = new StringBuffer(replaceTemplate);
        Assert.assertTrue((boolean)sub.replaceIn(buf));
        Assert.assertEquals((Object)expectedResult, (Object)buf.toString());
        if (substring) {
            buf = new StringBuffer(replaceTemplate);
            Assert.assertTrue((boolean)sub.replaceIn(buf, 1, buf.length() - 2));
            Assert.assertEquals((Object)expectedResult, (Object)buf.toString());
        }
        builder = new StringBuilder(replaceTemplate);
        Assert.assertTrue((boolean)sub.replaceIn(builder));
        Assert.assertEquals((Object)expectedResult, (Object)builder.toString());
        if (substring) {
            builder = new StringBuilder(replaceTemplate);
            Assert.assertTrue((boolean)sub.replaceIn(builder, 1, builder.length() - 2));
            Assert.assertEquals((Object)expectedResult, (Object)builder.toString());
        }
        bld = new StrBuilder(replaceTemplate);
        Assert.assertTrue((boolean)sub.replaceIn(bld));
        Assert.assertEquals((Object)expectedResult, (Object)bld.toString());
        if (substring) {
            bld = new StrBuilder(replaceTemplate);
            Assert.assertTrue((boolean)sub.replaceIn(bld, 1, bld.length() - 2));
            Assert.assertEquals((Object)expectedResult, (Object)bld.toString());
        }
    }

    private void doTestNoReplace(String replaceTemplate) {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        if (replaceTemplate == null) {
            Assert.assertEquals(null, (Object)sub.replace((String)null));
            Assert.assertEquals(null, (Object)sub.replace((String)null, 0, 100));
            Assert.assertEquals(null, (Object)sub.replace((char[])null));
            Assert.assertEquals(null, (Object)sub.replace((char[])null, 0, 100));
            Assert.assertEquals(null, (Object)sub.replace((StringBuffer)null));
            Assert.assertEquals(null, (Object)sub.replace((StringBuffer)null, 0, 100));
            Assert.assertEquals(null, (Object)sub.replace((StrBuilder)null));
            Assert.assertEquals(null, (Object)sub.replace((StrBuilder)null, 0, 100));
            Assert.assertEquals(null, (Object)sub.replace(null));
            Assert.assertFalse((boolean)sub.replaceIn((StringBuffer)null));
            Assert.assertFalse((boolean)sub.replaceIn((StringBuffer)null, 0, 100));
            Assert.assertFalse((boolean)sub.replaceIn((StrBuilder)null));
            Assert.assertFalse((boolean)sub.replaceIn((StrBuilder)null, 0, 100));
        } else {
            Assert.assertEquals((Object)replaceTemplate, (Object)sub.replace(replaceTemplate));
            StrBuilder bld = new StrBuilder(replaceTemplate);
            Assert.assertFalse((boolean)sub.replaceIn(bld));
            Assert.assertEquals((Object)replaceTemplate, (Object)bld.toString());
        }
    }
}

